/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.DefaultAttributeMap;
import java.util.IdentityHashMap;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@Warmup(iterations=5, time=1)
@Measurement(iterations=5, time=1)
@State(value=Scope.Benchmark)
public class DefaultAttributeMapBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"8", "32", "128"})
    private int keyCount;
    private AttributeKey<Integer>[] keys;
    private IdentityHashMap<AttributeKey<Integer>, Attribute<Integer>> identityHashMap;
    private DefaultAttributeMap attributes;

    @Setup
    public void init() {
        if (Integer.bitCount(this.keyCount) != 1) {
            throw new AssertionError((Object)"keyCount should cbe a power of 2");
        }
        this.attributes = new DefaultAttributeMap();
        this.keys = new AttributeKey[this.keyCount];
        this.identityHashMap = new IdentityHashMap(this.keyCount);
        for (int i = 0; i < this.keyCount; ++i) {
            AttributeKey key;
            this.keys[i] = key = AttributeKey.valueOf((String)Integer.toString(i));
            Attribute attribute = this.attributes.attr(key);
            this.identityHashMap.put((AttributeKey<Integer>)key, (Attribute<Integer>)attribute);
        }
    }

    @Benchmark
    @Threads(value=3)
    public Attribute<Integer> nextAttributeIdentityHashMap(KeySequence sequence) {
        long next = sequence.next();
        AttributeKey<Integer>[] keys = this.keys;
        AttributeKey<Integer> key = keys[(int)(next & (long)(keys.length - 1))];
        return this.identityHashMap.get(key);
    }

    @Benchmark
    @Threads(value=3)
    public boolean hasAttributeIdentityHashMap(KeySequence sequence) {
        long next = sequence.next();
        AttributeKey<Integer>[] keys = this.keys;
        AttributeKey<Integer> key = keys[(int)(next & (long)(keys.length - 1))];
        return this.identityHashMap.containsKey(key);
    }

    @Benchmark
    @Threads(value=3)
    public void mixedAttributeIdentityHashMap(KeySequence sequence, Blackhole hole) {
        long next = sequence.next();
        AttributeKey<Integer>[] keys = this.keys;
        AttributeKey<Integer> key = keys[(int)(next & (long)(keys.length - 1))];
        if (next % 2L == 0L) {
            hole.consume(this.identityHashMap.get(key));
        } else {
            hole.consume(this.identityHashMap.containsKey(key));
        }
    }

    @Benchmark
    @Threads(value=3)
    public Attribute<Integer> nextAttributeAttributeMap(KeySequence sequence) {
        long next = sequence.next();
        AttributeKey<Integer>[] keys = this.keys;
        AttributeKey<Integer> key = keys[(int)(next & (long)(keys.length - 1))];
        return this.attributes.attr(key);
    }

    @Benchmark
    @Threads(value=3)
    public boolean nextHasAttributeAttributeMap(KeySequence sequence) {
        long next = sequence.next();
        AttributeKey<Integer>[] keys = this.keys;
        AttributeKey<Integer> key = keys[(int)(next & (long)(keys.length - 1))];
        return this.attributes.hasAttr(key);
    }

    @Benchmark
    @Threads(value=3)
    public void mixedAttributeAttributeMap(KeySequence sequence, Blackhole hole) {
        long next = sequence.next();
        AttributeKey<Integer>[] keys = this.keys;
        AttributeKey<Integer> key = keys[(int)(next & (long)(keys.length - 1))];
        if (next % 2L == 0L) {
            hole.consume((Object)this.attributes.attr(key));
        } else {
            hole.consume(this.attributes.hasAttr(key));
        }
    }

    @State(value=Scope.Thread)
    public static class KeySequence {
        long nextKey;

        @Setup(value=Level.Iteration)
        public void reset() {
            this.nextKey = 0L;
        }

        public long next() {
            return this.nextKey++;
        }
    }
}

