/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.microbench.handler.ssl.AbstractSslEngineBenchmark;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;

@State(value=Scope.Benchmark)
@Threads(value=1)
public class SslEngineHandshakeBenchmark
extends AbstractSslEngineBenchmark {
    private ByteBufAllocator allocator;

    @Setup(value=Level.Iteration)
    public void setup() {
        this.allocator = new PooledByteBufAllocator(true);
        this.initEngines(this.allocator);
        this.initHandshakeBuffers();
        this.destroyEngines();
    }

    @TearDown(value=Level.Iteration)
    public void teardown() {
        this.destroyHandshakeBuffers();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public boolean handshake() throws Exception {
        this.initEngines(this.allocator);
        boolean ok = this.doHandshake();
        this.destroyEngines();
        assert (ok);
        return ok;
    }
}

