/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.channel.epoll;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.GroupThreads;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;

public class EpollSocketChannelBenchmark
extends AbstractMicrobenchmark {
    private static final Runnable runnable = new Runnable(){

        @Override
        public void run() {
        }
    };
    private EpollEventLoopGroup group;
    private Channel serverChan;
    private Channel chan;
    private ByteBuf abyte;
    private ScheduledFuture<?> future;

    @Setup
    public void setup() throws Exception {
        this.group = new EpollEventLoopGroup(1);
        this.future = this.group.schedule(new Runnable(){

            @Override
            public void run() {
                throw new AssertionError();
            }
        }, 5L, TimeUnit.MINUTES);
        this.serverChan = ((ServerBootstrap)new ServerBootstrap().channel(EpollServerSocketChannel.class)).group((EventLoopGroup)this.group).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelDuplexHandler(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) {
                        if (!(msg instanceof ByteBuf)) {
                            throw new AssertionError();
                        }
                        ctx.writeAndFlush(msg, ctx.voidPromise());
                    }
                }});
            }
        }).bind(0).sync().channel();
        this.chan = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(EpollSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelDuplexHandler(){
                    private ChannelPromise lastWritePromise;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void channelRead(ChannelHandlerContext ctx, Object msg) {
                        block5: {
                            if (msg instanceof ByteBuf) {
                                ByteBuf buf = (ByteBuf)msg;
                                try {
                                    if (buf.readableBytes() == 1) {
                                        this.lastWritePromise.trySuccess();
                                        this.lastWritePromise = null;
                                        break block5;
                                    }
                                    throw new AssertionError();
                                }
                                finally {
                                    buf.release();
                                }
                            }
                            throw new AssertionError();
                        }
                    }

                    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                        if (this.lastWritePromise != null) {
                            throw new IllegalStateException();
                        }
                        this.lastWritePromise = promise;
                        super.write(ctx, msg, ctx.voidPromise());
                    }
                }});
            }
        })).group((EventLoopGroup)this.group)).connect(this.serverChan.localAddress()).sync().channel();
        this.abyte = this.chan.alloc().directBuffer(1);
        this.abyte.writeByte(97);
    }

    @TearDown
    public void tearDown() throws Exception {
        this.chan.close().sync();
        this.serverChan.close().sync();
        this.future.cancel(true);
        this.group.shutdownGracefully(0L, 0L, TimeUnit.SECONDS).sync();
        this.abyte.release();
    }

    @Benchmark
    public Object pingPong() throws Exception {
        return this.chan.pipeline().writeAndFlush((Object)this.abyte.retainedSlice()).sync();
    }

    @Benchmark
    public Object executeSingle() throws Exception {
        return this.chan.eventLoop().submit(runnable).get();
    }

    @Benchmark
    @GroupThreads(value=3)
    public Object executeMulti() throws Exception {
        return this.chan.eventLoop().submit(runnable).get();
    }
}

