/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import io.netty.buffer.UnpooledUnsafeHeapByteBuf;
import io.netty.buffer.WrappedByteBuf;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@Warmup(iterations=5, time=1500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=1500, timeUnit=TimeUnit.MILLISECONDS)
@Fork(value=3)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class ByteBufAccessBenchmark
extends AbstractMicrobenchmark {
    @Param
    public ByteBufType bufferType;
    @Param(value={"true", "false"})
    public String checkAccessible;
    @Param(value={"true", "false"})
    public String checkBounds;
    @Param(value={"8"})
    public int batchSize;
    private ByteBuf buffer;

    @Setup
    public void setup() {
        System.setProperty("io.netty.buffer.checkAccessible", this.checkAccessible);
        System.setProperty("io.netty.buffer.checkBounds", this.checkBounds);
        this.buffer = this.bufferType.newBuffer();
    }

    @TearDown
    public void tearDown() {
        this.buffer.release();
        System.clearProperty("io.netty.buffer.checkAccessible");
        System.clearProperty("io.netty.buffer.checkBounds");
    }

    @Benchmark
    public long setGetLong() {
        return this.buffer.setLong(0, 1L).getLong(0);
    }

    @Benchmark
    public ByteBuf setLong() {
        return this.buffer.setLong(0, 1L);
    }

    @Benchmark
    public int readBatch() {
        this.buffer.readerIndex(0).touch();
        int result = 0;
        int size = this.batchSize;
        for (int i = 0; i < size; ++i) {
            result += this.buffer.readByte();
        }
        return result;
    }

    public static enum ByteBufType {
        UNSAFE{

            @Override
            ByteBuf newBuffer() {
                return new UnpooledUnsafeDirectByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, 64, 64).setIndex(0, 64);
            }
        }
        ,
        UNSAFE_SLICE{

            @Override
            ByteBuf newBuffer() {
                return UNSAFE.newBuffer().slice(16, 48);
            }
        }
        ,
        HEAP{

            @Override
            ByteBuf newBuffer() {
                return new UnpooledUnsafeHeapByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, 64, 64).setIndex(0, 64);
            }
        }
        ,
        COMPOSITE{

            @Override
            ByteBuf newBuffer() {
                return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{UNSAFE.newBuffer(), HEAP.newBuffer()});
            }
        }
        ,
        NIO{

            @Override
            ByteBuf newBuffer() {
                return new NioFacade(ByteBuffer.allocateDirect(64));
            }
        };


        abstract ByteBuf newBuffer();
    }

    static final class NioFacade
    extends WrappedByteBuf {
        private final ByteBuffer byteBuffer;

        NioFacade(ByteBuffer byteBuffer) {
            super(Unpooled.EMPTY_BUFFER);
            this.byteBuffer = byteBuffer;
        }

        public ByteBuf setLong(int index, long value) {
            this.byteBuffer.putLong(index, value);
            return this;
        }

        public long getLong(int index) {
            return this.byteBuffer.getLong(index);
        }

        public byte readByte() {
            return this.byteBuffer.get();
        }

        public ByteBuf touch() {
            this.byteBuffer.position(0);
            return this;
        }

        public boolean release() {
            PlatformDependent.freeDirectBuffer((ByteBuffer)this.byteBuffer);
            return true;
        }
    }
}

