/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.redis;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.redis.ArrayRedisMessage;
import io.netty.handler.codec.redis.FullBulkStringRedisMessage;
import io.netty.handler.codec.redis.RedisEncoder;
import io.netty.microbench.channel.EmbeddedChannelWriteReleaseHandlerContext;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.microbench.util.AbstractMicrobenchmarkBase;
import java.util.ArrayList;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Threads(value=1)
@Warmup(iterations=5)
@Measurement(iterations=5)
public class RedisEncoderBenchmark
extends AbstractMicrobenchmark {
    private RedisEncoder encoder;
    private ByteBuf content;
    private ChannelHandlerContext context;
    private ArrayRedisMessage redisArray;
    @Param(value={"true", "false"})
    public boolean pooledAllocator;
    @Param(value={"true", "false"})
    public boolean voidPromise;
    @Param(value={"50", "200", "1000"})
    public int arraySize;

    @Setup(value=Level.Trial)
    public void setup() {
        byte[] bytes = new byte[256];
        this.content = Unpooled.buffer((int)bytes.length);
        this.content.writeBytes(bytes);
        ByteBuf testContent = Unpooled.unreleasableBuffer((ByteBuf)this.content.asReadOnly());
        ArrayList<FullBulkStringRedisMessage> rList = new ArrayList<FullBulkStringRedisMessage>(this.arraySize);
        for (int i = 0; i < this.arraySize; ++i) {
            rList.add(new FullBulkStringRedisMessage(testContent));
        }
        this.redisArray = new ArrayRedisMessage(rList);
        this.encoder = new RedisEncoder();
        this.context = new EmbeddedChannelWriteReleaseHandlerContext((ByteBufAllocator)(this.pooledAllocator ? PooledByteBufAllocator.DEFAULT : UnpooledByteBufAllocator.DEFAULT), (ChannelHandler)this.encoder){

            @Override
            protected void handleException(Throwable t) {
                AbstractMicrobenchmarkBase.handleUnexpectedException(t);
            }
        };
    }

    @TearDown(value=Level.Trial)
    public void teardown() {
        this.content.release();
        this.content = null;
    }

    @Benchmark
    public void writeArray() throws Exception {
        this.encoder.write(this.context, (Object)this.redisArray.retain(), this.newPromise());
    }

    private ChannelPromise newPromise() {
        return this.voidPromise ? this.context.voidPromise() : this.context.newPromise();
    }
}

