/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.microbench.util.AbstractMicrobenchmark;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@Warmup(iterations=5)
@Measurement(iterations=5)
@State(value=Scope.Benchmark)
public class DefaultChannelPipelineBenchmark
extends AbstractMicrobenchmark {
    private static final ChannelHandler NOOP_HANDLER = new ChannelInboundHandlerAdapter(){

        public boolean isSharable() {
            return true;
        }
    };
    private static final ChannelHandler CONSUMING_HANDLER = new ChannelInboundHandlerAdapter(){

        public void channelReadComplete(ChannelHandlerContext ctx) {
        }

        public boolean isSharable() {
            return true;
        }
    };
    @Param(value={"4"})
    public int extraHandlers;
    private ChannelPipeline pipeline;

    @Setup(value=Level.Iteration)
    public void setup() {
        this.pipeline = new EmbeddedChannel().pipeline();
        for (int i = 0; i < this.extraHandlers; ++i) {
            this.pipeline.addLast(new ChannelHandler[]{NOOP_HANDLER});
        }
        this.pipeline.addLast(new ChannelHandler[]{CONSUMING_HANDLER});
    }

    @TearDown
    public void tearDown() {
        this.pipeline.channel().close();
    }

    @Benchmark
    public void propagateEvent(Blackhole hole) {
        for (int i = 0; i < 100; ++i) {
            hole.consume((Object)this.pipeline.fireChannelReadComplete());
        }
    }
}

