/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Warmup(iterations=5, time=1)
@Measurement(iterations=5, time=1)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
public class DecodeHexBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"135aBa9BBCEA030b947d79fCcaf48Bde", "4DDeA5gDD1C6fE567E1b6gf0C40FEcDg"})
    private String hex;
    private char[] hexDigits;
    private static final byte[] HEX2B = new byte[103];

    @Setup
    public void init() {
        this.hexDigits = this.hex.toCharArray();
    }

    @Benchmark
    public long hexDigits() {
        long v = 0L;
        char[] hexDigits = this.hexDigits;
        int size = hexDigits.length;
        for (int i = 0; i < size; ++i) {
            v += (long)StringUtil.decodeHexNibble((char)hexDigits[i]);
        }
        return v;
    }

    @Benchmark
    public long hexDigitsWithChecks() {
        long v = 0L;
        char[] hexDigits = this.hexDigits;
        int size = hexDigits.length;
        for (int i = 0; i < size; ++i) {
            v += (long)DecodeHexBenchmark.decodeHexNibbleWithCheck(hexDigits[i]);
        }
        return v;
    }

    @Benchmark
    public long hexDigitsOriginal() {
        long v = 0L;
        char[] hexDigits = this.hexDigits;
        int size = hexDigits.length;
        for (int i = 0; i < size; ++i) {
            v += (long)DecodeHexBenchmark.decodeHexNibble(hexDigits[i]);
        }
        return v;
    }

    private static int decodeHexNibble(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 55;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 87;
        }
        return -1;
    }

    private static int decodeHexNibbleWithCheck(char c) {
        char index = c;
        if (index >= HEX2B.length) {
            return -1;
        }
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.getByte((byte[])HEX2B, (int)index);
        }
        return HEX2B[index];
    }

    static {
        Arrays.fill(HEX2B, (byte)-1);
        DecodeHexBenchmark.HEX2B[48] = 0;
        DecodeHexBenchmark.HEX2B[49] = 1;
        DecodeHexBenchmark.HEX2B[50] = 2;
        DecodeHexBenchmark.HEX2B[51] = 3;
        DecodeHexBenchmark.HEX2B[52] = 4;
        DecodeHexBenchmark.HEX2B[53] = 5;
        DecodeHexBenchmark.HEX2B[54] = 6;
        DecodeHexBenchmark.HEX2B[55] = 7;
        DecodeHexBenchmark.HEX2B[56] = 8;
        DecodeHexBenchmark.HEX2B[57] = 9;
        DecodeHexBenchmark.HEX2B[65] = 10;
        DecodeHexBenchmark.HEX2B[66] = 11;
        DecodeHexBenchmark.HEX2B[67] = 12;
        DecodeHexBenchmark.HEX2B[68] = 13;
        DecodeHexBenchmark.HEX2B[69] = 14;
        DecodeHexBenchmark.HEX2B[70] = 15;
        DecodeHexBenchmark.HEX2B[97] = 10;
        DecodeHexBenchmark.HEX2B[98] = 11;
        DecodeHexBenchmark.HEX2B[99] = 12;
        DecodeHexBenchmark.HEX2B[100] = 13;
        DecodeHexBenchmark.HEX2B[101] = 14;
        DecodeHexBenchmark.HEX2B[102] = 15;
    }
}

