/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.http;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.CharsetUtil;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Warmup(iterations=10)
@Measurement(iterations=20)
public class HttpRequestDecoderBenchmark
extends AbstractMicrobenchmark {
    private static final byte[] CONTENT_MIXED_DELIMITERS = HttpRequestDecoderBenchmark.createContent("\r\n", "\n");
    private static final int CONTENT_LENGTH = 120;
    @Param(value={"2", "4", "8", "16", "32"})
    public int step;

    private static byte[] createContent(String ... lineDelimiters) {
        String lineDelimiter2;
        String lineDelimiter;
        if (lineDelimiters.length == 2) {
            lineDelimiter = lineDelimiters[0];
            lineDelimiter2 = lineDelimiters[1];
        } else {
            lineDelimiter = lineDelimiters[0];
            lineDelimiter2 = lineDelimiters[0];
        }
        return ("GET /some/path?foo=bar&wibble=eek HTTP/1.1\r\nUpgrade: WebSocket" + lineDelimiter2 + "Connection: Upgrade" + lineDelimiter + "Host: localhost" + lineDelimiter2 + "Referer: http://www.site.ru/index.html" + lineDelimiter + "User-Agent: Mozilla/5.0 (X11; U; Linux i686; ru; rv:1.9b5) Gecko/2008050509 Firefox/3.0b5" + lineDelimiter2 + "Accept: text/html" + lineDelimiter + "Cookie: income=1" + lineDelimiter2 + "Origin: http://localhost:8080" + lineDelimiter + "Sec-WebSocket-Key1: 10  28 8V7 8 48     0" + lineDelimiter2 + "Sec-WebSocket-Key2: 8 Xt754O3Q3QW 0   _60" + lineDelimiter + "Content-Type: application/x-www-form-urlencoded" + lineDelimiter2 + "Content-Length: " + 120 + lineDelimiter + "\r\n1234567890\r\n1234567890\r\n1234567890\r\n1234567890\r\n1234567890\r\n1234567890\r\n1234567890\r\n1234567890\r\n1234567890\r\n1234567890\r\n").getBytes(CharsetUtil.US_ASCII);
    }

    @Benchmark
    public void testDecodeWholeRequestInMultipleStepsMixedDelimiters() {
        HttpRequestDecoderBenchmark.testDecodeWholeRequestInMultipleSteps(CONTENT_MIXED_DELIMITERS, this.step);
    }

    private static void testDecodeWholeRequestInMultipleSteps(byte[] content, int fragmentSize) {
        int amount;
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder()});
        int headerLength = content.length - 120;
        for (int a = 0; a < headerLength; a += amount) {
            amount = fragmentSize;
            if (a + amount > headerLength) {
                amount = headerLength - a;
            }
            channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])content, (int)a, (int)amount).asReadOnly()});
        }
        for (int i = 120; i > 0; --i) {
            channel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])content, (int)(content.length - i), (int)1).asReadOnly()});
        }
    }
}

