/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@Threads(value=1)
@Warmup(iterations=3)
@Measurement(iterations=3)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
public class QueryStringDecoderBenchmark
extends AbstractMicrobenchmark {
    private static final Charset SHIFT_JIS = Charset.forName("Shift-JIS");

    @Benchmark
    public Map<String, List<String>> noDecoding() {
        return new QueryStringDecoder("foo=bar&cat=dog", false).parameters();
    }

    @Benchmark
    public Map<String, List<String>> onlyDecoding() {
        return new QueryStringDecoder("%E3%81%BB%E3%81%92=%E3%81%BC%E3%81%91&%E3%81%AD%E3%81%93=%E3%81%84%E3%81%AC", false).parameters();
    }

    @Benchmark
    public Map<String, List<String>> mixedDecoding() {
        return new QueryStringDecoder("foo=bar%E3%81%BB%E3%81%92=%E3%81%BC%E3%81%91&cat=dog&&%E3%81%AD%E3%81%93=%E3%81%84%E3%81%AC", false).parameters();
    }

    @Benchmark
    public Map<String, List<String>> nonStandardDecoding() {
        return new QueryStringDecoder("%82%D9%82%B0=%82%DA%82%AF&%82%CB%82%B1=%82%A2%82%CA", SHIFT_JIS, false).parameters();
    }
}

