/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=12, time=1, timeUnit=TimeUnit.SECONDS)
public class CompositeByteBufWriteOutBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"64", "1024", "10240", "102400", "1024000"})
    public int size;
    @Param
    public ByteBufType bufferType;
    private ByteBuf targetBuffer;
    private ByteBuf[] sourceBufs;

    @Override
    protected String[] jvmArgs() {
        return new String[]{"-XX:MaxDirectMemorySize=2g", "-Xmx4g", "-Xms4g", "-Xmn3g"};
    }

    @Setup
    public void setup() {
        this.targetBuffer = PooledByteBufAllocator.DEFAULT.directBuffer(this.size + 2048);
        this.sourceBufs = this.bufferType.sourceBuffers(this.size);
    }

    @TearDown
    public void teardown() {
        this.targetBuffer.release();
    }

    @Benchmark
    public int writeCBB() {
        ByteBuf cbb = Unpooled.wrappedBuffer((int)Integer.MAX_VALUE, (ByteBuf[])this.sourceBufs);
        return this.targetBuffer.clear().writeBytes(cbb).readableBytes();
    }

    @Benchmark
    public int writeFCBB() {
        ByteBuf cbb = Unpooled.wrappedUnmodifiableBuffer((ByteBuf[])this.sourceBufs);
        return this.targetBuffer.clear().writeBytes(cbb).readableBytes();
    }

    private static ByteBuf[] makeSmallChunks(int length) {
        ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>((length + 1) / 48 * 9);
        for (int i = 0; i < length + 48; i += 48) {
            for (int j = 4; j <= 12; ++j) {
                buffers.add(Unpooled.wrappedBuffer((byte[])new byte[j]));
            }
        }
        return buffers.toArray(new ByteBuf[0]);
    }

    private static ByteBuf[] makeLargeChunks(int length) {
        ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>((length + 1) / 768);
        for (int i = 0; i < length + 1536; i += 1536) {
            buffers.add(Unpooled.wrappedBuffer((byte[])new byte[512]));
            buffers.add(Unpooled.wrappedBuffer((byte[])new byte[1024]));
        }
        return buffers.toArray(new ByteBuf[0]);
    }

    public static enum ByteBufType {
        SMALL_CHUNKS{

            @Override
            ByteBuf[] sourceBuffers(int length) {
                return CompositeByteBufWriteOutBenchmark.makeSmallChunks(length);
            }
        }
        ,
        LARGE_CHUNKS{

            @Override
            ByteBuf[] sourceBuffers(int length) {
                return CompositeByteBufWriteOutBenchmark.makeLargeChunks(length);
            }
        };


        abstract ByteBuf[] sourceBuffers(int var1);
    }
}

