/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@Threads(value=1)
@Warmup(iterations=3)
@Measurement(iterations=3)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
public class WriteBytesVsShortOrMediumBenchmark
extends AbstractMicrobenchmark {
    private static final int CRLF_SHORT = 3338;
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final int ZERO_CRLF_MEDIUM = 3149066;
    private static final byte[] ZERO_CRLF = new byte[]{48, 13, 10};
    private final ByteBuf buf = Unpooled.directBuffer((int)16);

    @Benchmark
    public ByteBuf shortInt() {
        return ByteBufUtil.writeShortBE((ByteBuf)this.buf, (int)3338).resetWriterIndex();
    }

    @Benchmark
    public ByteBuf mediumInt() {
        return ByteBufUtil.writeMediumBE((ByteBuf)this.buf, (int)3149066).resetWriterIndex();
    }

    @Benchmark
    public ByteBuf byteArray2() {
        return this.buf.writeBytes(CRLF).resetWriterIndex();
    }

    @Benchmark
    public ByteBuf byteArray3() {
        return this.buf.writeBytes(ZERO_CRLF).resetWriterIndex();
    }

    @Benchmark
    public ByteBuf chainedBytes2() {
        return this.buf.writeByte(13).writeByte(10).resetWriterIndex();
    }

    @Benchmark
    public ByteBuf chainedBytes3() {
        return this.buf.writeByte(48).writeByte(13).writeByte(10).resetWriterIndex();
    }
}

