/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.microbench.handler.ssl.AbstractSslEngineBenchmark;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;

public abstract class AbstractSslEngineThroughputBenchmark
extends AbstractSslEngineBenchmark {
    @Param(value={"64", "128", "512", "1024", "4096"})
    public int messageSize;
    protected ByteBuffer wrapSrcBuffer;
    private ByteBuffer wrapDstBuffer;

    @Setup(value=Level.Iteration)
    public final void setup() throws Exception {
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(true);
        this.initEngines((ByteBufAllocator)allocator);
        this.initHandshakeBuffers();
        this.wrapDstBuffer = this.allocateBuffer(this.clientEngine.getSession().getPacketBufferSize() << 2);
        this.wrapSrcBuffer = this.allocateBuffer(this.messageSize);
        byte[] bytes = new byte[this.messageSize];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        this.wrapSrcBuffer.put(bytes);
        this.wrapSrcBuffer.flip();
        if (!this.doHandshake()) {
            throw new IllegalStateException();
        }
        this.doSetup();
    }

    protected void doSetup() throws Exception {
    }

    @TearDown(value=Level.Iteration)
    public final void tearDown() throws Exception {
        this.destroyEngines();
        this.destroyHandshakeBuffers();
        this.freeBuffer(this.wrapSrcBuffer);
        this.freeBuffer(this.wrapDstBuffer);
        this.doTearDown();
    }

    protected void doTearDown() throws Exception {
    }

    protected final ByteBuffer doWrap(int numWraps) throws SSLException {
        this.wrapDstBuffer.clear();
        for (int i = 0; i < numWraps; ++i) {
            this.wrapSrcBuffer.position(0).limit(this.messageSize);
            SSLEngineResult wrapResult = this.clientEngine.wrap(this.wrapSrcBuffer, this.wrapDstBuffer);
            assert (AbstractSslEngineThroughputBenchmark.checkSslEngineResult(wrapResult, this.wrapSrcBuffer, this.wrapDstBuffer));
        }
        return this.wrapDstBuffer;
    }
}

