/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.concurrent;

import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.internal.PlatformDependent;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Benchmark)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class BurstCostExecutorsBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"1", "10"})
    private int burstLength;
    @Param(value={"spinning", "epollEventLoop", "nioEventLoop", "defaultEventExecutor", "juc", "kqueueEventLoop"})
    private String executorType;
    @Param(value={"0", "10"})
    private int work;
    private ExecutorService executor;
    private ExecutorService executorToShutdown;

    @Setup
    public void setup() {
        ExecutorType type = ExecutorType.valueOf(this.executorType);
        switch (type) {
            case spinning: {
                this.executorToShutdown = this.executor = new SpinExecutorService(Math.min(1024, this.burstLength * 4));
                break;
            }
            case defaultEventExecutor: {
                this.executorToShutdown = this.executor = new DefaultEventExecutor();
                break;
            }
            case juc: {
                this.executorToShutdown = this.executor = Executors.newSingleThreadScheduledExecutor();
                break;
            }
            case nioEventLoop: {
                NioEventLoopGroup nioEventLoopGroup = new NioEventLoopGroup(1);
                nioEventLoopGroup.setIoRatio(1);
                this.executor = nioEventLoopGroup.next();
                this.executorToShutdown = nioEventLoopGroup;
                break;
            }
            case epollEventLoop: {
                Epoll.ensureAvailability();
                EpollEventLoopGroup epollEventLoopGroup = new EpollEventLoopGroup(1);
                epollEventLoopGroup.setIoRatio(1);
                this.executor = epollEventLoopGroup.next();
                this.executorToShutdown = epollEventLoopGroup;
                break;
            }
            case kqueueEventLoop: {
                KQueue.ensureAvailability();
                KQueueEventLoopGroup kQueueEventLoopGroup = new KQueueEventLoopGroup(1);
                kQueueEventLoopGroup.setIoRatio(1);
                this.executor = kQueueEventLoopGroup.next();
                this.executorToShutdown = kQueueEventLoopGroup;
            }
        }
    }

    @TearDown
    public void tearDown() {
        this.executorToShutdown.shutdown();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SampleTime})
    @Threads(value=1)
    public int test1Producer(PerThreadState state) {
        return this.executeBurst(state);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SampleTime})
    @Threads(value=2)
    public int test2Producers(PerThreadState state) {
        return this.executeBurst(state);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.SampleTime})
    @Threads(value=3)
    public int test3Producers(PerThreadState state) {
        return this.executeBurst(state);
    }

    private int executeBurst(PerThreadState state) {
        ExecutorService executor = this.executor;
        int burstLength = this.burstLength;
        Runnable completeTask = state.completeTask;
        for (int i = 0; i < burstLength; ++i) {
            executor.execute(completeTask);
        }
        int value = state.spinWaitCompletionOf(burstLength);
        state.resetCompleted();
        return value;
    }

    @State(value=Scope.Thread)
    public static class PerThreadState {
        private static final AtomicIntegerFieldUpdater<PerThreadState> DONE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PerThreadState.class, "completed");
        private volatile int completed;
        private Runnable completeTask;

        @Setup
        public void setup(BurstCostExecutorsBenchmark bench) {
            final int work = bench.work;
            this.completeTask = work > 0 ? new Runnable(){

                @Override
                public void run() {
                    Blackhole.consumeCPU((long)work);
                    DONE_UPDATER.lazySet(PerThreadState.this, PerThreadState.this.completed + 1);
                }
            } : new Runnable(){

                @Override
                public void run() {
                    DONE_UPDATER.lazySet(PerThreadState.this, PerThreadState.this.completed + 1);
                }
            };
        }

        public void resetCompleted() {
            DONE_UPDATER.lazySet(this, 0);
        }

        public int spinWaitCompletionOf(int value) {
            int lastRead;
            while ((lastRead = this.completed) < value) {
            }
            return lastRead;
        }
    }

    private static enum ExecutorType {
        spinning,
        defaultEventExecutor,
        juc,
        nioEventLoop,
        epollEventLoop,
        kqueueEventLoop;

    }

    private static final class SpinExecutorService
    implements ExecutorService {
        private static final Runnable POISON_PILL = new Runnable(){

            @Override
            public void run() {
            }
        };
        private final Queue<Runnable> tasks;
        private final AtomicBoolean poisoned = new AtomicBoolean();
        private final Thread executorThread;

        public SpinExecutorService(int maxTasks) {
            this.tasks = PlatformDependent.newFixedMpscQueue((int)maxTasks);
            this.executorThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Runnable task;
                    Queue tasks = SpinExecutorService.this.tasks;
                    while ((task = (Runnable)tasks.poll()) != POISON_PILL) {
                        if (task == null) continue;
                        task.run();
                    }
                }
            });
            this.executorThread.start();
        }

        @Override
        public void shutdown() {
            if (this.poisoned.compareAndSet(false, true)) {
                while (!this.tasks.offer(POISON_PILL)) {
                }
                try {
                    this.executorThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        @Override
        public List<Runnable> shutdownNow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isShutdown() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isTerminated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Future<?> submit(Runnable task) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void execute(Runnable command) {
            if (!this.tasks.offer(command)) {
                throw new RejectedExecutionException("If that happens, there is something wrong with the available capacity/burst size");
            }
        }
    }
}

