/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.http2.internal.hpack;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.internal.hpack.Decoder;
import io.netty.handler.codec.http2.internal.hpack.Encoder;
import io.netty.microbench.http2.internal.hpack.Header;
import io.netty.microbench.http2.internal.hpack.HeadersSize;
import io.netty.microbench.http2.internal.hpack.Util;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.io.IOException;
import java.util.List;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.infra.Blackhole;

public class DecoderBenchmark
extends AbstractMicrobenchmark {
    @Param
    public HeadersSize size;
    @Param(value={"4096"})
    public int maxTableSize;
    @Param(value={"8192"})
    public int maxHeaderSize;
    @Param(value={"true", "false"})
    public boolean sensitive;
    @Param(value={"true", "false"})
    public boolean limitToAscii;
    private ByteBuf input;

    @Setup(value=Level.Trial)
    public void setup() throws IOException {
        this.input = Unpooled.wrappedBuffer((byte[])this.getSerializedHeaders(Util.headers(this.size, this.limitToAscii), this.sensitive));
    }

    @TearDown(value=Level.Trial)
    public void teardown() throws IOException {
        this.input.release();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    public void decode(final Blackhole bh) throws IOException {
        Decoder decoder = new Decoder(this.maxHeaderSize, this.maxTableSize, 32);
        DefaultHttp2Headers headers = new DefaultHttp2Headers(){

            public Http2Headers add(CharSequence name, CharSequence value) {
                bh.consume(DecoderBenchmark.this.sensitive);
                return this;
            }
        };
        decoder.decode(this.input.duplicate(), (Http2Headers)headers);
        decoder.endHeaderBlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getSerializedHeaders(List<Header> headers, boolean sensitive) {
        Encoder encoder = new Encoder(4096);
        ByteBuf out = this.size.newOutBuffer();
        try {
            for (int i = 0; i < headers.size(); ++i) {
                Header header = headers.get(i);
                encoder.encodeHeader(out, header.name, header.value, sensitive);
            }
            byte[] bytes = new byte[out.readableBytes()];
            out.readBytes(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            out.release();
        }
    }
}

