/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.CodecOutputList;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.internal.RecyclableArrayList;
import java.util.ArrayList;
import java.util.List;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@State(value=Scope.Benchmark)
public class CodecOutputListBenchmark
extends AbstractMicrobenchmark {
    private static final Object ELEMENT = new Object();
    private CodecOutputList codecOutputList;
    private RecyclableArrayList recycleableArrayList;
    private List<Object> arrayList;
    @Param(value={"1", "4"})
    public int elements;

    @Setup(value=Level.Invocation)
    public void setup() {
        this.codecOutputList = CodecOutputList.newInstance();
        this.recycleableArrayList = RecyclableArrayList.newInstance((int)16);
        this.arrayList = new ArrayList<Object>(16);
    }

    @TearDown
    public void destroy() {
        this.codecOutputList.recycle();
        this.recycleableArrayList.recycle();
    }

    @Benchmark
    public void codecOutList() {
        CodecOutputListBenchmark.benchmarkAddAndClear((List<Object>)this.codecOutputList, this.elements);
    }

    @Benchmark
    public void recyclableArrayList() {
        CodecOutputListBenchmark.benchmarkAddAndClear((List<Object>)this.recycleableArrayList, this.elements);
    }

    @Benchmark
    public void arrayList() {
        CodecOutputListBenchmark.benchmarkAddAndClear(this.arrayList, this.elements);
    }

    private static void benchmarkAddAndClear(List<Object> list, int elements) {
        for (int i = 0; i < elements; ++i) {
            list.add(ELEMENT);
        }
        list.clear();
    }
}

