/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.http2;

import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.microbench.util.AbstractMicrobenchmark;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;

@Threads(value=1)
@State(value=Scope.Benchmark)
public class Http2PriorityTreeBenchmark
extends AbstractMicrobenchmark {
    private static final short WEIGHT = 1;
    public Http2Connection connection;
    @Param(value={"1000", "10000"})
    public int numStreams;
    @Param(value={"10", "100", "1000"})
    public int d_ary;
    @Param(value={"10", "100", "1000"})
    public int exclusiveOnCount;

    @Setup(value=Level.Trial)
    public void setup() throws Http2Exception {
        this.connection = new DefaultHttp2Connection(false);
        for (int i = 0; i < this.numStreams; ++i) {
            this.connection.local().createStream(Http2PriorityTreeBenchmark.toStreamId(i), false);
        }
    }

    @TearDown(value=Level.Iteration)
    public void teardown() throws Http2Exception {
        int connectionId = this.connection.connectionStream().id();
        for (int i = 0; i < this.numStreams; ++i) {
            this.connection.stream(Http2PriorityTreeBenchmark.toStreamId(i)).setPriority(connectionId, (short)1, false);
        }
    }

    @Benchmark
    public void prioritizeStreams() throws Http2Exception {
        Http2Stream stream;
        int i;
        int streamId = 0;
        int parentId = 0;
        boolean exclusive = false;
        for (i = 0; i < this.numStreams; ++i) {
            parentId = Http2PriorityTreeBenchmark.toStreamId(i / this.d_ary);
            if (parentId == (streamId = Http2PriorityTreeBenchmark.toStreamId(i))) {
                exclusive = i % this.exclusiveOnCount == 0;
                continue;
            }
            stream = this.connection.stream(streamId);
            stream.setPriority(parentId, (short)1, exclusive);
            exclusive = i % this.exclusiveOnCount == 0;
        }
        for (i = 0; i < this.numStreams; ++i) {
            parentId = Http2PriorityTreeBenchmark.toStreamId((this.numStreams - i) / this.d_ary);
            if (parentId == (streamId = Http2PriorityTreeBenchmark.toStreamId(i))) {
                exclusive = i % this.exclusiveOnCount == 0;
                continue;
            }
            stream = this.connection.stream(streamId);
            stream.setPriority(parentId, (short)1, exclusive);
            exclusive = i % this.exclusiveOnCount == 0;
        }
    }

    private static int toStreamId(int i) {
        return 2 * i + 1;
    }
}

