/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.util;

import io.netty.microbench.util.AbstractMicrobenchmarkBase;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;

@Fork(value=2)
public class AbstractMicrobenchmark
extends AbstractMicrobenchmarkBase {
    protected static final int DEFAULT_FORKS = 2;
    private final String[] jvmArgs;

    public AbstractMicrobenchmark() {
        this(false, false);
    }

    public AbstractMicrobenchmark(boolean disableAssertions) {
        this(disableAssertions, false);
    }

    public AbstractMicrobenchmark(boolean disableAssertions, boolean disableHarnessExecutor) {
        String[] customArgs = disableHarnessExecutor ? new String[]{"-Xms768m", "-Xmx768m", "-XX:MaxDirectMemorySize=768m"} : new String[]{"-Xms768m", "-Xmx768m", "-XX:MaxDirectMemorySize=768m", "-Djmh.executor=CUSTOM", "-Djmh.executor.class=io.netty.microbench.util.AbstractMicrobenchmark$HarnessExecutor"};
        String[] jvmArgs = new String[BASE_JVM_ARGS.length + customArgs.length];
        System.arraycopy(BASE_JVM_ARGS, 0, jvmArgs, 0, BASE_JVM_ARGS.length);
        System.arraycopy(customArgs, 0, jvmArgs, BASE_JVM_ARGS.length, customArgs.length);
        if (disableAssertions) {
            jvmArgs = AbstractMicrobenchmark.removeAssertions(jvmArgs);
        }
        this.jvmArgs = jvmArgs;
    }

    @Override
    protected String[] jvmArgs() {
        return this.jvmArgs;
    }

    @Override
    protected ChainedOptionsBuilder newOptionsBuilder() throws Exception {
        ChainedOptionsBuilder runnerOptions = super.newOptionsBuilder();
        if (this.getForks() > 0) {
            runnerOptions.forks(this.getForks());
        }
        return runnerOptions;
    }

    protected int getForks() {
        return SystemPropertyUtil.getInt((String)"forks", (int)-1);
    }

    public static final class HarnessExecutor
    extends ThreadPoolExecutor {
        private final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractMicrobenchmark.class);

        public HarnessExecutor(int maxThreads, String prefix) {
            super(maxThreads, maxThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new DefaultThreadFactory(prefix));
            this.logger.debug("Using harness executor");
        }
    }
}

