/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.HpackHeader;
import io.netty.handler.codec.http2.HpackHeadersSize;
import io.netty.handler.codec.http2.Http2Headers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class HpackUtil {
    private static final Map<HeadersKey, List<HpackHeader>> headersMap;

    private HpackUtil() {
    }

    static List<HpackHeader> headers(HpackHeadersSize size, boolean limitToAscii) {
        return headersMap.get(new HeadersKey(size, limitToAscii));
    }

    static Http2Headers http2Headers(HpackHeadersSize size, boolean limitToAscii) {
        List<HpackHeader> hpackHeaders = headersMap.get(new HeadersKey(size, limitToAscii));
        DefaultHttp2Headers http2Headers = new DefaultHttp2Headers(false);
        for (int i = 0; i < hpackHeaders.size(); ++i) {
            HpackHeader hpackHeader = hpackHeaders.get(i);
            http2Headers.add((Object)hpackHeader.name, (Object)hpackHeader.value);
        }
        return http2Headers;
    }

    static {
        HpackHeadersSize[] sizes = HpackHeadersSize.values();
        headersMap = new HashMap<HeadersKey, List<HpackHeader>>(sizes.length * 2);
        for (HpackHeadersSize size : sizes) {
            HeadersKey key = new HeadersKey(size, true);
            headersMap.put(key, key.newHeaders());
            key = new HeadersKey(size, false);
            headersMap.put(key, key.newHeaders());
        }
    }

    private static class HeadersKey {
        final HpackHeadersSize size;
        final boolean limitToAscii;

        public HeadersKey(HpackHeadersSize size, boolean limitToAscii) {
            this.size = size;
            this.limitToAscii = limitToAscii;
        }

        List<HpackHeader> newHeaders() {
            return this.size.newHeaders(this.limitToAscii);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HeadersKey that = (HeadersKey)o;
            if (this.limitToAscii != that.limitToAscii) {
                return false;
            }
            return this.size == that.size;
        }

        public int hashCode() {
            int result = this.size.hashCode();
            result = 31 * result + (this.limitToAscii ? 1 : 0);
            return result;
        }
    }
}

