/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.http2;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FlowController;
import io.netty.handler.codec.http2.Http2FrameAdapter;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import io.netty.handler.codec.http2.StreamByteDistributor;
import io.netty.handler.codec.http2.UniformStreamByteDistributor;
import io.netty.handler.codec.http2.WeightedFairQueueByteDistributor;
import io.netty.microbench.channel.EmbeddedChannelWriteReleaseHandlerContext;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.microbench.util.AbstractMicrobenchmarkBase;
import org.openjdk.jmh.annotations.AuxCounters;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;

@Threads(value=1)
@State(value=Scope.Benchmark)
public class NoPriorityByteDistributionBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"100", "10000"})
    private int numStreams;
    @Param(value={"1024", "65536", "1048576"})
    private int windowSize;
    @Param
    private Algorithm algorithm;
    private Http2Connection connection;
    private Http2Connection.PropertyKey dataRefresherKey;
    private Http2RemoteFlowController controller;
    private StreamByteDistributor distributor;
    private AdditionalCounters counters;
    private ChannelHandlerContext ctx;
    private Http2StreamVisitor invocationVisitor = new Http2StreamVisitor(){

        public boolean visit(Http2Stream stream) throws Http2Exception {
            NoPriorityByteDistributionBenchmark.this.resetWindow(stream);
            NoPriorityByteDistributionBenchmark.this.dataRefresher(stream).refreshData();
            return true;
        }
    };

    public NoPriorityByteDistributionBenchmark() {
        super(true);
    }

    @TearDown(value=Level.Trial)
    public void tearDownTrial() throws Exception {
        this.ctx.close();
    }

    @Setup(value=Level.Trial)
    public void setupTrial() throws Exception {
        this.connection = new DefaultHttp2Connection(false);
        this.dataRefresherKey = this.connection.newKey();
        switch (this.algorithm) {
            case WFQ: {
                this.distributor = new WeightedFairQueueByteDistributor(this.connection);
                break;
            }
            case UNIFORM: {
                this.distributor = new UniformStreamByteDistributor(this.connection);
            }
        }
        this.controller = new DefaultHttp2RemoteFlowController(this.connection, (StreamByteDistributor)new ByteCounter(this.distributor));
        this.connection.remote().flowController((Http2FlowController)this.controller);
        Http2ConnectionHandler handler = new Http2ConnectionHandlerBuilder().encoderEnforceMaxConcurrentStreams(false).validateHeaders(false).frameListener((Http2FrameListener)new Http2FrameAdapter()).connection(this.connection).build();
        this.ctx = new EmbeddedChannelWriteReleaseHandlerContext((ByteBufAllocator)PooledByteBufAllocator.DEFAULT, (ChannelHandler)handler){

            @Override
            protected void handleException(Throwable t) {
                AbstractMicrobenchmarkBase.handleUnexpectedException(t);
            }
        };
        handler.handlerAdded(this.ctx);
        handler.channelActive(this.ctx);
        for (int i = 0; i < this.numStreams; ++i) {
            Http2Stream stream = this.connection.local().createStream(NoPriorityByteDistributionBenchmark.toStreamId(i), false);
            this.addData(stream, Integer.MAX_VALUE);
            stream.setProperty(this.dataRefresherKey, (Object)new DataRefresher(stream));
        }
    }

    @Setup(value=Level.Invocation)
    public void setupInvocation() throws Http2Exception {
        this.resetWindow(this.connection.connectionStream());
        this.connection.forEachActiveStream(this.invocationVisitor);
    }

    @Benchmark
    public void write(AdditionalCounters counters) throws Http2Exception {
        this.counters = counters;
        ++counters.invocations;
        this.controller.writePendingBytes();
    }

    private void resetWindow(Http2Stream stream) throws Http2Exception {
        this.controller.incrementWindowSize(stream, this.windowSize - this.controller.windowSize(stream));
    }

    private DataRefresher dataRefresher(Http2Stream stream) {
        return (DataRefresher)stream.getProperty(this.dataRefresherKey);
    }

    private void addData(Http2Stream stream, final int dataSize) {
        this.controller.addFlowControlled(stream, new Http2RemoteFlowController.FlowControlled(){
            int size;
            {
                this.size = dataSize;
            }

            public int size() {
                return this.size;
            }

            public void error(ChannelHandlerContext ctx, Throwable cause) {
                cause.printStackTrace();
            }

            public void writeComplete() {
            }

            public void write(ChannelHandlerContext ctx, int allowedBytes) {
                this.size -= allowedBytes;
            }

            public boolean merge(ChannelHandlerContext ctx, Http2RemoteFlowController.FlowControlled next) {
                int nextSize = next.size();
                if (Integer.MAX_VALUE - nextSize < this.size) {
                    return false;
                }
                this.size += nextSize;
                return true;
            }
        });
    }

    private static int toStreamId(int i) {
        return 2 * i + 1;
    }

    private final class ByteCounter
    implements StreamByteDistributor {
        private final StreamByteDistributor delegate;

        private ByteCounter(StreamByteDistributor delegate) {
            this.delegate = delegate;
        }

        public void updateStreamableBytes(StreamByteDistributor.StreamState state) {
            this.delegate.updateStreamableBytes(state);
        }

        public boolean distribute(int maxBytes, StreamByteDistributor.Writer writer) throws Http2Exception {
            return this.delegate.distribute(maxBytes, (StreamByteDistributor.Writer)new CountingWriter(writer));
        }

        private final class CountingWriter
        implements StreamByteDistributor.Writer {
            private final StreamByteDistributor.Writer delegate;

            private CountingWriter(StreamByteDistributor.Writer delegate) {
                this.delegate = delegate;
            }

            public void write(Http2Stream stream, int numBytes) {
                if (numBytes > 0) {
                    DataRefresher refresher = NoPriorityByteDistributionBenchmark.this.dataRefresher(stream);
                    refresher.add(numBytes);
                    ++((NoPriorityByteDistributionBenchmark)NoPriorityByteDistributionBenchmark.this).counters.numWrites;
                    ((NoPriorityByteDistributionBenchmark)NoPriorityByteDistributionBenchmark.this).counters.totalBytes += (long)numBytes;
                    if (((NoPriorityByteDistributionBenchmark)NoPriorityByteDistributionBenchmark.this).counters.minWriteSize == 0 || numBytes < ((NoPriorityByteDistributionBenchmark)NoPriorityByteDistributionBenchmark.this).counters.minWriteSize) {
                        ((NoPriorityByteDistributionBenchmark)NoPriorityByteDistributionBenchmark.this).counters.minWriteSize = numBytes;
                    }
                    if (numBytes > ((NoPriorityByteDistributionBenchmark)NoPriorityByteDistributionBenchmark.this).counters.maxWriteSize) {
                        ((NoPriorityByteDistributionBenchmark)NoPriorityByteDistributionBenchmark.this).counters.maxWriteSize = numBytes;
                    }
                }
                this.delegate.write(stream, numBytes);
            }
        }
    }

    private final class DataRefresher {
        private final Http2Stream stream;
        private int data;

        private DataRefresher(Http2Stream stream) {
            this.stream = stream;
        }

        void add(int data) {
            this.data += data;
        }

        void refreshData() {
            if (this.data > 0) {
                NoPriorityByteDistributionBenchmark.this.addData(this.stream, this.data);
                this.data = 0;
            }
        }
    }

    @AuxCounters
    @State(value=Scope.Thread)
    public static class AdditionalCounters {
        int minWriteSize;
        int maxWriteSize;
        long totalBytes;
        long numWrites;
        int invocations;

        public int minWriteSize() {
            return this.minWriteSize;
        }

        public int avgWriteSize() {
            return (int)(this.totalBytes / this.numWrites);
        }

        public int maxWriteSize() {
            return this.maxWriteSize;
        }
    }

    public static enum Algorithm {
        WFQ,
        UNIFORM;

    }
}

