/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.headers;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.microbench.headers.ExampleHeaders;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.AsciiString;
import io.netty.util.ByteString;
import io.netty.util.CharsetUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@Threads(value=1)
@State(value=Scope.Benchmark)
@Warmup(iterations=5)
@Measurement(iterations=10)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class HeadersBenchmark
extends AbstractMicrobenchmark {
    @Param
    ExampleHeaders.HeaderExample exampleHeader;
    AsciiString[] httpNames;
    AsciiString[] httpValues;
    ByteString[] http2Names;
    ByteString[] http2Values;
    DefaultHttpHeaders httpHeaders;
    DefaultHttp2Headers http2Headers;

    @Setup(value=Level.Trial)
    public void setup() {
        Map<String, String> headers = ExampleHeaders.EXAMPLES.get((Object)this.exampleHeader);
        this.httpNames = new AsciiString[headers.size()];
        this.httpValues = new AsciiString[headers.size()];
        this.http2Names = new ByteString[headers.size()];
        this.http2Values = new ByteString[headers.size()];
        this.httpHeaders = new DefaultHttpHeaders(false);
        this.http2Headers = new DefaultHttp2Headers();
        int idx = 0;
        for (Map.Entry<String, String> header : headers.entrySet()) {
            String name = header.getKey();
            String value = header.getValue();
            this.httpNames[idx] = new AsciiString((CharSequence)name);
            this.httpValues[idx] = new AsciiString((CharSequence)value);
            this.http2Names[idx] = new ByteString((CharSequence)name, CharsetUtil.US_ASCII);
            this.http2Values[idx] = new ByteString((CharSequence)value, CharsetUtil.US_ASCII);
            ++idx;
            this.httpHeaders.add((CharSequence)new AsciiString((CharSequence)name), (Object)new AsciiString((CharSequence)value));
            this.http2Headers.add(new ByteString((CharSequence)name, CharsetUtil.US_ASCII), new ByteString((CharSequence)value, CharsetUtil.US_ASCII));
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void httpRemove(Blackhole bh) {
        for (AsciiString name : this.httpNames) {
            bh.consume((Object)this.httpHeaders.remove((CharSequence)name));
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void httpGet(Blackhole bh) {
        for (AsciiString name : this.httpNames) {
            bh.consume((Object)this.httpHeaders.get((CharSequence)name));
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public DefaultHttpHeaders httpPut() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders(false);
        for (int i = 0; i < this.httpNames.length; ++i) {
            headers.add((CharSequence)this.httpNames[i], (Object)this.httpValues[i]);
        }
        return headers;
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void httpIterate(Blackhole bh) {
        Iterator itr = this.httpHeaders.iteratorCharSequence();
        while (itr.hasNext()) {
            bh.consume(itr.next());
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void http2Remove(Blackhole bh) {
        for (ByteString name : this.http2Names) {
            bh.consume(this.http2Headers.remove((Object)name));
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void http2Get(Blackhole bh) {
        for (ByteString name : this.http2Names) {
            bh.consume(this.http2Headers.get((Object)name));
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public DefaultHttp2Headers http2Put() {
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        for (int i = 0; i < this.httpNames.length; ++i) {
            headers.add((ByteString)this.httpNames[i], (ByteString)this.httpValues[i]);
        }
        return headers;
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void http2IterateNew(Blackhole bh) {
        for (Map.Entry entry : this.http2Headers) {
            bh.consume((Object)entry);
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void http2IterateOld(Blackhole bh) {
        for (Http2Headers.PseudoHeaderName pseudoHeader : Http2Headers.PseudoHeaderName.values()) {
            ByteString name = pseudoHeader.value();
            ByteString value = (ByteString)this.http2Headers.get((Object)name);
            if (value == null) continue;
            bh.consume((Object)value);
        }
        for (Map.Entry entry : this.http2Headers) {
            ByteString name = (ByteString)entry.getKey();
            ByteString value = (ByteString)entry.getValue();
            if (Http2Headers.PseudoHeaderName.isPseudoHeader((ByteString)name)) continue;
            bh.consume((Object)value);
        }
    }
}

