/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.util;

import io.netty.util.ResourceLeakDetector;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@Warmup(iterations=10)
@Measurement(iterations=10)
@State(value=Scope.Thread)
public abstract class AbstractMicrobenchmarkBase {
    protected static final int DEFAULT_WARMUP_ITERATIONS = 10;
    protected static final int DEFAULT_MEASURE_ITERATIONS = 10;
    protected static final String[] BASE_JVM_ARGS = new String[]{"-server", "-dsa", "-da", "-ea:io.netty...", "-XX:+AggressiveOpts", "-XX:+UseBiasedLocking", "-XX:+UseFastAccessorMethods", "-XX:+OptimizeStringConcat", "-XX:+HeapDumpOnOutOfMemoryError", "-Dio.netty.noResourceLeakDetection"};

    protected ChainedOptionsBuilder newOptionsBuilder() throws Exception {
        String className = this.getClass().getSimpleName();
        ChainedOptionsBuilder runnerOptions = new OptionsBuilder().include(".*" + className + ".*").jvmArgs(this.jvmArgs());
        if (this.getWarmupIterations() > 0) {
            runnerOptions.warmupIterations(this.getWarmupIterations());
        }
        if (this.getMeasureIterations() > 0) {
            runnerOptions.measurementIterations(this.getMeasureIterations());
        }
        if (this.getReportDir() != null) {
            String filePath = this.getReportDir() + className + ".json";
            File file = new File(filePath);
            if (file.exists()) {
                file.delete();
            } else {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            runnerOptions.resultFormat(ResultFormatType.JSON);
            runnerOptions.result(filePath);
        }
        return runnerOptions;
    }

    protected abstract String[] jvmArgs();

    @Test
    public void run() throws Exception {
        new Runner(this.newOptionsBuilder().build()).run();
    }

    protected int getWarmupIterations() {
        return SystemPropertyUtil.getInt((String)"warmupIterations", (int)-1);
    }

    protected int getMeasureIterations() {
        return SystemPropertyUtil.getInt((String)"measureIterations", (int)-1);
    }

    protected String getReportDir() {
        return SystemPropertyUtil.get((String)"perfReportDir");
    }

    public static void handleUnexpectedException(Throwable t) {
        Assert.assertNull((Object)t);
    }

    static {
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
    }
}

