/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.concurrent;

import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.concurrent.FastThreadLocal;
import java.util.Random;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Threads;

@Threads(value=4)
@Measurement(iterations=10, batchSize=100)
public class FastThreadLocalBenchmark
extends AbstractMicrobenchmark {
    private static final Random rand;
    private static final ThreadLocal<Integer>[] jdkThreadLocals;
    private static final FastThreadLocal<Integer>[] fastThreadLocals;

    @Benchmark
    public int jdkThreadLocalGet() {
        int result = 0;
        for (ThreadLocal<Integer> i : jdkThreadLocals) {
            result += i.get().intValue();
        }
        return result;
    }

    @Benchmark
    public int fastThreadLocal() {
        int result = 0;
        for (FastThreadLocal<Integer> i : fastThreadLocals) {
            result += ((Integer)i.get()).intValue();
        }
        return result;
    }

    static {
        int i;
        rand = new Random();
        jdkThreadLocals = new ThreadLocal[128];
        fastThreadLocals = new FastThreadLocal[jdkThreadLocals.length];
        for (i = 0; i < jdkThreadLocals.length; ++i) {
            FastThreadLocalBenchmark.jdkThreadLocals[i] = new ThreadLocal<Integer>(){

                @Override
                protected Integer initialValue() {
                    return rand.nextInt();
                }
            };
        }
        for (i = 0; i < fastThreadLocals.length; ++i) {
            FastThreadLocalBenchmark.fastThreadLocals[i] = new FastThreadLocal<Integer>(){

                protected Integer initialValue() {
                    return rand.nextInt();
                }
            };
        }
    }
}

