/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.concurrent;

import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.concurrent.FastThreadLocal;
import java.util.Random;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Threads;

@Threads(value=4)
@Measurement(iterations=10, batchSize=100)
public class FastThreadLocalSlowPathBenchmark
extends AbstractMicrobenchmark {
    private static final Random rand = new Random();
    private static final ThreadLocal<Integer>[] jdkThreadLocals = new ThreadLocal[128];
    private static final FastThreadLocal<Integer>[] fastThreadLocals = new FastThreadLocal[jdkThreadLocals.length];

    public FastThreadLocalSlowPathBenchmark() {
        super(false, true);
    }

    @Benchmark
    public int jdkThreadLocalGet() {
        int result = 0;
        for (ThreadLocal<Integer> i : jdkThreadLocals) {
            result += i.get().intValue();
        }
        return result;
    }

    @Benchmark
    public int fastThreadLocal() {
        int result = 0;
        for (FastThreadLocal<Integer> i : fastThreadLocals) {
            result += ((Integer)i.get()).intValue();
        }
        return result;
    }

    static {
        for (int i = 0; i < jdkThreadLocals.length; ++i) {
            final int num = rand.nextInt();
            FastThreadLocalSlowPathBenchmark.jdkThreadLocals[i] = new ThreadLocal<Integer>(){

                @Override
                protected Integer initialValue() {
                    return num;
                }
            };
            FastThreadLocalSlowPathBenchmark.fastThreadLocals[i] = new FastThreadLocal<Integer>(){

                protected Integer initialValue() {
                    return num;
                }
            };
        }
    }
}

