/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.flush;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class FlushConsolidationHandlerTest {
    private static final int EXPLICIT_FLUSH_AFTER_FLUSHES = 3;

    @Test
    public void testFlushViaScheduledTask() {
        AtomicInteger flushCount = new AtomicInteger();
        EmbeddedChannel channel = FlushConsolidationHandlerTest.newChannel(flushCount, true);
        channel.flush();
        Assert.assertEquals((long)0L, (long)flushCount.get());
        channel.flush();
        Assert.assertEquals((long)0L, (long)flushCount.get());
        channel.runPendingTasks();
        Assert.assertEquals((long)1L, (long)flushCount.get());
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testFlushViaThresholdOutsideOfReadLoop() {
        AtomicInteger flushCount = new AtomicInteger();
        EmbeddedChannel channel = FlushConsolidationHandlerTest.newChannel(flushCount, true);
        for (int i = 0; i < 3; ++i) {
            channel.flush();
        }
        Assert.assertEquals((long)1L, (long)flushCount.get());
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testImmediateFlushOutsideOfReadLoop() {
        AtomicInteger flushCount = new AtomicInteger();
        EmbeddedChannel channel = FlushConsolidationHandlerTest.newChannel(flushCount, false);
        channel.flush();
        Assert.assertEquals((long)1L, (long)flushCount.get());
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testFlushViaReadComplete() {
        AtomicInteger flushCount = new AtomicInteger();
        EmbeddedChannel channel = FlushConsolidationHandlerTest.newChannel(flushCount, false);
        channel.flush();
        channel.runPendingTasks();
        Assert.assertEquals((long)1L, (long)flushCount.get());
        channel.pipeline().fireChannelRead((Object)1L);
        Assert.assertEquals((long)1L, (long)flushCount.get());
        channel.pipeline().fireChannelRead((Object)2L);
        Assert.assertEquals((long)1L, (long)flushCount.get());
        Assert.assertNull((Object)channel.readOutbound());
        channel.pipeline().fireChannelReadComplete();
        Assert.assertEquals((long)2L, (long)flushCount.get());
        channel.flush();
        channel.runPendingTasks();
        Assert.assertEquals((long)3L, (long)flushCount.get());
        Assert.assertEquals((Object)1L, (Object)channel.readOutbound());
        Assert.assertEquals((Object)2L, (Object)channel.readOutbound());
        Assert.assertNull((Object)channel.readOutbound());
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testFlushViaClose() {
        AtomicInteger flushCount = new AtomicInteger();
        EmbeddedChannel channel = FlushConsolidationHandlerTest.newChannel(flushCount, false);
        channel.pipeline().fireChannelRead((Object)1L);
        Assert.assertEquals((long)0L, (long)flushCount.get());
        Assert.assertNull((Object)channel.readOutbound());
        channel.close();
        Assert.assertEquals((long)1L, (long)flushCount.get());
        Assert.assertEquals((Object)1L, (Object)channel.readOutbound());
        Assert.assertNull((Object)channel.readOutbound());
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testFlushViaDisconnect() {
        AtomicInteger flushCount = new AtomicInteger();
        EmbeddedChannel channel = FlushConsolidationHandlerTest.newChannel(flushCount, false);
        channel.pipeline().fireChannelRead((Object)1L);
        Assert.assertEquals((long)0L, (long)flushCount.get());
        Assert.assertNull((Object)channel.readOutbound());
        channel.disconnect();
        Assert.assertEquals((long)1L, (long)flushCount.get());
        Assert.assertEquals((Object)1L, (Object)channel.readOutbound());
        Assert.assertNull((Object)channel.readOutbound());
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test(expected=IllegalStateException.class)
    public void testFlushViaException() {
        AtomicInteger flushCount = new AtomicInteger();
        EmbeddedChannel channel = FlushConsolidationHandlerTest.newChannel(flushCount, false);
        channel.pipeline().fireChannelRead((Object)1L);
        Assert.assertEquals((long)0L, (long)flushCount.get());
        Assert.assertNull((Object)channel.readOutbound());
        channel.pipeline().fireExceptionCaught((Throwable)new IllegalStateException());
        Assert.assertEquals((long)1L, (long)flushCount.get());
        Assert.assertEquals((Object)1L, (Object)channel.readOutbound());
        Assert.assertNull((Object)channel.readOutbound());
        channel.finish();
    }

    @Test
    public void testFlushViaRemoval() {
        AtomicInteger flushCount = new AtomicInteger();
        EmbeddedChannel channel = FlushConsolidationHandlerTest.newChannel(flushCount, false);
        channel.pipeline().fireChannelRead((Object)1L);
        Assert.assertEquals((long)0L, (long)flushCount.get());
        Assert.assertNull((Object)channel.readOutbound());
        channel.pipeline().remove(FlushConsolidationHandler.class);
        Assert.assertEquals((long)1L, (long)flushCount.get());
        Assert.assertEquals((Object)1L, (Object)channel.readOutbound());
        Assert.assertNull((Object)channel.readOutbound());
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testResend() throws Exception {
        AtomicInteger flushCount = new AtomicInteger();
        final EmbeddedChannel channel = FlushConsolidationHandlerTest.newChannel(flushCount, true);
        channel.writeAndFlush((Object)1L).addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> future) throws Exception {
                channel.writeAndFlush((Object)1L);
            }
        });
        channel.flushOutbound();
        Assert.assertEquals((Object)1L, (Object)channel.readOutbound());
        Assert.assertEquals((Object)1L, (Object)channel.readOutbound());
        Assert.assertNull((Object)channel.readOutbound());
        Assert.assertFalse((boolean)channel.finish());
    }

    private static EmbeddedChannel newChannel(final AtomicInteger flushCount, boolean consolidateWhenNoReadInProgress) {
        return new EmbeddedChannel(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void flush(ChannelHandlerContext ctx) throws Exception {
                flushCount.incrementAndGet();
                ctx.flush();
            }
        }, new FlushConsolidationHandler(3, consolidateWhenNoReadInProgress), new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                ctx.writeAndFlush(msg);
            }
        }});
    }
}

