/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.handler.ssl.util.SimpleTrustManagerFactory;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.EmptyArrays;
import java.io.File;
import java.security.KeyStore;
import java.security.cert.CRLReason;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateRevokedException;
import java.security.cert.Extension;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SslErrorTest {
    private final SslProvider serverProvider;
    private final SslProvider clientProvider;
    private final CertificateException exception;
    private final boolean serverProduceError;

    @Parameterized.Parameters(name="{index}: serverProvider = {0}, clientProvider = {1}, exception = {2}, serverProduceError = {3}")
    public static Collection<Object[]> data() {
        ArrayList<SslProvider> serverProviders = new ArrayList<SslProvider>(2);
        ArrayList<SslProvider> clientProviders = new ArrayList<SslProvider>(3);
        if (OpenSsl.isAvailable()) {
            serverProviders.add(SslProvider.OPENSSL);
            serverProviders.add(SslProvider.OPENSSL_REFCNT);
            clientProviders.add(SslProvider.OPENSSL);
            clientProviders.add(SslProvider.OPENSSL_REFCNT);
        }
        clientProviders.add(SslProvider.JDK);
        ArrayList<CertificateException> exceptions = new ArrayList<CertificateException>(6);
        exceptions.add(new CertificateExpiredException());
        exceptions.add(new CertificateNotYetValidException());
        exceptions.add(new CertificateRevokedException(new Date(), CRLReason.AA_COMPROMISE, new X500Principal(""), Collections.<String, Extension>emptyMap()));
        exceptions.add(SslErrorTest.newCertificateException(CertPathValidatorException.BasicReason.EXPIRED));
        exceptions.add(SslErrorTest.newCertificateException(CertPathValidatorException.BasicReason.NOT_YET_VALID));
        exceptions.add(SslErrorTest.newCertificateException(CertPathValidatorException.BasicReason.REVOKED));
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (SslProvider serverProvider : serverProviders) {
            for (SslProvider clientProvider : clientProviders) {
                for (CertificateException exception : exceptions) {
                    params.add(new Object[]{serverProvider, clientProvider, exception, true});
                    params.add(new Object[]{serverProvider, clientProvider, exception, false});
                }
            }
        }
        return params;
    }

    private static CertificateException newCertificateException(CertPathValidatorException.Reason reason) {
        return new TestCertificateException(new CertPathValidatorException("x", null, null, -1, reason));
    }

    public SslErrorTest(SslProvider serverProvider, SslProvider clientProvider, CertificateException exception, boolean serverProduceError) {
        this.serverProvider = serverProvider;
        this.clientProvider = clientProvider;
        this.exception = exception;
        this.serverProduceError = serverProduceError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testCorrectAlert() throws Exception {
        Assume.assumeTrue((boolean)OpenSsl.isAvailable());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        SslContextBuilder sslServerCtxBuilder = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.serverProvider).clientAuth(ClientAuth.REQUIRE);
        SslContextBuilder sslClientCtxBuilder = SslContextBuilder.forClient().keyManager(new File(this.getClass().getResource("test.crt").getFile()), new File(this.getClass().getResource("test_unencrypted.pem").getFile())).sslProvider(this.clientProvider);
        if (this.serverProduceError) {
            sslServerCtxBuilder.trustManager((TrustManagerFactory)((Object)new ExceptionTrustManagerFactory()));
            sslClientCtxBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        } else {
            sslServerCtxBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            sslClientCtxBuilder.trustManager((TrustManagerFactory)((Object)new ExceptionTrustManagerFactory()));
        }
        final SslContext sslServerCtx = sslServerCtxBuilder.build();
        final SslContext sslClientCtx = sslClientCtxBuilder.build();
        Channel serverChannel = null;
        Channel clientChannel = null;
        NioEventLoopGroup group = new NioEventLoopGroup();
        final Promise promise = group.next().newPromise();
        try {
            serverChannel = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{sslServerCtx.newHandler(ch.alloc())});
                    if (!SslErrorTest.this.serverProduceError) {
                        ch.pipeline().addLast(new ChannelHandler[]{new AlertValidationHandler((Promise<Void>)promise)});
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            ctx.close();
                        }
                    }});
                }
            }).bind(0).sync().channel();
            clientChannel = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{sslClientCtx.newHandler(ch.alloc())});
                    if (SslErrorTest.this.serverProduceError) {
                        ch.pipeline().addLast(new ChannelHandler[]{new AlertValidationHandler((Promise<Void>)promise)});
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            ctx.close();
                        }
                    }});
                }
            })).connect(serverChannel.localAddress()).syncUninterruptibly().channel();
            promise.syncUninterruptibly();
        }
        finally {
            if (clientChannel != null) {
                clientChannel.close().syncUninterruptibly();
            }
            if (serverChannel != null) {
                serverChannel.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)sslServerCtx);
            ReferenceCountUtil.release((Object)sslClientCtx);
        }
    }

    private void verifyException(Throwable cause, Promise<Void> promise, String ... messageParts) {
        String message = cause.getMessage();
        if (!this.serverProduceError && this.clientProvider == SslProvider.JDK && message.toLowerCase(Locale.UK).contains("unknown")) {
            promise.setSuccess(null);
            return;
        }
        for (String m : messageParts) {
            if (!message.toLowerCase(Locale.UK).contains(m.toLowerCase(Locale.UK))) continue;
            promise.setSuccess(null);
            return;
        }
        AssertionError error = new AssertionError((Object)("message not contains any of '" + Arrays.toString(messageParts) + "': " + message));
        ((Throwable)((Object)error)).initCause(cause);
        promise.setFailure((Throwable)((Object)error));
    }

    private static final class TestCertificateException
    extends CertificateException {
        private static final long serialVersionUID = -5816338303868751410L;

        TestCertificateException(Throwable cause) {
            super(cause);
        }
    }

    private final class AlertValidationHandler
    extends ChannelInboundHandlerAdapter {
        private final Promise<Void> promise;

        AlertValidationHandler(Promise<Void> promise) {
            this.promise = promise;
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            Throwable unwrappedCause = cause.getCause();
            if (unwrappedCause instanceof SSLException) {
                if (SslErrorTest.this.exception instanceof TestCertificateException) {
                    CertPathValidatorException.Reason reason = ((CertPathValidatorException)SslErrorTest.this.exception.getCause()).getReason();
                    if (reason == CertPathValidatorException.BasicReason.EXPIRED) {
                        SslErrorTest.this.verifyException(unwrappedCause, (Promise<Void>)this.promise, new String[]{"expired"});
                    } else if (reason == CertPathValidatorException.BasicReason.NOT_YET_VALID) {
                        SslErrorTest.this.verifyException(unwrappedCause, (Promise<Void>)this.promise, new String[]{"expired", "bad"});
                    } else if (reason == CertPathValidatorException.BasicReason.REVOKED) {
                        SslErrorTest.this.verifyException(unwrappedCause, (Promise<Void>)this.promise, new String[]{"revoked"});
                    }
                } else if (SslErrorTest.this.exception instanceof CertificateExpiredException) {
                    SslErrorTest.this.verifyException(unwrappedCause, (Promise<Void>)this.promise, new String[]{"expired"});
                } else if (SslErrorTest.this.exception instanceof CertificateNotYetValidException) {
                    SslErrorTest.this.verifyException(unwrappedCause, (Promise<Void>)this.promise, new String[]{"expired", "bad"});
                } else if (SslErrorTest.this.exception instanceof CertificateRevokedException) {
                    SslErrorTest.this.verifyException(unwrappedCause, (Promise<Void>)this.promise, new String[]{"revoked"});
                }
            }
        }
    }

    private final class ExceptionTrustManagerFactory
    extends SimpleTrustManagerFactory {
        private ExceptionTrustManagerFactory() {
        }

        protected void engineInit(KeyStore keyStore) {
        }

        protected void engineInit(ManagerFactoryParameters managerFactoryParameters) {
        }

        protected TrustManager[] engineGetTrustManagers() {
            return new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    throw SslErrorTest.this.exception;
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    throw SslErrorTest.this.exception;
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return EmptyArrays.EMPTY_X509_CERTIFICATES;
                }
            }};
        }
    }
}

