/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ipfilter;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.ipfilter.IpFilterRule;
import io.netty.handler.ipfilter.IpFilterRuleType;
import io.netty.handler.ipfilter.IpSubnetFilter;
import io.netty.handler.ipfilter.IpSubnetFilterRule;
import io.netty.handler.ipfilter.RuleBasedIpFilter;
import io.netty.handler.ipfilter.UniqueIpFilter;
import io.netty.util.internal.SocketUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class IpSubnetFilterTest {
    @Test
    public void testIpv4DefaultRoute() {
        IpSubnetFilterRule rule = new IpSubnetFilterRule("0.0.0.0", 0, IpFilterRuleType.ACCEPT);
        Assert.assertTrue((boolean)rule.matches(IpSubnetFilterTest.newSockAddress("91.114.240.43")));
        Assert.assertTrue((boolean)rule.matches(IpSubnetFilterTest.newSockAddress("10.0.0.3")));
        Assert.assertTrue((boolean)rule.matches(IpSubnetFilterTest.newSockAddress("192.168.93.2")));
    }

    @Test
    public void testIpv4SubnetMaskCorrectlyHandlesIpv6() {
        IpSubnetFilterRule rule = new IpSubnetFilterRule("0.0.0.0", 0, IpFilterRuleType.ACCEPT);
        Assert.assertFalse((boolean)rule.matches(IpSubnetFilterTest.newSockAddress("2001:db8:abcd:0000::1")));
    }

    @Test
    public void testIpv6SubnetMaskCorrectlyHandlesIpv4() {
        IpSubnetFilterRule rule = new IpSubnetFilterRule("::", 0, IpFilterRuleType.ACCEPT);
        Assert.assertFalse((boolean)rule.matches(IpSubnetFilterTest.newSockAddress("91.114.240.43")));
    }

    @Test
    public void testIp4SubnetFilterRule() throws Exception {
        IpSubnetFilterRule rule = new IpSubnetFilterRule("192.168.56.1", 24, IpFilterRuleType.ACCEPT);
        for (int i = 0; i <= 255; ++i) {
            Assert.assertTrue((boolean)rule.matches(IpSubnetFilterTest.newSockAddress(String.format("192.168.56.%d", i))));
        }
        Assert.assertFalse((boolean)rule.matches(IpSubnetFilterTest.newSockAddress("192.168.57.1")));
        rule = new IpSubnetFilterRule("91.114.240.1", 23, IpFilterRuleType.ACCEPT);
        Assert.assertTrue((boolean)rule.matches(IpSubnetFilterTest.newSockAddress("91.114.240.43")));
        Assert.assertTrue((boolean)rule.matches(IpSubnetFilterTest.newSockAddress("91.114.240.255")));
        Assert.assertTrue((boolean)rule.matches(IpSubnetFilterTest.newSockAddress("91.114.241.193")));
        Assert.assertTrue((boolean)rule.matches(IpSubnetFilterTest.newSockAddress("91.114.241.254")));
        Assert.assertFalse((boolean)rule.matches(IpSubnetFilterTest.newSockAddress("91.115.241.2")));
    }

    @Test
    public void testIp6SubnetFilterRule() {
        IpSubnetFilterRule rule = new IpSubnetFilterRule("2001:db8:abcd:0000::", 52, IpFilterRuleType.ACCEPT);
        Assert.assertTrue((boolean)rule.matches(IpSubnetFilterTest.newSockAddress("2001:db8:abcd:0000::1")));
        Assert.assertTrue((boolean)rule.matches(IpSubnetFilterTest.newSockAddress("2001:db8:abcd:0fff:ffff:ffff:ffff:ffff")));
        Assert.assertFalse((boolean)rule.matches(IpSubnetFilterTest.newSockAddress("2001:db8:abcd:1000::")));
    }

    @Test
    public void testIpFilterRuleHandler() throws Exception {
        IpFilterRule filter0 = new IpFilterRule(){

            public boolean matches(InetSocketAddress remoteAddress) {
                return "192.168.57.1".equals(remoteAddress.getHostName());
            }

            public IpFilterRuleType ruleType() {
                return IpFilterRuleType.REJECT;
            }
        };
        RuleBasedIpFilter denyHandler = new RuleBasedIpFilter(new IpFilterRule[]{filter0}){
            private final byte[] message;
            {
                this.message = new byte[]{1, 2, 3, 4, 5, 6, 7};
            }

            protected ChannelFuture channelRejected(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) {
                Assert.assertTrue((boolean)ctx.channel().isActive());
                Assert.assertTrue((boolean)ctx.channel().isWritable());
                Assert.assertEquals((Object)"192.168.57.1", (Object)remoteAddress.getHostName());
                return ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])this.message));
            }
        };
        EmbeddedChannel chDeny = IpSubnetFilterTest.newEmbeddedInetChannel("192.168.57.1", new ChannelHandler[]{denyHandler});
        ByteBuf out = (ByteBuf)chDeny.readOutbound();
        Assert.assertEquals((long)7L, (long)out.readableBytes());
        for (int i = 1; i <= 7; i = (int)((byte)(i + 1))) {
            Assert.assertEquals((long)i, (long)out.readByte());
        }
        Assert.assertFalse((boolean)chDeny.isActive());
        Assert.assertFalse((boolean)chDeny.isOpen());
        RuleBasedIpFilter allowHandler = new RuleBasedIpFilter(new IpFilterRule[]{filter0}){

            protected ChannelFuture channelRejected(ChannelHandlerContext ctx, InetSocketAddress remoteAddress) {
                Assert.fail();
                return null;
            }
        };
        EmbeddedChannel chAllow = IpSubnetFilterTest.newEmbeddedInetChannel("192.168.57.2", new ChannelHandler[]{allowHandler});
        Assert.assertTrue((boolean)chAllow.isActive());
        Assert.assertTrue((boolean)chAllow.isOpen());
    }

    @Test
    public void testUniqueIpFilterHandler() {
        UniqueIpFilter handler = new UniqueIpFilter();
        EmbeddedChannel ch1 = IpSubnetFilterTest.newEmbeddedInetChannel("91.92.93.1", new ChannelHandler[]{handler});
        Assert.assertTrue((boolean)ch1.isActive());
        EmbeddedChannel ch2 = IpSubnetFilterTest.newEmbeddedInetChannel("91.92.93.2", new ChannelHandler[]{handler});
        Assert.assertTrue((boolean)ch2.isActive());
        EmbeddedChannel ch3 = IpSubnetFilterTest.newEmbeddedInetChannel("91.92.93.1", new ChannelHandler[]{handler});
        Assert.assertFalse((boolean)ch3.isActive());
        Assert.assertFalse((boolean)ch1.finish());
        EmbeddedChannel ch4 = IpSubnetFilterTest.newEmbeddedInetChannel("91.92.93.1", new ChannelHandler[]{handler});
        Assert.assertTrue((boolean)ch4.isActive());
    }

    @Test
    public void testBinarySearch() {
        ArrayList<IpSubnetFilterRule> ipSubnetFilterRuleList = new ArrayList<IpSubnetFilterRule>();
        ipSubnetFilterRuleList.add(IpSubnetFilterTest.buildRejectIP("1.2.3.4", 32));
        ipSubnetFilterRuleList.add(IpSubnetFilterTest.buildRejectIP("1.1.1.1", 8));
        ipSubnetFilterRuleList.add(IpSubnetFilterTest.buildRejectIP("200.200.200.200", 32));
        ipSubnetFilterRuleList.add(IpSubnetFilterTest.buildRejectIP("108.0.0.0", 4));
        ipSubnetFilterRuleList.add(IpSubnetFilterTest.buildRejectIP("10.10.10.10", 8));
        ipSubnetFilterRuleList.add(IpSubnetFilterTest.buildRejectIP("2001:db8:abcd:0000::", 52));
        EmbeddedChannel ch1 = IpSubnetFilterTest.newEmbeddedInetChannel("1.1.1.1", new ChannelHandler[]{new IpSubnetFilter(ipSubnetFilterRuleList)});
        Assert.assertFalse((boolean)ch1.isActive());
        Assert.assertTrue((boolean)ch1.close().isSuccess());
        EmbeddedChannel ch2 = IpSubnetFilterTest.newEmbeddedInetChannel("2.2.2.2", new ChannelHandler[]{new IpSubnetFilter(ipSubnetFilterRuleList)});
        Assert.assertTrue((boolean)ch2.isActive());
        Assert.assertTrue((boolean)ch2.close().isSuccess());
        EmbeddedChannel ch3 = IpSubnetFilterTest.newEmbeddedInetChannel("97.100.100.100", new ChannelHandler[]{new IpSubnetFilter(ipSubnetFilterRuleList)});
        Assert.assertFalse((boolean)ch3.isActive());
        Assert.assertTrue((boolean)ch3.close().isSuccess());
        EmbeddedChannel ch4 = IpSubnetFilterTest.newEmbeddedInetChannel("200.200.200.200", new ChannelHandler[]{new IpSubnetFilter(ipSubnetFilterRuleList)});
        Assert.assertFalse((boolean)ch4.isActive());
        Assert.assertTrue((boolean)ch4.close().isSuccess());
        EmbeddedChannel ch5 = IpSubnetFilterTest.newEmbeddedInetChannel("127.0.0.1", new ChannelHandler[]{new IpSubnetFilter(ipSubnetFilterRuleList)});
        Assert.assertTrue((boolean)ch5.isActive());
        Assert.assertTrue((boolean)ch5.close().isSuccess());
        EmbeddedChannel ch6 = IpSubnetFilterTest.newEmbeddedInetChannel("10.1.1.2", new ChannelHandler[]{new IpSubnetFilter(ipSubnetFilterRuleList)});
        Assert.assertFalse((boolean)ch6.isActive());
        Assert.assertTrue((boolean)ch6.close().isSuccess());
        EmbeddedChannel ch7 = IpSubnetFilterTest.newEmbeddedInetChannel("2001:db8:abcd:1000::", new ChannelHandler[]{new IpSubnetFilter(ipSubnetFilterRuleList)});
        Assert.assertFalse((boolean)ch7.isActive());
        Assert.assertTrue((boolean)ch7.close().isSuccess());
    }

    private static IpSubnetFilterRule buildRejectIP(String ipAddress, int mask) {
        return new IpSubnetFilterRule(ipAddress, mask, IpFilterRuleType.REJECT);
    }

    private static EmbeddedChannel newEmbeddedInetChannel(final String ipAddress, ChannelHandler ... handlers) {
        return new EmbeddedChannel(handlers){

            protected SocketAddress remoteAddress0() {
                return this.isActive() ? SocketUtils.socketAddress((String)ipAddress, (int)5421) : null;
            }
        };
    }

    private static InetSocketAddress newSockAddress(String ipAddress) {
        return SocketUtils.socketAddress((String)ipAddress, (int)1234);
    }
}

