/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.timeout;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class IdleStateHandlerTest {
    @Test
    public void testReaderIdle() throws Exception {
        TestableIdleStateHandler idleStateHandler = new TestableIdleStateHandler(false, 1L, 0L, 0L, TimeUnit.SECONDS);
        IdleStateHandlerTest.anyIdle(idleStateHandler, IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT, IdleStateEvent.READER_IDLE_STATE_EVENT, IdleStateEvent.READER_IDLE_STATE_EVENT);
    }

    @Test
    public void testWriterIdle() throws Exception {
        TestableIdleStateHandler idleStateHandler = new TestableIdleStateHandler(false, 0L, 1L, 0L, TimeUnit.SECONDS);
        IdleStateHandlerTest.anyIdle(idleStateHandler, IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT, IdleStateEvent.WRITER_IDLE_STATE_EVENT, IdleStateEvent.WRITER_IDLE_STATE_EVENT);
    }

    @Test
    public void testAllIdle() throws Exception {
        TestableIdleStateHandler idleStateHandler = new TestableIdleStateHandler(false, 0L, 0L, 1L, TimeUnit.SECONDS);
        IdleStateHandlerTest.anyIdle(idleStateHandler, IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT, IdleStateEvent.ALL_IDLE_STATE_EVENT, IdleStateEvent.ALL_IDLE_STATE_EVENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void anyIdle(TestableIdleStateHandler idleStateHandler, Object ... expected) throws Exception {
        Assert.assertTrue((String)"The number of expected events must be >= 1", (expected.length >= 1 ? 1 : 0) != 0);
        final ArrayList events = new ArrayList();
        ChannelInboundHandlerAdapter handler = new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                events.add(evt);
            }
        };
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{idleStateHandler, handler});
        try {
            int i;
            for (i = 0; i < expected.length; ++i) {
                idleStateHandler.tickRun();
            }
            Assert.assertEquals((long)expected.length, (long)events.size());
            for (i = 0; i < expected.length; ++i) {
                Object evt = events.get(i);
                Assert.assertSame((String)("Element " + i + " is not matching"), (Object)expected[i], evt);
            }
        }
        finally {
            channel.finishAndReleaseAll();
        }
    }

    @Test
    public void testReaderNotIdle() throws Exception {
        TestableIdleStateHandler idleStateHandler = new TestableIdleStateHandler(false, 1L, 0L, 0L, TimeUnit.SECONDS);
        Action action = new Action(){

            @Override
            public void run(EmbeddedChannel channel) throws Exception {
                channel.writeInbound(new Object[]{"Hello, World!"});
            }
        };
        IdleStateHandlerTest.anyNotIdle(idleStateHandler, action, IdleStateEvent.FIRST_READER_IDLE_STATE_EVENT);
    }

    @Test
    public void testWriterNotIdle() throws Exception {
        TestableIdleStateHandler idleStateHandler = new TestableIdleStateHandler(false, 0L, 1L, 0L, TimeUnit.SECONDS);
        Action action = new Action(){

            @Override
            public void run(EmbeddedChannel channel) throws Exception {
                channel.writeAndFlush((Object)"Hello, World!");
            }
        };
        IdleStateHandlerTest.anyNotIdle(idleStateHandler, action, IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT);
    }

    @Test
    public void testAllNotIdle() throws Exception {
        TestableIdleStateHandler idleStateHandler = new TestableIdleStateHandler(false, 0L, 0L, 1L, TimeUnit.SECONDS);
        Action reader = new Action(){

            @Override
            public void run(EmbeddedChannel channel) throws Exception {
                channel.writeInbound(new Object[]{"Hello, World!"});
            }
        };
        IdleStateHandlerTest.anyNotIdle(idleStateHandler, reader, IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT);
        idleStateHandler = new TestableIdleStateHandler(false, 0L, 0L, 1L, TimeUnit.SECONDS);
        Action writer = new Action(){

            @Override
            public void run(EmbeddedChannel channel) throws Exception {
                channel.writeAndFlush((Object)"Hello, World!");
            }
        };
        IdleStateHandlerTest.anyNotIdle(idleStateHandler, writer, IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void anyNotIdle(TestableIdleStateHandler idleStateHandler, Action action, Object expected) throws Exception {
        final ArrayList events = new ArrayList();
        ChannelInboundHandlerAdapter handler = new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                events.add(evt);
            }
        };
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{idleStateHandler, handler});
        try {
            idleStateHandler.tick(1L, TimeUnit.NANOSECONDS);
            action.run(channel);
            long delayInNanos = idleStateHandler.delay(TimeUnit.NANOSECONDS);
            Assert.assertNotEquals((long)0L, (long)delayInNanos);
            idleStateHandler.tickRun(delayInNanos / 2L, TimeUnit.NANOSECONDS);
            Assert.assertEquals((long)0L, (long)events.size());
            idleStateHandler.tickRun();
            Assert.assertEquals((long)1L, (long)events.size());
            Assert.assertSame((Object)expected, events.get(0));
        }
        finally {
            channel.finishAndReleaseAll();
        }
    }

    @Test
    public void testObserveWriterIdle() throws Exception {
        IdleStateHandlerTest.observeOutputIdle(true);
    }

    @Test
    public void testObserveAllIdle() throws Exception {
        IdleStateHandlerTest.observeOutputIdle(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void observeOutputIdle(boolean writer) throws Exception {
        IdleStateEvent expected;
        long writerIdleTime = 0L;
        long allIdleTime = 0L;
        if (writer) {
            writerIdleTime = 5L;
            expected = IdleStateEvent.FIRST_WRITER_IDLE_STATE_EVENT;
        } else {
            allIdleTime = 5L;
            expected = IdleStateEvent.FIRST_ALL_IDLE_STATE_EVENT;
        }
        TestableIdleStateHandler idleStateHandler = new TestableIdleStateHandler(true, 0L, writerIdleTime, allIdleTime, TimeUnit.SECONDS);
        final ArrayList events = new ArrayList();
        ChannelInboundHandlerAdapter handler = new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                events.add(evt);
            }
        };
        ObservableChannel channel = new ObservableChannel(new ChannelHandler[]{idleStateHandler, handler});
        try {
            channel.writeAndFlush(Unpooled.wrappedBuffer((byte[])new byte[]{1}));
            channel.writeAndFlush(Unpooled.wrappedBuffer((byte[])new byte[]{2}));
            channel.writeAndFlush(Unpooled.wrappedBuffer((byte[])new byte[]{3}));
            channel.writeAndFlush(Unpooled.wrappedBuffer((byte[])new byte[5120]));
            idleStateHandler.tickRun();
            Assert.assertEquals((long)1L, (long)events.size());
            Assert.assertSame((Object)expected, events.get(0));
            events.clear();
            Assert.assertEquals((long)5L, (long)idleStateHandler.tick(TimeUnit.SECONDS));
            idleStateHandler.tick(4L, TimeUnit.SECONDS);
            IdleStateHandlerTest.assertNotNullAndRelease(channel.consume());
            idleStateHandler.tickRun(2L, TimeUnit.SECONDS);
            Assert.assertEquals((long)0L, (long)events.size());
            Assert.assertEquals((long)11L, (long)idleStateHandler.tick(TimeUnit.SECONDS));
            idleStateHandler.tick(3L, TimeUnit.SECONDS);
            IdleStateHandlerTest.assertNotNullAndRelease(channel.consume());
            idleStateHandler.tickRun(4L, TimeUnit.SECONDS);
            Assert.assertEquals((long)0L, (long)events.size());
            Assert.assertEquals((long)18L, (long)idleStateHandler.tick(TimeUnit.SECONDS));
            idleStateHandler.tickRun(5L, TimeUnit.SECONDS);
            Assert.assertEquals((long)1L, (long)events.size());
            Assert.assertEquals((long)23L, (long)idleStateHandler.tick(TimeUnit.SECONDS));
            events.clear();
            idleStateHandler.tick(2L, TimeUnit.SECONDS);
            IdleStateHandlerTest.assertNotNullAndRelease(channel.consume());
            idleStateHandler.tickRun(1L, TimeUnit.SECONDS);
            Assert.assertEquals((long)0L, (long)events.size());
            Assert.assertEquals((long)26L, (long)idleStateHandler.tick(TimeUnit.SECONDS));
            idleStateHandler.tick(2L, TimeUnit.SECONDS);
            IdleStateHandlerTest.assertNotNullAndRelease(channel.consumePart(1024));
            idleStateHandler.tick(2L, TimeUnit.SECONDS);
            IdleStateHandlerTest.assertNotNullAndRelease(channel.consumePart(1024));
            idleStateHandler.tickRun(1L, TimeUnit.SECONDS);
            Assert.assertEquals((long)1L, (long)events.size());
            Assert.assertEquals((long)31L, (long)idleStateHandler.tick(TimeUnit.SECONDS));
            events.clear();
            idleStateHandler.tick(2L, TimeUnit.SECONDS);
            IdleStateHandlerTest.assertNotNullAndRelease(channel.consumePart(1024));
            idleStateHandler.tick(2L, TimeUnit.SECONDS);
            IdleStateHandlerTest.assertNotNullAndRelease(channel.consumePart(1024));
            idleStateHandler.tickRun(1L, TimeUnit.SECONDS);
            Assert.assertEquals((long)0L, (long)events.size());
            Assert.assertEquals((long)36L, (long)idleStateHandler.tick(TimeUnit.SECONDS));
            idleStateHandler.tick(2L, TimeUnit.SECONDS);
            IdleStateHandlerTest.assertNotNullAndRelease(channel.consumePart(1024));
            idleStateHandler.tick(3L, TimeUnit.SECONDS);
            Assert.assertNull((Object)channel.consume());
            idleStateHandler.tickRun(2L, TimeUnit.SECONDS);
            Assert.assertEquals((long)1L, (long)events.size());
            Assert.assertEquals((long)43L, (long)idleStateHandler.tick(TimeUnit.SECONDS));
        }
        finally {
            channel.finishAndReleaseAll();
        }
    }

    private static void assertNotNullAndRelease(Object msg) {
        Assert.assertNotNull((Object)msg);
        ReferenceCountUtil.release((Object)msg);
    }

    private static class ObservableChannel
    extends EmbeddedChannel {
        ObservableChannel(ChannelHandler ... handlers) {
            super(handlers);
        }

        protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        }

        private Object consume() {
            Object msg;
            ChannelOutboundBuffer buf = this.unsafe().outboundBuffer();
            if (buf != null && (msg = buf.current()) != null) {
                ReferenceCountUtil.retain((Object)msg);
                buf.remove();
                return msg;
            }
            return null;
        }

        private Object consumePart(int byteCount) {
            Object msg;
            ChannelOutboundBuffer buf = this.unsafe().outboundBuffer();
            if (buf != null && (msg = buf.current()) != null) {
                ReferenceCountUtil.retain((Object)msg);
                buf.removeBytes((long)byteCount);
                return msg;
            }
            return null;
        }
    }

    private static class TestableIdleStateHandler
    extends IdleStateHandler {
        private Runnable task;
        private long delayInNanos;
        private long ticksInNanos;

        TestableIdleStateHandler(boolean observeOutput, long readerIdleTime, long writerIdleTime, long allIdleTime, TimeUnit unit) {
            super(observeOutput, readerIdleTime, writerIdleTime, allIdleTime, unit);
        }

        public long delay(TimeUnit unit) {
            return unit.convert(this.delayInNanos, TimeUnit.NANOSECONDS);
        }

        public void run() {
            this.task.run();
        }

        public void tickRun() {
            this.tickRun(this.delayInNanos, TimeUnit.NANOSECONDS);
        }

        public void tickRun(long delay, TimeUnit unit) {
            this.tick(delay, unit);
            this.run();
        }

        public void tick(long delay, TimeUnit unit) {
            this.ticksInNanos += unit.toNanos(delay);
        }

        public long tick(TimeUnit unit) {
            return unit.convert(this.ticksInNanos(), TimeUnit.NANOSECONDS);
        }

        long ticksInNanos() {
            return this.ticksInNanos;
        }

        ScheduledFuture<?> schedule(ChannelHandlerContext ctx, Runnable task, long delay, TimeUnit unit) {
            this.task = task;
            this.delayInNanos = unit.toNanos(delay);
            return null;
        }
    }

    private static interface Action {
        public void run(EmbeddedChannel var1) throws Exception;
    }
}

