/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.Conscrypt;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkAlpnSslEngine;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslMasterKeyHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SslUtils;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.handler.ssl.util.SimpleTrustManagerFactory;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.UnaryPromiseNotifier;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ResourcesUtil;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.conscrypt.OpenSSLProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public abstract class SSLEngineTest {
    private static final String PRINCIPAL_NAME = "CN=e8ac02fa0d65a84219016045db8b05c485b4ecdf.netty.test";
    @Mock
    protected MessageReceiver serverReceiver;
    @Mock
    protected MessageReceiver clientReceiver;
    protected Throwable serverException;
    protected Throwable clientException;
    protected SslContext serverSslCtx;
    protected SslContext clientSslCtx;
    protected ServerBootstrap sb;
    protected Bootstrap cb;
    protected Channel serverChannel;
    protected Channel serverConnectedChannel;
    protected Channel clientChannel;
    protected CountDownLatch serverLatch;
    protected CountDownLatch clientLatch;
    private final BufferType type;
    protected final ProtocolCipherCombo protocolCipherCombo;
    private final boolean delegate;
    private ExecutorService delegatingExecutor;

    protected SSLEngineTest(BufferType type, ProtocolCipherCombo protocolCipherCombo, boolean delegate) {
        this.type = type;
        this.protocolCipherCombo = protocolCipherCombo;
        this.delegate = delegate;
    }

    protected ByteBuffer allocateBuffer(int len) {
        switch (this.type) {
            case Direct: {
                return ByteBuffer.allocateDirect(len);
            }
            case Heap: {
                return ByteBuffer.allocate(len);
            }
            case Mixed: {
                return PlatformDependent.threadLocalRandom().nextBoolean() ? ByteBuffer.allocateDirect(len) : ByteBuffer.allocate(len);
            }
        }
        throw new Error();
    }

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.serverLatch = new CountDownLatch(1);
        this.clientLatch = new CountDownLatch(1);
        if (this.delegate) {
            this.delegatingExecutor = Executors.newCachedThreadPool();
        }
    }

    @After
    public void tearDown() throws InterruptedException {
        ChannelFuture clientCloseFuture = null;
        ChannelFuture serverConnectedCloseFuture = null;
        ChannelFuture serverCloseFuture = null;
        if (this.clientChannel != null) {
            clientCloseFuture = this.clientChannel.close();
            this.clientChannel = null;
        }
        if (this.serverConnectedChannel != null) {
            serverConnectedCloseFuture = this.serverConnectedChannel.close();
            this.serverConnectedChannel = null;
        }
        if (this.serverChannel != null) {
            serverCloseFuture = this.serverChannel.close();
            this.serverChannel = null;
        }
        if (clientCloseFuture != null) {
            clientCloseFuture.sync();
        }
        if (serverConnectedCloseFuture != null) {
            serverConnectedCloseFuture.sync();
        }
        if (serverCloseFuture != null) {
            serverCloseFuture.sync();
        }
        if (this.serverSslCtx != null) {
            this.cleanupServerSslContext(this.serverSslCtx);
            this.serverSslCtx = null;
        }
        if (this.clientSslCtx != null) {
            this.cleanupClientSslContext(this.clientSslCtx);
            this.clientSslCtx = null;
        }
        Future serverGroupShutdownFuture = null;
        Future serverChildGroupShutdownFuture = null;
        Future clientGroupShutdownFuture = null;
        if (this.sb != null) {
            serverGroupShutdownFuture = this.sb.config().group().shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
            serverChildGroupShutdownFuture = this.sb.config().childGroup().shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
        }
        if (this.cb != null) {
            clientGroupShutdownFuture = this.cb.config().group().shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
        }
        if (serverGroupShutdownFuture != null) {
            serverGroupShutdownFuture.sync();
            serverChildGroupShutdownFuture.sync();
        }
        if (clientGroupShutdownFuture != null) {
            clientGroupShutdownFuture.sync();
        }
        this.serverException = null;
        if (this.delegatingExecutor != null) {
            this.delegatingExecutor.shutdown();
        }
    }

    @Test
    public void testMutualAuthSameCerts() throws Throwable {
        this.mySetupMutualAuth(ResourcesUtil.getFile(this.getClass(), (String)"test_unencrypted.pem"), ResourcesUtil.getFile(this.getClass(), (String)"test.crt"), null);
        this.runTest(null);
        Assert.assertTrue((boolean)this.serverLatch.await(2L, TimeUnit.SECONDS));
        Throwable cause = this.serverException;
        if (cause != null) {
            throw cause;
        }
    }

    @Test
    public void testMutualAuthDiffCerts() throws Exception {
        File serverKeyFile = ResourcesUtil.getFile(this.getClass(), (String)"test_encrypted.pem");
        File serverCrtFile = ResourcesUtil.getFile(this.getClass(), (String)"test.crt");
        String serverKeyPassword = "12345";
        File clientKeyFile = ResourcesUtil.getFile(this.getClass(), (String)"test2_encrypted.pem");
        File clientCrtFile = ResourcesUtil.getFile(this.getClass(), (String)"test2.crt");
        String clientKeyPassword = "12345";
        this.mySetupMutualAuth(clientCrtFile, serverKeyFile, serverCrtFile, serverKeyPassword, serverCrtFile, clientKeyFile, clientCrtFile, clientKeyPassword);
        this.runTest(null);
        Assert.assertTrue((boolean)this.serverLatch.await(2L, TimeUnit.SECONDS));
    }

    @Test
    public void testMutualAuthDiffCertsServerFailure() throws Exception {
        File serverKeyFile = ResourcesUtil.getFile(this.getClass(), (String)"test_encrypted.pem");
        File serverCrtFile = ResourcesUtil.getFile(this.getClass(), (String)"test.crt");
        String serverKeyPassword = "12345";
        File clientKeyFile = ResourcesUtil.getFile(this.getClass(), (String)"test2_encrypted.pem");
        File clientCrtFile = ResourcesUtil.getFile(this.getClass(), (String)"test2.crt");
        String clientKeyPassword = "12345";
        this.mySetupMutualAuth(serverCrtFile, serverKeyFile, serverCrtFile, serverKeyPassword, serverCrtFile, clientKeyFile, clientCrtFile, clientKeyPassword);
        Assert.assertTrue((boolean)this.serverLatch.await(2L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)(this.serverException instanceof SSLHandshakeException));
    }

    @Test
    public void testMutualAuthDiffCertsClientFailure() throws Exception {
        File serverKeyFile = ResourcesUtil.getFile(this.getClass(), (String)"test_unencrypted.pem");
        File serverCrtFile = ResourcesUtil.getFile(this.getClass(), (String)"test.crt");
        String serverKeyPassword = null;
        File clientKeyFile = ResourcesUtil.getFile(this.getClass(), (String)"test2_unencrypted.pem");
        File clientCrtFile = ResourcesUtil.getFile(this.getClass(), (String)"test2.crt");
        String clientKeyPassword = null;
        this.mySetupMutualAuth(clientCrtFile, serverKeyFile, serverCrtFile, serverKeyPassword, clientCrtFile, clientKeyFile, clientCrtFile, clientKeyPassword);
        Assert.assertTrue((boolean)this.clientLatch.await(2L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)(this.clientException instanceof SSLHandshakeException));
    }

    @Test
    public void testMutualAuthInvalidIntermediateCASucceedWithOptionalClientAuth() throws Exception {
        this.testMutualAuthInvalidClientCertSucceed(ClientAuth.NONE);
    }

    @Test
    public void testMutualAuthInvalidIntermediateCAFailWithOptionalClientAuth() throws Exception {
        this.testMutualAuthClientCertFail(ClientAuth.OPTIONAL);
    }

    @Test
    public void testMutualAuthInvalidIntermediateCAFailWithRequiredClientAuth() throws Exception {
        this.testMutualAuthClientCertFail(ClientAuth.REQUIRE);
    }

    @Test
    public void testMutualAuthValidClientCertChainTooLongFailOptionalClientAuth() throws Exception {
        this.testMutualAuthClientCertFail(ClientAuth.OPTIONAL, "mutual_auth_client.p12", true);
    }

    @Test
    public void testMutualAuthValidClientCertChainTooLongFailRequireClientAuth() throws Exception {
        this.testMutualAuthClientCertFail(ClientAuth.REQUIRE, "mutual_auth_client.p12", true);
    }

    private void testMutualAuthInvalidClientCertSucceed(ClientAuth auth) throws Exception {
        char[] password = "example".toCharArray();
        KeyStore serverKeyStore = KeyStore.getInstance("PKCS12");
        serverKeyStore.load(this.getClass().getResourceAsStream("mutual_auth_server.p12"), password);
        KeyStore clientKeyStore = KeyStore.getInstance("PKCS12");
        clientKeyStore.load(this.getClass().getResourceAsStream("mutual_auth_invalid_client.p12"), password);
        KeyManagerFactory serverKeyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        serverKeyManagerFactory.init(serverKeyStore, password);
        KeyManagerFactory clientKeyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        clientKeyManagerFactory.init(clientKeyStore, password);
        File commonCertChain = ResourcesUtil.getFile(this.getClass(), (String)"mutual_auth_ca.pem");
        this.mySetupMutualAuth(serverKeyManagerFactory, commonCertChain, clientKeyManagerFactory, commonCertChain, auth, false, false);
        Assert.assertTrue((boolean)this.clientLatch.await(5L, TimeUnit.SECONDS));
        Assert.assertNull((Object)this.clientException);
        Assert.assertTrue((boolean)this.serverLatch.await(5L, TimeUnit.SECONDS));
        Assert.assertNull((Object)this.serverException);
    }

    private void testMutualAuthClientCertFail(ClientAuth auth) throws Exception {
        this.testMutualAuthClientCertFail(auth, "mutual_auth_invalid_client.p12", false);
    }

    private void testMutualAuthClientCertFail(ClientAuth auth, String clientCert, boolean serverInitEngine) throws Exception {
        char[] password = "example".toCharArray();
        KeyStore serverKeyStore = KeyStore.getInstance("PKCS12");
        serverKeyStore.load(this.getClass().getResourceAsStream("mutual_auth_server.p12"), password);
        KeyStore clientKeyStore = KeyStore.getInstance("PKCS12");
        clientKeyStore.load(this.getClass().getResourceAsStream(clientCert), password);
        KeyManagerFactory serverKeyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        serverKeyManagerFactory.init(serverKeyStore, password);
        KeyManagerFactory clientKeyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        clientKeyManagerFactory.init(clientKeyStore, password);
        File commonCertChain = ResourcesUtil.getFile(this.getClass(), (String)"mutual_auth_ca.pem");
        this.mySetupMutualAuth(serverKeyManagerFactory, commonCertChain, clientKeyManagerFactory, commonCertChain, auth, true, serverInitEngine);
        Assert.assertTrue((boolean)this.clientLatch.await(5L, TimeUnit.SECONDS));
        Assert.assertTrue((String)("unexpected exception: " + this.clientException), (boolean)this.mySetupMutualAuthServerIsValidClientException(this.clientException));
        Assert.assertTrue((boolean)this.serverLatch.await(5L, TimeUnit.SECONDS));
        Assert.assertTrue((String)("unexpected exception: " + this.serverException), (boolean)this.mySetupMutualAuthServerIsValidServerException(this.serverException));
    }

    protected static boolean causedBySSLException(Throwable cause) {
        Throwable next = cause;
        do {
            if (!(next instanceof SSLException)) continue;
            return true;
        } while ((next = next.getCause()) != null);
        return false;
    }

    protected boolean mySetupMutualAuthServerIsValidServerException(Throwable cause) {
        return this.mySetupMutualAuthServerIsValidException(cause);
    }

    protected boolean mySetupMutualAuthServerIsValidClientException(Throwable cause) {
        return this.mySetupMutualAuthServerIsValidException(cause);
    }

    protected boolean mySetupMutualAuthServerIsValidException(Throwable cause) {
        return cause instanceof SSLException || cause instanceof ClosedChannelException;
    }

    protected void mySetupMutualAuthServerInitSslHandler(SslHandler handler) {
    }

    private void mySetupMutualAuth(KeyManagerFactory serverKMF, File serverTrustManager, KeyManagerFactory clientKMF, File clientTrustManager, ClientAuth clientAuth, final boolean failureExpected, final boolean serverInitEngine) throws SSLException, InterruptedException {
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((KeyManagerFactory)serverKMF).protocols(this.protocols()).ciphers(this.ciphers()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).trustManager(serverTrustManager).clientAuth(clientAuth).ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE).sessionCacheSize(0L).sessionTimeout(0L).build());
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().protocols(this.protocols()).ciphers(this.ciphers()).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).trustManager(clientTrustManager).keyManager(clientKMF).ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE).sessionCacheSize(0L).sessionTimeout(0L).build());
        this.serverConnectedChannel = null;
        this.sb = new ServerBootstrap();
        this.cb = new Bootstrap();
        this.sb.group((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup());
        this.sb.channel(NioServerSocketChannel.class);
        this.sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                SslHandler handler;
                ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), SSLEngineTest.this.type));
                ChannelPipeline p = ch.pipeline();
                SslHandler sslHandler = handler = SSLEngineTest.this.delegatingExecutor == null ? SSLEngineTest.this.serverSslCtx.newHandler(ch.alloc()) : SSLEngineTest.this.serverSslCtx.newHandler(ch.alloc(), (Executor)SSLEngineTest.this.delegatingExecutor);
                if (serverInitEngine) {
                    SSLEngineTest.this.mySetupMutualAuthServerInitSslHandler(handler);
                }
                p.addLast(new ChannelHandler[]{handler});
                p.addLast(new ChannelHandler[]{new MessageDelegatorChannelHandler(SSLEngineTest.this.serverReceiver, SSLEngineTest.this.serverLatch)});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt == SslHandshakeCompletionEvent.SUCCESS) {
                            if (failureExpected) {
                                SSLEngineTest.this.serverException = new IllegalStateException("handshake complete. expected failure");
                            }
                            SSLEngineTest.this.serverLatch.countDown();
                        } else if (evt instanceof SslHandshakeCompletionEvent) {
                            SSLEngineTest.this.serverException = ((SslHandshakeCompletionEvent)evt).cause();
                            SSLEngineTest.this.serverLatch.countDown();
                        }
                        ctx.fireUserEventTriggered(evt);
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        if (cause.getCause() instanceof SSLHandshakeException) {
                            SSLEngineTest.this.serverException = cause.getCause();
                            SSLEngineTest.this.serverLatch.countDown();
                        } else {
                            SSLEngineTest.this.serverException = cause;
                            ctx.fireExceptionCaught(cause);
                        }
                    }
                }});
                SSLEngineTest.this.serverConnectedChannel = ch;
            }
        });
        this.cb.group((EventLoopGroup)new NioEventLoopGroup());
        this.cb.channel(NioSocketChannel.class);
        this.cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), SSLEngineTest.this.type));
                ChannelPipeline p = ch.pipeline();
                SslHandler handler = SSLEngineTest.this.delegatingExecutor == null ? SSLEngineTest.this.clientSslCtx.newHandler(ch.alloc()) : SSLEngineTest.this.clientSslCtx.newHandler(ch.alloc(), (Executor)SSLEngineTest.this.delegatingExecutor);
                p.addLast(new ChannelHandler[]{handler});
                p.addLast(new ChannelHandler[]{new MessageDelegatorChannelHandler(SSLEngineTest.this.clientReceiver, SSLEngineTest.this.clientLatch)});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt == SslHandshakeCompletionEvent.SUCCESS) {
                            if (!failureExpected) {
                                SSLEngineTest.this.clientLatch.countDown();
                            }
                        } else if (evt instanceof SslHandshakeCompletionEvent) {
                            SSLEngineTest.this.clientException = ((SslHandshakeCompletionEvent)evt).cause();
                            SSLEngineTest.this.clientLatch.countDown();
                        }
                        ctx.fireUserEventTriggered(evt);
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        if (cause.getCause() instanceof SSLException) {
                            SSLEngineTest.this.clientException = cause.getCause();
                            SSLEngineTest.this.clientLatch.countDown();
                        } else {
                            ctx.fireExceptionCaught(cause);
                        }
                    }
                }});
            }
        });
        this.serverChannel = this.sb.bind((SocketAddress)new InetSocketAddress(8443)).sync().channel();
        int port = ((InetSocketAddress)this.serverChannel.localAddress()).getPort();
        ChannelFuture ccf = this.cb.connect((SocketAddress)new InetSocketAddress(NetUtil.LOCALHOST, port));
        Assert.assertTrue((boolean)ccf.awaitUninterruptibly().isSuccess());
        this.clientChannel = ccf.channel();
    }

    @Test
    public void testClientHostnameValidationSuccess() throws InterruptedException, SSLException {
        this.mySetupClientHostnameValidation(ResourcesUtil.getFile(this.getClass(), (String)"localhost_server.pem"), ResourcesUtil.getFile(this.getClass(), (String)"localhost_server.key"), ResourcesUtil.getFile(this.getClass(), (String)"mutual_auth_ca.pem"), false);
        Assert.assertTrue((boolean)this.clientLatch.await(5L, TimeUnit.SECONDS));
        Assert.assertNull((Object)this.clientException);
        Assert.assertTrue((boolean)this.serverLatch.await(5L, TimeUnit.SECONDS));
        Assert.assertNull((Object)this.serverException);
    }

    @Test
    public void testClientHostnameValidationFail() throws InterruptedException, SSLException {
        Future<Void> clientWriteFuture = this.mySetupClientHostnameValidation(ResourcesUtil.getFile(this.getClass(), (String)"notlocalhost_server.pem"), ResourcesUtil.getFile(this.getClass(), (String)"notlocalhost_server.key"), ResourcesUtil.getFile(this.getClass(), (String)"mutual_auth_ca.pem"), true);
        Assert.assertTrue((boolean)this.clientLatch.await(5L, TimeUnit.SECONDS));
        Assert.assertTrue((String)("unexpected exception: " + this.clientException), (boolean)this.mySetupMutualAuthServerIsValidClientException(this.clientException));
        Assert.assertTrue((boolean)this.serverLatch.await(5L, TimeUnit.SECONDS));
        Assert.assertTrue((String)("unexpected exception: " + this.serverException), (boolean)this.mySetupMutualAuthServerIsValidServerException(this.serverException));
        clientWriteFuture.awaitUninterruptibly();
        Throwable actualCause = clientWriteFuture.cause();
        Assert.assertSame((Object)this.clientException, (Object)actualCause);
    }

    private Future<Void> mySetupClientHostnameValidation(File serverCrtFile, File serverKeyFile, File clientTrustCrtFile, final boolean failureExpected) throws SSLException, InterruptedException {
        String expectedHost = "localhost";
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)serverCrtFile, (File)serverKeyFile, null).sslProvider(this.sslServerProvider()).protocols(this.protocols()).ciphers(this.ciphers()).sslContextProvider(this.serverSslContextProvider()).trustManager(InsecureTrustManagerFactory.INSTANCE).ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE).sessionCacheSize(0L).sessionTimeout(0L).build());
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().sslProvider(this.sslClientProvider()).protocols(this.protocols()).ciphers(this.ciphers()).sslContextProvider(this.clientSslContextProvider()).trustManager(clientTrustCrtFile).ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE).sessionCacheSize(0L).sessionTimeout(0L).build());
        this.serverConnectedChannel = null;
        this.sb = new ServerBootstrap();
        this.cb = new Bootstrap();
        this.sb.group((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup());
        this.sb.channel(NioServerSocketChannel.class);
        this.sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), SSLEngineTest.this.type));
                ChannelPipeline p = ch.pipeline();
                SslHandler handler = SSLEngineTest.this.delegatingExecutor == null ? SSLEngineTest.this.serverSslCtx.newHandler(ch.alloc()) : SSLEngineTest.this.serverSslCtx.newHandler(ch.alloc(), (Executor)SSLEngineTest.this.delegatingExecutor);
                p.addLast(new ChannelHandler[]{handler});
                p.addLast(new ChannelHandler[]{new MessageDelegatorChannelHandler(SSLEngineTest.this.serverReceiver, SSLEngineTest.this.serverLatch)});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt == SslHandshakeCompletionEvent.SUCCESS) {
                            if (failureExpected) {
                                SSLEngineTest.this.serverException = new IllegalStateException("handshake complete. expected failure");
                            }
                            SSLEngineTest.this.serverLatch.countDown();
                        } else if (evt instanceof SslHandshakeCompletionEvent) {
                            SSLEngineTest.this.serverException = ((SslHandshakeCompletionEvent)evt).cause();
                            SSLEngineTest.this.serverLatch.countDown();
                        }
                        ctx.fireUserEventTriggered(evt);
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        if (cause.getCause() instanceof SSLHandshakeException) {
                            SSLEngineTest.this.serverException = cause.getCause();
                            SSLEngineTest.this.serverLatch.countDown();
                        } else {
                            SSLEngineTest.this.serverException = cause;
                            ctx.fireExceptionCaught(cause);
                        }
                    }
                }});
                SSLEngineTest.this.serverConnectedChannel = ch;
            }
        });
        final Promise clientWritePromise = ImmediateEventExecutor.INSTANCE.newPromise();
        this.cb.group((EventLoopGroup)new NioEventLoopGroup());
        this.cb.channel(NioSocketChannel.class);
        this.cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), SSLEngineTest.this.type));
                ChannelPipeline p = ch.pipeline();
                InetSocketAddress remoteAddress = (InetSocketAddress)SSLEngineTest.this.serverChannel.localAddress();
                SslHandler sslHandler = SSLEngineTest.this.delegatingExecutor == null ? SSLEngineTest.this.clientSslCtx.newHandler(ch.alloc(), "localhost", 0) : SSLEngineTest.this.clientSslCtx.newHandler(ch.alloc(), "localhost", 0, (Executor)SSLEngineTest.this.delegatingExecutor);
                SSLParameters parameters = sslHandler.engine().getSSLParameters();
                if (SslUtils.isValidHostNameForSNI((String)"localhost")) {
                    Assert.assertEquals((long)1L, (long)parameters.getServerNames().size());
                    Assert.assertEquals((Object)new SNIHostName("localhost"), (Object)parameters.getServerNames().get(0));
                }
                parameters.setEndpointIdentificationAlgorithm("HTTPS");
                sslHandler.engine().setSSLParameters(parameters);
                p.addLast(new ChannelHandler[]{sslHandler});
                p.addLast(new ChannelHandler[]{new MessageDelegatorChannelHandler(SSLEngineTest.this.clientReceiver, SSLEngineTest.this.clientLatch)});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void handlerAdded(ChannelHandlerContext ctx) {
                        if (failureExpected) {
                            ctx.write((Object)ctx.alloc().buffer(1).writeByte(1)).addListener((GenericFutureListener)new UnaryPromiseNotifier(clientWritePromise));
                        }
                    }

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt == SslHandshakeCompletionEvent.SUCCESS) {
                            if (failureExpected) {
                                SSLEngineTest.this.clientException = new IllegalStateException("handshake complete. expected failure");
                            }
                            SSLEngineTest.this.clientLatch.countDown();
                        } else if (evt instanceof SslHandshakeCompletionEvent) {
                            SSLEngineTest.this.clientException = ((SslHandshakeCompletionEvent)evt).cause();
                            SSLEngineTest.this.clientLatch.countDown();
                        }
                        ctx.fireUserEventTriggered(evt);
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        if (cause.getCause() instanceof SSLHandshakeException) {
                            SSLEngineTest.this.clientException = cause.getCause();
                            SSLEngineTest.this.clientLatch.countDown();
                        } else {
                            ctx.fireExceptionCaught(cause);
                        }
                    }
                }});
            }
        });
        this.serverChannel = this.sb.bind((SocketAddress)new InetSocketAddress("localhost", 0)).sync().channel();
        int port = ((InetSocketAddress)this.serverChannel.localAddress()).getPort();
        ChannelFuture ccf = this.cb.connect((SocketAddress)new InetSocketAddress("localhost", port));
        Assert.assertTrue((boolean)ccf.awaitUninterruptibly().isSuccess());
        this.clientChannel = ccf.channel();
        return clientWritePromise;
    }

    private void mySetupMutualAuth(File keyFile, File crtFile, String keyPassword) throws SSLException, InterruptedException {
        this.mySetupMutualAuth(crtFile, keyFile, crtFile, keyPassword, crtFile, keyFile, crtFile, keyPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifySSLSessionForMutualAuth(SSLSession session, File certFile, String principalName) throws Exception {
        InputStream in = null;
        try {
            Assert.assertEquals((Object)principalName, (Object)session.getLocalPrincipal().getName());
            Assert.assertEquals((Object)principalName, (Object)session.getPeerPrincipal().getName());
            Assert.assertNotNull((Object)session.getId());
            Assert.assertEquals((Object)this.protocolCipherCombo.cipher, (Object)session.getCipherSuite());
            Assert.assertEquals((Object)this.protocolCipherCombo.protocol, (Object)session.getProtocol());
            Assert.assertTrue((session.getApplicationBufferSize() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((session.getCreationTime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((boolean)session.isValid());
            Assert.assertTrue((session.getLastAccessedTime() > 0L ? 1 : 0) != 0);
            in = new FileInputStream(certFile);
            byte[] certBytes = SslContext.X509_CERT_FACTORY.generateCertificate(in).getEncoded();
            Assert.assertEquals((long)1L, (long)session.getPeerCertificates().length);
            Assert.assertArrayEquals((byte[])certBytes, (byte[])session.getPeerCertificates()[0].getEncoded());
            try {
                Assert.assertEquals((long)1L, (long)session.getPeerCertificateChain().length);
                Assert.assertArrayEquals((byte[])certBytes, (byte[])session.getPeerCertificateChain()[0].getEncoded());
            }
            catch (UnsupportedOperationException e) {
                Assert.assertTrue((PlatformDependent.javaVersion() >= 15 ? 1 : 0) != 0);
            }
            Assert.assertEquals((long)1L, (long)session.getLocalCertificates().length);
            Assert.assertArrayEquals((byte[])certBytes, (byte[])session.getLocalCertificates()[0].getEncoded());
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private void mySetupMutualAuth(File servertTrustCrtFile, File serverKeyFile, final File serverCrtFile, String serverKeyPassword, File clientTrustCrtFile, File clientKeyFile, final File clientCrtFile, String clientKeyPassword) throws InterruptedException, SSLException {
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)serverCrtFile, (File)serverKeyFile, (String)serverKeyPassword).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(this.protocols()).ciphers(this.ciphers()).trustManager(servertTrustCrtFile).ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE).sessionCacheSize(0L).sessionTimeout(0L).build());
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(this.protocols()).ciphers(this.ciphers()).trustManager(clientTrustCrtFile).keyManager(clientCrtFile, clientKeyFile, clientKeyPassword).ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE).sessionCacheSize(0L).sessionTimeout(0L).build());
        this.serverConnectedChannel = null;
        this.sb = new ServerBootstrap();
        this.cb = new Bootstrap();
        this.sb.group((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup());
        this.sb.channel(NioServerSocketChannel.class);
        this.sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), SSLEngineTest.this.type));
                ChannelPipeline p = ch.pipeline();
                final SSLEngine engine = SSLEngineTest.this.wrapEngine(SSLEngineTest.this.serverSslCtx.newEngine(ch.alloc()));
                engine.setUseClientMode(false);
                engine.setNeedClientAuth(true);
                p.addLast(new ChannelHandler[]{new SslHandler(engine)});
                p.addLast(new ChannelHandler[]{new MessageDelegatorChannelHandler(SSLEngineTest.this.serverReceiver, SSLEngineTest.this.serverLatch)});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        if (cause.getCause() instanceof SSLHandshakeException) {
                            SSLEngineTest.this.serverException = cause.getCause();
                            SSLEngineTest.this.serverLatch.countDown();
                        } else {
                            SSLEngineTest.this.serverException = cause;
                            ctx.fireExceptionCaught(cause);
                        }
                    }

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt == SslHandshakeCompletionEvent.SUCCESS) {
                            try {
                                SSLEngineTest.this.verifySSLSessionForMutualAuth(engine.getSession(), serverCrtFile, SSLEngineTest.PRINCIPAL_NAME);
                            }
                            catch (Throwable cause) {
                                SSLEngineTest.this.serverException = cause;
                            }
                        }
                    }
                }});
                SSLEngineTest.this.serverConnectedChannel = ch;
            }
        });
        this.cb.group((EventLoopGroup)new NioEventLoopGroup());
        this.cb.channel(NioSocketChannel.class);
        this.cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), SSLEngineTest.this.type));
                final SslHandler handler = SSLEngineTest.this.delegatingExecutor == null ? SSLEngineTest.this.clientSslCtx.newHandler(ch.alloc()) : SSLEngineTest.this.clientSslCtx.newHandler(ch.alloc(), (Executor)SSLEngineTest.this.delegatingExecutor);
                handler.engine().setNeedClientAuth(true);
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{handler});
                p.addLast(new ChannelHandler[]{new MessageDelegatorChannelHandler(SSLEngineTest.this.clientReceiver, SSLEngineTest.this.clientLatch)});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt == SslHandshakeCompletionEvent.SUCCESS) {
                            try {
                                SSLEngineTest.this.verifySSLSessionForMutualAuth(handler.engine().getSession(), clientCrtFile, SSLEngineTest.PRINCIPAL_NAME);
                            }
                            catch (Throwable cause) {
                                SSLEngineTest.this.clientException = cause;
                            }
                        }
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        if (cause.getCause() instanceof SSLHandshakeException) {
                            SSLEngineTest.this.clientException = cause.getCause();
                            SSLEngineTest.this.clientLatch.countDown();
                        } else {
                            ctx.fireExceptionCaught(cause);
                        }
                    }
                }});
            }
        });
        this.serverChannel = this.sb.bind((SocketAddress)new InetSocketAddress(0)).sync().channel();
        int port = ((InetSocketAddress)this.serverChannel.localAddress()).getPort();
        ChannelFuture ccf = this.cb.connect((SocketAddress)new InetSocketAddress(NetUtil.LOCALHOST, port));
        Assert.assertTrue((boolean)ccf.awaitUninterruptibly().isSuccess());
        this.clientChannel = ccf.channel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest(String expectedApplicationProtocol) throws Exception {
        ByteBuf clientMessage = Unpooled.copiedBuffer((byte[])"I am a client".getBytes());
        ByteBuf serverMessage = Unpooled.copiedBuffer((byte[])"I am a server".getBytes());
        try {
            SSLEngineTest.writeAndVerifyReceived(clientMessage.retain(), this.clientChannel, this.serverLatch, this.serverReceiver);
            SSLEngineTest.writeAndVerifyReceived(serverMessage.retain(), this.serverConnectedChannel, this.clientLatch, this.clientReceiver);
            SSLEngineTest.verifyApplicationLevelProtocol(this.clientChannel, expectedApplicationProtocol);
            SSLEngineTest.verifyApplicationLevelProtocol(this.serverConnectedChannel, expectedApplicationProtocol);
        }
        finally {
            clientMessage.release();
            serverMessage.release();
        }
    }

    private static void verifyApplicationLevelProtocol(Channel channel, String expectedApplicationProtocol) {
        SslHandler handler = (SslHandler)channel.pipeline().get(SslHandler.class);
        Assert.assertNotNull((Object)handler);
        String appProto = handler.applicationProtocol();
        Assert.assertEquals((Object)expectedApplicationProtocol, (Object)appProto);
        SSLEngine engine = handler.engine();
        if (engine instanceof JdkAlpnSslEngine) {
            JdkAlpnSslEngine java9SslEngine = (JdkAlpnSslEngine)engine;
            Assert.assertEquals((Object)(expectedApplicationProtocol == null ? "" : expectedApplicationProtocol), (Object)java9SslEngine.getApplicationProtocol());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAndVerifyReceived(ByteBuf message, Channel sendChannel, CountDownLatch receiverLatch, MessageReceiver receiver) throws Exception {
        List dataCapture = null;
        try {
            Assert.assertTrue((boolean)sendChannel.writeAndFlush((Object)message).await(5L, TimeUnit.SECONDS));
            receiverLatch.await(5L, TimeUnit.SECONDS);
            message.resetReaderIndex();
            ArgumentCaptor captor = ArgumentCaptor.forClass(ByteBuf.class);
            ((MessageReceiver)Mockito.verify((Object)receiver)).messageReceived((ByteBuf)captor.capture());
            dataCapture = captor.getAllValues();
            Assert.assertEquals((Object)message, dataCapture.get(0));
        }
        finally {
            if (dataCapture != null) {
                for (ByteBuf data : dataCapture) {
                    data.release();
                }
            }
        }
    }

    @Test
    public void testGetCreationTime() throws Exception {
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).build());
        SSLEngine engine = null;
        try {
            engine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            Assert.assertTrue((engine.getSession().getCreationTime() <= System.currentTimeMillis() ? 1 : 0) != 0);
            this.cleanupClientSslEngine(engine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(engine);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessionInvalidate() throws Exception {
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(clientEngine, serverEngine);
            SSLSession session = serverEngine.getSession();
            Assert.assertTrue((boolean)session.isValid());
            session.invalidate();
            Assert.assertFalse((boolean)session.isValid());
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            ssc.delete();
            throw throwable;
        }
        ssc.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSSLSessionId() throws Exception {
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).protocols(new String[]{"TLSv1.2"}).sslContextProvider(this.clientSslContextProvider()).build());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).protocols(new String[]{"TLSv1.2"}).sslContextProvider(this.serverSslContextProvider()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            Assert.assertEquals((long)0L, (long)clientEngine.getSession().getId().length);
            Assert.assertEquals((long)0L, (long)serverEngine.getSession().getId().length);
            this.handshake(clientEngine, serverEngine);
            Assert.assertNotEquals((long)0L, (long)clientEngine.getSession().getId().length);
            Assert.assertNotEquals((long)0L, (long)serverEngine.getSession().getId().length);
            Assert.assertArrayEquals((byte[])clientEngine.getSession().getId(), (byte[])serverEngine.getSession().getId());
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            ssc.delete();
            throw throwable;
        }
        ssc.delete();
    }

    @Test(timeout=30000L)
    public void clientInitiatedRenegotiationWithFatalAlertDoesNotInfiniteLoopServer() throws CertificateException, SSLException, InterruptedException, ExecutionException {
        Assume.assumeTrue((PlatformDependent.javaVersion() >= 11 ? 1 : 0) != 0);
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        this.sb = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)new NioEventLoopGroup(1)).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), SSLEngineTest.this.type));
                ChannelPipeline p = ch.pipeline();
                SslHandler handler = SSLEngineTest.this.delegatingExecutor == null ? SSLEngineTest.this.serverSslCtx.newHandler(ch.alloc()) : SSLEngineTest.this.serverSslCtx.newHandler(ch.alloc(), (Executor)SSLEngineTest.this.delegatingExecutor);
                p.addLast(new ChannelHandler[]{handler});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                        if (evt instanceof SslHandshakeCompletionEvent && ((SslHandshakeCompletionEvent)evt).isSuccess()) {
                            ctx.writeAndFlush((Object)ctx.alloc().buffer(1).writeByte(100));
                        }
                        ctx.fireUserEventTriggered(evt);
                    }

                    public void channelRead(final ChannelHandlerContext ctx, Object msg) {
                        ReferenceCountUtil.release((Object)msg);
                        ctx.channel().eventLoop().schedule(new Runnable(){

                            @Override
                            public void run() {
                                ctx.writeAndFlush((Object)ctx.alloc().buffer(1).writeByte(101));
                            }
                        }, 500L, TimeUnit.MILLISECONDS);
                    }

                    public void channelInactive(ChannelHandlerContext ctx) {
                        SSLEngineTest.this.serverLatch.countDown();
                    }
                }});
                SSLEngineTest.this.serverConnectedChannel = ch;
            }
        });
        this.serverChannel = this.sb.bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().sslProvider(SslProvider.JDK).trustManager(InsecureTrustManagerFactory.INSTANCE).protocols(this.protocols()).ciphers(this.ciphers()).build());
        this.cb = new Bootstrap();
        ((Bootstrap)((Bootstrap)this.cb.group((EventLoopGroup)new NioEventLoopGroup(1))).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), SSLEngineTest.this.type));
                ChannelPipeline p = ch.pipeline();
                SslHandler sslHandler = SSLEngineTest.this.delegatingExecutor == null ? SSLEngineTest.this.clientSslCtx.newHandler(ch.alloc()) : SSLEngineTest.this.clientSslCtx.newHandler(ch.alloc(), (Executor)SSLEngineTest.this.delegatingExecutor);
                sslHandler.setHandshakeTimeout(1L, TimeUnit.SECONDS);
                p.addLast(new ChannelHandler[]{sslHandler});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
                    private int handshakeCount;

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                        if (evt instanceof SslHandshakeCompletionEvent && ++this.handshakeCount == 2) {
                            ctx.close();
                            return;
                        }
                        ctx.fireUserEventTriggered(evt);
                    }

                    public void channelRead(ChannelHandlerContext ctx, Object msg) {
                        ReferenceCountUtil.release((Object)msg);
                        ctx.writeAndFlush((Object)ctx.alloc().buffer(1).writeByte(102));
                        ((SslHandler)ctx.pipeline().get(SslHandler.class)).renegotiate();
                    }
                }});
            }
        });
        ChannelFuture ccf = this.cb.connect(this.serverChannel.localAddress());
        Assert.assertTrue((boolean)ccf.syncUninterruptibly().isSuccess());
        this.clientChannel = ccf.channel();
        this.serverLatch.await();
        ssc.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testEnablingAnAlreadyDisabledSslProtocol(String[] protocols1, String[] protocols2) throws Exception {
        SSLEngine sslEngine = null;
        try {
            File serverKeyFile = ResourcesUtil.getFile(this.getClass(), (String)"test_unencrypted.pem");
            File serverCrtFile = ResourcesUtil.getFile(this.getClass(), (String)"test.crt");
            this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)serverCrtFile, (File)serverKeyFile).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
            sslEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            sslEngine.setEnabledProtocols(EmptyArrays.EMPTY_STRINGS);
            Object[] enabledProtocols = sslEngine.getEnabledProtocols();
            Assert.assertArrayEquals((Object[])protocols1, (Object[])enabledProtocols);
            sslEngine.setEnabledProtocols(new String[]{"TLSv1.2"});
            enabledProtocols = sslEngine.getEnabledProtocols();
            Assert.assertEquals((long)protocols2.length, (long)enabledProtocols.length);
            Assert.assertArrayEquals((Object[])protocols2, (Object[])enabledProtocols);
        }
        finally {
            if (sslEngine != null) {
                sslEngine.closeInbound();
                sslEngine.closeOutbound();
                this.cleanupServerSslEngine(sslEngine);
            }
        }
    }

    protected void handshake(SSLEngine clientEngine, SSLEngine serverEngine) throws Exception {
        boolean sTOcHasRemaining;
        boolean cTOsHasRemaining;
        ByteBuffer cTOs = this.allocateBuffer(clientEngine.getSession().getPacketBufferSize());
        ByteBuffer sTOc = this.allocateBuffer(serverEngine.getSession().getPacketBufferSize());
        ByteBuffer serverAppReadBuffer = this.allocateBuffer(serverEngine.getSession().getApplicationBufferSize());
        ByteBuffer clientAppReadBuffer = this.allocateBuffer(clientEngine.getSession().getApplicationBufferSize());
        clientEngine.beginHandshake();
        serverEngine.beginHandshake();
        ByteBuffer empty = this.allocateBuffer(0);
        boolean clientHandshakeFinished = false;
        boolean serverHandshakeFinished = false;
        do {
            SSLEngineResult serverResult;
            SSLEngineResult clientResult;
            int cTOsPos = cTOs.position();
            int sTOcPos = sTOc.position();
            if (!clientHandshakeFinished) {
                clientResult = clientEngine.wrap(empty, cTOs);
                this.runDelegatedTasks(clientResult, clientEngine);
                Assert.assertEquals((long)empty.remaining(), (long)clientResult.bytesConsumed());
                Assert.assertEquals((long)(cTOs.position() - cTOsPos), (long)clientResult.bytesProduced());
                if (SSLEngineTest.isHandshakeFinished(clientResult)) {
                    clientHandshakeFinished = true;
                }
            }
            if (!serverHandshakeFinished) {
                serverResult = serverEngine.wrap(empty, sTOc);
                this.runDelegatedTasks(serverResult, serverEngine);
                Assert.assertEquals((long)empty.remaining(), (long)serverResult.bytesConsumed());
                Assert.assertEquals((long)(sTOc.position() - sTOcPos), (long)serverResult.bytesProduced());
                if (SSLEngineTest.isHandshakeFinished(serverResult)) {
                    serverHandshakeFinished = true;
                }
            }
            cTOs.flip();
            sTOc.flip();
            cTOsPos = cTOs.position();
            sTOcPos = sTOc.position();
            if (!clientHandshakeFinished || "TLSv1.3".equals(clientEngine.getSession().getProtocol())) {
                int clientAppReadBufferPos = clientAppReadBuffer.position();
                clientResult = clientEngine.unwrap(sTOc, clientAppReadBuffer);
                this.runDelegatedTasks(clientResult, clientEngine);
                Assert.assertEquals((long)(sTOc.position() - sTOcPos), (long)clientResult.bytesConsumed());
                Assert.assertEquals((long)(clientAppReadBuffer.position() - clientAppReadBufferPos), (long)clientResult.bytesProduced());
                if (SSLEngineTest.isHandshakeFinished(clientResult)) {
                    clientHandshakeFinished = true;
                }
            } else {
                Assert.assertEquals((long)0L, (long)sTOc.remaining());
            }
            if (!serverHandshakeFinished) {
                int serverAppReadBufferPos = serverAppReadBuffer.position();
                serverResult = serverEngine.unwrap(cTOs, serverAppReadBuffer);
                this.runDelegatedTasks(serverResult, serverEngine);
                Assert.assertEquals((long)(cTOs.position() - cTOsPos), (long)serverResult.bytesConsumed());
                Assert.assertEquals((long)(serverAppReadBuffer.position() - serverAppReadBufferPos), (long)serverResult.bytesProduced());
                if (SSLEngineTest.isHandshakeFinished(serverResult)) {
                    serverHandshakeFinished = true;
                }
            } else {
                Assert.assertFalse((boolean)cTOs.hasRemaining());
            }
            cTOsHasRemaining = cTOs.hasRemaining();
            sTOcHasRemaining = sTOc.hasRemaining();
            sTOc.compact();
            cTOs.compact();
        } while (!clientHandshakeFinished || !serverHandshakeFinished || cTOsHasRemaining || sTOcHasRemaining);
    }

    private static boolean isHandshakeFinished(SSLEngineResult result) {
        return result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED;
    }

    private void runDelegatedTasks(SSLEngineResult result, SSLEngine engine) throws Exception {
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            Runnable task;
            while ((task = engine.getDelegatedTask()) != null) {
                if (this.delegatingExecutor == null) {
                    task.run();
                    continue;
                }
                this.delegatingExecutor.submit(task).get();
            }
        }
    }

    protected abstract SslProvider sslClientProvider();

    protected abstract SslProvider sslServerProvider();

    protected Provider clientSslContextProvider() {
        return null;
    }

    protected Provider serverSslContextProvider() {
        return null;
    }

    protected void cleanupClientSslContext(SslContext ctx) {
    }

    protected void cleanupServerSslContext(SslContext ctx) {
    }

    protected void cleanupClientSslEngine(SSLEngine engine) {
    }

    protected void cleanupServerSslEngine(SSLEngine engine) {
    }

    protected void setupHandlers(ApplicationProtocolConfig apn) throws InterruptedException, SSLException, CertificateException {
        this.setupHandlers(apn, apn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupHandlers(ApplicationProtocolConfig serverApn, ApplicationProtocolConfig clientApn) throws InterruptedException, SSLException, CertificateException {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        try {
            SslContextBuilder serverCtxBuilder = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey(), null).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE).applicationProtocolConfig(serverApn).sessionCacheSize(0L).sessionTimeout(0L);
            if (serverApn.protocol() == ApplicationProtocolConfig.Protocol.NPN || serverApn.protocol() == ApplicationProtocolConfig.Protocol.NPN_AND_ALPN) {
                serverCtxBuilder.protocols(new String[]{"TLSv1.2"});
            }
            SslContextBuilder clientCtxBuilder = SslContextBuilder.forClient().sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).applicationProtocolConfig(clientApn).trustManager(InsecureTrustManagerFactory.INSTANCE).ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE).sessionCacheSize(0L).sessionTimeout(0L);
            if (clientApn.protocol() == ApplicationProtocolConfig.Protocol.NPN || clientApn.protocol() == ApplicationProtocolConfig.Protocol.NPN_AND_ALPN) {
                clientCtxBuilder.protocols(new String[]{"TLSv1.2"});
            }
            this.setupHandlers(this.wrapContext(serverCtxBuilder.build()), this.wrapContext(clientCtxBuilder.build()));
        }
        finally {
            ssc.delete();
        }
    }

    protected void setupHandlers(SslContext serverCtx, SslContext clientCtx) throws InterruptedException, SSLException, CertificateException {
        this.serverSslCtx = serverCtx;
        this.clientSslCtx = clientCtx;
        this.serverConnectedChannel = null;
        this.sb = new ServerBootstrap();
        this.cb = new Bootstrap();
        this.sb.group((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup());
        this.sb.channel(NioServerSocketChannel.class);
        this.sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), SSLEngineTest.this.type));
                ChannelPipeline p = ch.pipeline();
                SslHandler sslHandler = SSLEngineTest.this.delegatingExecutor == null ? SSLEngineTest.this.serverSslCtx.newHandler(ch.alloc()) : SSLEngineTest.this.serverSslCtx.newHandler(ch.alloc(), (Executor)SSLEngineTest.this.delegatingExecutor);
                p.addLast(new ChannelHandler[]{sslHandler});
                p.addLast(new ChannelHandler[]{new MessageDelegatorChannelHandler(SSLEngineTest.this.serverReceiver, SSLEngineTest.this.serverLatch)});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        if (cause.getCause() instanceof SSLHandshakeException) {
                            SSLEngineTest.this.serverException = cause.getCause();
                            SSLEngineTest.this.serverLatch.countDown();
                        } else {
                            ctx.fireExceptionCaught(cause);
                        }
                    }
                }});
                SSLEngineTest.this.serverConnectedChannel = ch;
            }
        });
        this.cb.group((EventLoopGroup)new NioEventLoopGroup());
        this.cb.channel(NioSocketChannel.class);
        this.cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), SSLEngineTest.this.type));
                ChannelPipeline p = ch.pipeline();
                SslHandler sslHandler = SSLEngineTest.this.delegatingExecutor == null ? SSLEngineTest.this.clientSslCtx.newHandler(ch.alloc()) : SSLEngineTest.this.clientSslCtx.newHandler(ch.alloc(), (Executor)SSLEngineTest.this.delegatingExecutor);
                p.addLast(new ChannelHandler[]{sslHandler});
                p.addLast(new ChannelHandler[]{new MessageDelegatorChannelHandler(SSLEngineTest.this.clientReceiver, SSLEngineTest.this.clientLatch)});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        if (cause.getCause() instanceof SSLHandshakeException) {
                            SSLEngineTest.this.clientException = cause.getCause();
                            SSLEngineTest.this.clientLatch.countDown();
                        } else {
                            ctx.fireExceptionCaught(cause);
                        }
                    }

                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        SSLEngineTest.this.clientLatch.countDown();
                    }
                }});
            }
        });
        this.serverChannel = this.sb.bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
        ChannelFuture ccf = this.cb.connect(this.serverChannel.localAddress());
        Assert.assertTrue((boolean)ccf.syncUninterruptibly().isSuccess());
        this.clientChannel = ccf.channel();
    }

    @Test(timeout=30000L)
    public void testMutualAuthSameCertChain() throws Exception {
        SelfSignedCertificate serverCert = new SelfSignedCertificate();
        SelfSignedCertificate clientCert = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)serverCert.certificate(), (File)serverCert.privateKey()).trustManager(new X509Certificate[]{clientCert.cert()}).clientAuth(ClientAuth.REQUIRE).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        this.sb = new ServerBootstrap();
        this.sb.group((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup());
        this.sb.channel(NioServerSocketChannel.class);
        final Promise promise = this.sb.config().group().next().newPromise();
        this.serverChannel = this.sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), SSLEngineTest.this.type));
                SslHandler sslHandler = SSLEngineTest.this.delegatingExecutor == null ? SSLEngineTest.this.serverSslCtx.newHandler(ch.alloc()) : SSLEngineTest.this.serverSslCtx.newHandler(ch.alloc(), (Executor)SSLEngineTest.this.delegatingExecutor);
                ch.pipeline().addFirst(new ChannelHandler[]{sslHandler});
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        block10: {
                            if (evt instanceof SslHandshakeCompletionEvent) {
                                Throwable cause = ((SslHandshakeCompletionEvent)evt).cause();
                                if (cause == null) {
                                    SSLSession session = ((SslHandler)ctx.pipeline().first()).engine().getSession();
                                    Certificate[] peerCertificates = session.getPeerCertificates();
                                    if (peerCertificates == null) {
                                        promise.setFailure((Throwable)new NullPointerException("peerCertificates"));
                                        return;
                                    }
                                    try {
                                        javax.security.cert.X509Certificate[] peerCertificateChain = session.getPeerCertificateChain();
                                        if (peerCertificateChain == null) {
                                            promise.setFailure((Throwable)new NullPointerException("peerCertificateChain"));
                                            break block10;
                                        }
                                        if (peerCertificateChain.length + peerCertificates.length != 4) {
                                            String excTxtFmt = "peerCertificateChain.length:%s, peerCertificates.length:%s";
                                            promise.setFailure((Throwable)new IllegalStateException(String.format(excTxtFmt, peerCertificateChain.length, peerCertificates.length)));
                                            break block10;
                                        }
                                        for (int i = 0; i < peerCertificateChain.length; ++i) {
                                            if (peerCertificateChain[i] != null && peerCertificates[i] != null) continue;
                                            promise.setFailure((Throwable)new IllegalStateException("Certificate in chain is null"));
                                            return;
                                        }
                                        promise.setSuccess(null);
                                    }
                                    catch (UnsupportedOperationException e) {
                                        Assert.assertTrue((PlatformDependent.javaVersion() >= 15 ? 1 : 0) != 0);
                                        Assert.assertEquals((long)2L, (long)peerCertificates.length);
                                        for (int i = 0; i < peerCertificates.length; ++i) {
                                            if (peerCertificates[i] != null) continue;
                                            promise.setFailure((Throwable)new IllegalStateException("Certificate in chain is null"));
                                            return;
                                        }
                                        promise.setSuccess(null);
                                    }
                                } else {
                                    promise.setFailure(cause);
                                }
                            }
                        }
                    }
                }});
                SSLEngineTest.this.serverConnectedChannel = ch;
            }
        }).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
        ByteArrayOutputStream chainStream = new ByteArrayOutputStream();
        chainStream.write(Files.readAllBytes(clientCert.certificate().toPath()));
        chainStream.write(Files.readAllBytes(serverCert.certificate().toPath()));
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().keyManager((InputStream)new ByteArrayInputStream(chainStream.toByteArray()), (InputStream)new FileInputStream(clientCert.privateKey())).trustManager((InputStream)new FileInputStream(serverCert.certificate())).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        this.cb = new Bootstrap();
        this.cb.group((EventLoopGroup)new NioEventLoopGroup());
        this.cb.channel(NioSocketChannel.class);
        this.clientChannel = ((Bootstrap)this.cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), SSLEngineTest.this.type));
                ch.pipeline().addLast(new ChannelHandler[]{new SslHandler(SSLEngineTest.this.wrapEngine(SSLEngineTest.this.clientSslCtx.newEngine(ch.alloc())))});
            }
        })).connect(this.serverChannel.localAddress()).syncUninterruptibly().channel();
        promise.syncUninterruptibly();
        serverCert.delete();
        clientCert.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnwrapBehavior() throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslProvider(this.sslClientProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslProvider(this.sslServerProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        byte[] bytes = "Hello World".getBytes(CharsetUtil.US_ASCII);
        try {
            ByteBuffer plainClientOut = this.allocateBuffer(client.getSession().getApplicationBufferSize());
            ByteBuffer encryptedClientToServer = this.allocateBuffer(server.getSession().getPacketBufferSize() * 2);
            ByteBuffer plainServerIn = this.allocateBuffer(server.getSession().getApplicationBufferSize());
            this.handshake(client, server);
            plainClientOut.put(bytes, 0, 5);
            plainClientOut.flip();
            SSLEngineResult result = client.wrap(plainClientOut, encryptedClientToServer);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)5L, (long)result.bytesConsumed());
            Assert.assertTrue((result.bytesProduced() > 0 ? 1 : 0) != 0);
            Assert.assertFalse((boolean)plainClientOut.hasRemaining());
            plainClientOut.clear();
            plainClientOut.put(bytes, 5, 6);
            plainClientOut.flip();
            result = client.wrap(plainClientOut, encryptedClientToServer);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)6L, (long)result.bytesConsumed());
            Assert.assertTrue((result.bytesProduced() > 0 ? 1 : 0) != 0);
            encryptedClientToServer.flip();
            int remaining = encryptedClientToServer.remaining();
            ByteBuffer small = this.allocateBuffer(3);
            result = server.unwrap(encryptedClientToServer, small);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)remaining, (long)encryptedClientToServer.remaining());
            result = server.unwrap(encryptedClientToServer, plainServerIn);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)5L, (long)result.bytesProduced());
            Assert.assertTrue((boolean)encryptedClientToServer.hasRemaining());
            result = server.unwrap(encryptedClientToServer, plainServerIn);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)6L, (long)result.bytesProduced());
            Assert.assertFalse((boolean)encryptedClientToServer.hasRemaining());
            plainServerIn.flip();
            Assert.assertEquals((Object)ByteBuffer.wrap(bytes), (Object)plainServerIn);
        }
        finally {
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
            cert.delete();
        }
    }

    @Test
    public void testProtocolMatch() throws Exception {
        this.testProtocol(new String[]{"TLSv1.2"}, new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"});
    }

    @Test(expected=SSLHandshakeException.class)
    public void testProtocolNoMatch() throws Exception {
        this.testProtocol(new String[]{"TLSv1.2"}, new String[]{"TLSv1", "TLSv1.1"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testProtocol(String[] clientProtocols, String[] serverProtocols) throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslProvider(this.sslClientProvider()).protocols(clientProtocols).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslProvider(this.sslServerProvider()).protocols(serverProtocols).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            this.handshake(client, server);
        }
        finally {
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
            cert.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHandshakeCompletesWithNonContiguousProtocolsTLSv1_2CipherOnly() throws Exception {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        String sharedCipher = "TLS_RSA_WITH_AES_128_CBC_SHA";
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).ciphers(Collections.singletonList("TLS_RSA_WITH_AES_128_CBC_SHA")).protocols(new String[]{"TLSv1.2", "TLSv1"}).sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).build());
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).ciphers(Collections.singletonList("TLS_RSA_WITH_AES_128_CBC_SHA")).protocols(new String[]{"TLSv1.2", "TLSv1"}).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(clientEngine, serverEngine);
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            ssc.delete();
            throw throwable;
        }
        ssc.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHandshakeCompletesWithoutFilteringSupportedCipher() throws Exception {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        String sharedCipher = "TLS_RSA_WITH_AES_128_CBC_SHA";
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).ciphers(Collections.singletonList("TLS_RSA_WITH_AES_128_CBC_SHA"), (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).protocols(new String[]{"TLSv1.2", "TLSv1"}).sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).build());
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).ciphers(Collections.singletonList("TLS_RSA_WITH_AES_128_CBC_SHA"), (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).protocols(new String[]{"TLSv1.2", "TLSv1"}).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(clientEngine, serverEngine);
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            ssc.delete();
            throw throwable;
        }
        ssc.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPacketBufferSizeLimit() throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            ByteBuffer plainServerOut = this.allocateBuffer(server.getSession().getApplicationBufferSize() * 2);
            this.handshake(client, server);
            plainServerOut.position(plainServerOut.capacity());
            plainServerOut.flip();
            ByteBuffer encryptedServerToClient = this.allocateBuffer(server.getSession().getPacketBufferSize());
            int encryptedServerToClientPos = encryptedServerToClient.position();
            int plainServerOutPos = plainServerOut.position();
            SSLEngineResult result = server.wrap(plainServerOut, encryptedServerToClient);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)(plainServerOut.position() - plainServerOutPos), (long)result.bytesConsumed());
            Assert.assertEquals((long)(encryptedServerToClient.position() - encryptedServerToClientPos), (long)result.bytesProduced());
        }
        finally {
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
            cert.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSSLEngineUnwrapNoSslRecord() throws Exception {
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            ByteBuffer src = this.allocateBuffer(client.getSession().getApplicationBufferSize());
            ByteBuffer dst = this.allocateBuffer(client.getSession().getPacketBufferSize());
            ByteBuffer empty = this.allocateBuffer(0);
            SSLEngineResult clientResult = client.wrap(empty, dst);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)clientResult.getStatus()));
            Assert.assertEquals((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_UNWRAP), (Object)((Object)clientResult.getHandshakeStatus()));
            try {
                client.unwrap(src, dst);
                Assert.fail();
            }
            catch (SSLException sSLException) {
                // empty catch block
            }
        }
        finally {
            this.cleanupClientSslEngine(client);
        }
    }

    @Test
    public void testBeginHandshakeAfterEngineClosed() throws SSLException {
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            client.closeInbound();
            client.closeOutbound();
            try {
                client.beginHandshake();
                Assert.fail();
            }
            catch (SSLException sSLException) {
            }
            catch (IllegalStateException e) {
                if (!Conscrypt.isEngineSupported((SSLEngine)client)) {
                    throw e;
                }
            }
        }
        finally {
            this.cleanupClientSslEngine(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBeginHandshakeCloseOutbound() throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            this.testBeginHandshakeCloseOutbound(client);
            this.testBeginHandshakeCloseOutbound(server);
        }
        finally {
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
            cert.delete();
        }
    }

    private void testBeginHandshakeCloseOutbound(SSLEngine engine) throws SSLException {
        SSLEngineResult result;
        ByteBuffer dst = this.allocateBuffer(engine.getSession().getPacketBufferSize());
        ByteBuffer empty = this.allocateBuffer(0);
        engine.beginHandshake();
        engine.closeOutbound();
        while (true) {
            result = engine.wrap(empty, dst);
            dst.flip();
            Assert.assertEquals((long)0L, (long)result.bytesConsumed());
            Assert.assertEquals((long)dst.remaining(), (long)result.bytesProduced());
            if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_WRAP) break;
            dst.clear();
        }
        Assert.assertEquals((Object)((Object)SSLEngineResult.Status.CLOSED), (Object)((Object)result.getStatus()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseInboundAfterBeginHandshake() throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            SSLEngineTest.testCloseInboundAfterBeginHandshake(client);
            SSLEngineTest.testCloseInboundAfterBeginHandshake(server);
        }
        finally {
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
            cert.delete();
        }
    }

    private static void testCloseInboundAfterBeginHandshake(SSLEngine engine) throws SSLException {
        engine.beginHandshake();
        try {
            engine.closeInbound();
            if (!Conscrypt.isEngineSupported((SSLEngine)engine)) {
                Assert.fail();
            }
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseNotifySequence() throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).protocols(new String[]{"TLSv1.2"}).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).protocols(new String[]{"TLSv1.2"}).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            ByteBuffer plainClientOut = this.allocateBuffer(client.getSession().getApplicationBufferSize());
            ByteBuffer plainServerOut = this.allocateBuffer(server.getSession().getApplicationBufferSize());
            ByteBuffer encryptedClientToServer = this.allocateBuffer(client.getSession().getPacketBufferSize());
            ByteBuffer encryptedServerToClient = this.allocateBuffer(server.getSession().getPacketBufferSize());
            ByteBuffer empty = this.allocateBuffer(0);
            this.handshake(client, server);
            client.closeOutbound();
            Assert.assertFalse((boolean)client.isOutboundDone());
            Assert.assertFalse((boolean)client.isInboundDone());
            SSLEngineResult result = client.wrap(empty, encryptedClientToServer);
            encryptedClientToServer.flip();
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.CLOSED), (Object)((Object)result.getStatus()));
            SSLEngineResult.HandshakeStatus hs = result.getHandshakeStatus();
            if (this.sslClientProvider() == SslProvider.JDK || Conscrypt.isEngineSupported((SSLEngine)client)) {
                Assert.assertTrue((hs == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || hs == SSLEngineResult.HandshakeStatus.NEED_UNWRAP ? 1 : 0) != 0);
            } else {
                Assert.assertEquals((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_UNWRAP), (Object)((Object)hs));
            }
            int produced = result.bytesProduced();
            int consumed = result.bytesConsumed();
            int closeNotifyLen = produced;
            Assert.assertTrue((produced > 0 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)consumed);
            Assert.assertEquals((long)produced, (long)encryptedClientToServer.remaining());
            Assert.assertTrue((boolean)client.isOutboundDone());
            Assert.assertFalse((boolean)client.isInboundDone());
            Assert.assertFalse((boolean)server.isOutboundDone());
            Assert.assertFalse((boolean)server.isInboundDone());
            result = server.unwrap(encryptedClientToServer, plainServerOut);
            plainServerOut.flip();
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.CLOSED), (Object)((Object)result.getStatus()));
            Assert.assertEquals((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_WRAP), (Object)((Object)result.getHandshakeStatus()));
            produced = result.bytesProduced();
            consumed = result.bytesConsumed();
            Assert.assertEquals((long)closeNotifyLen, (long)consumed);
            Assert.assertEquals((long)0L, (long)produced);
            Assert.assertEquals((long)0L, (long)encryptedClientToServer.remaining());
            Assert.assertEquals((long)0L, (long)plainServerOut.remaining());
            Assert.assertFalse((boolean)server.isOutboundDone());
            Assert.assertTrue((boolean)server.isInboundDone());
            result = server.wrap(empty, encryptedServerToClient);
            encryptedServerToClient.flip();
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.CLOSED), (Object)((Object)result.getStatus()));
            Assert.assertEquals((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING), (Object)((Object)result.getHandshakeStatus()));
            produced = result.bytesProduced();
            consumed = result.bytesConsumed();
            Assert.assertEquals((long)closeNotifyLen, (long)produced);
            Assert.assertEquals((long)0L, (long)consumed);
            Assert.assertEquals((long)produced, (long)encryptedServerToClient.remaining());
            Assert.assertTrue((boolean)server.isOutboundDone());
            Assert.assertTrue((boolean)server.isInboundDone());
            result = client.unwrap(encryptedServerToClient, plainClientOut);
            plainClientOut.flip();
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.CLOSED), (Object)((Object)result.getStatus()));
            Assert.assertEquals((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING), (Object)((Object)result.getHandshakeStatus()));
            produced = result.bytesProduced();
            consumed = result.bytesConsumed();
            Assert.assertEquals((long)closeNotifyLen, (long)consumed);
            Assert.assertEquals((long)0L, (long)produced);
            Assert.assertEquals((long)0L, (long)encryptedServerToClient.remaining());
            Assert.assertTrue((boolean)client.isOutboundDone());
            Assert.assertTrue((boolean)client.isInboundDone());
            encryptedServerToClient.clear();
            plainServerOut.clear();
            result = server.wrap(plainServerOut, encryptedServerToClient);
            SSLEngineTest.assertEngineRemainsClosed(result);
            encryptedClientToServer.clear();
            plainServerOut.clear();
            result = server.unwrap(encryptedClientToServer, plainServerOut);
            SSLEngineTest.assertEngineRemainsClosed(result);
            encryptedClientToServer.clear();
            plainClientOut.clear();
            result = client.wrap(plainClientOut, encryptedClientToServer);
            SSLEngineTest.assertEngineRemainsClosed(result);
            encryptedServerToClient.clear();
            plainClientOut.clear();
            result = client.unwrap(encryptedServerToClient, plainClientOut);
            SSLEngineTest.assertEngineRemainsClosed(result);
        }
        finally {
            cert.delete();
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    private static void assertEngineRemainsClosed(SSLEngineResult result) {
        Assert.assertEquals((Object)((Object)SSLEngineResult.Status.CLOSED), (Object)((Object)result.getStatus()));
        Assert.assertEquals((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING), (Object)((Object)result.getHandshakeStatus()));
        Assert.assertEquals((long)0L, (long)result.bytesConsumed());
        Assert.assertEquals((long)0L, (long)result.bytesProduced());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWrapAfterCloseOutbound() throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            ByteBuffer dst = this.allocateBuffer(client.getSession().getPacketBufferSize());
            ByteBuffer src = this.allocateBuffer(1024);
            this.handshake(client, server);
            client.closeOutbound();
            SSLEngineResult result = client.wrap(src, dst);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.CLOSED), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)0L, (long)result.bytesConsumed());
            Assert.assertTrue((result.bytesProduced() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)client.isOutboundDone());
            Assert.assertFalse((boolean)client.isInboundDone());
        }
        finally {
            cert.delete();
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleRecordsInOneBufferWithNonZeroPosition() throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            ByteBuffer plainClientOut = this.allocateBuffer(1024);
            ByteBuffer plainServerOut = this.allocateBuffer(server.getSession().getApplicationBufferSize());
            ByteBuffer encClientToServer = this.allocateBuffer(client.getSession().getPacketBufferSize());
            int positionOffset = 1;
            ByteBuffer combinedEncClientToServer = this.allocateBuffer(encClientToServer.capacity() * 2 + positionOffset);
            combinedEncClientToServer.position(positionOffset);
            this.handshake(client, server);
            plainClientOut.limit(plainClientOut.capacity());
            SSLEngineResult result = client.wrap(plainClientOut, encClientToServer);
            Assert.assertEquals((long)plainClientOut.capacity(), (long)result.bytesConsumed());
            Assert.assertTrue((result.bytesProduced() > 0 ? 1 : 0) != 0);
            encClientToServer.flip();
            combinedEncClientToServer.put(encClientToServer);
            plainClientOut.clear();
            encClientToServer.clear();
            result = client.wrap(plainClientOut, encClientToServer);
            Assert.assertEquals((long)plainClientOut.capacity(), (long)result.bytesConsumed());
            Assert.assertTrue((result.bytesProduced() > 0 ? 1 : 0) != 0);
            encClientToServer.flip();
            int encClientToServerLen = encClientToServer.remaining();
            combinedEncClientToServer.put(encClientToServer);
            encClientToServer.clear();
            combinedEncClientToServer.flip();
            combinedEncClientToServer.position(positionOffset);
            combinedEncClientToServer.limit(combinedEncClientToServer.limit() - (encClientToServerLen - positionOffset));
            result = server.unwrap(combinedEncClientToServer, plainServerOut);
            Assert.assertEquals((long)encClientToServerLen, (long)result.bytesConsumed());
            Assert.assertTrue((result.bytesProduced() > 0 ? 1 : 0) != 0);
        }
        finally {
            cert.delete();
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleRecordsInOneBufferBiggerThenPacketBufferSize() throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            SSLEngineResult result;
            ByteBuffer plainClientOut = this.allocateBuffer(4096);
            ByteBuffer plainServerOut = this.allocateBuffer(server.getSession().getApplicationBufferSize());
            ByteBuffer encClientToServer = this.allocateBuffer(server.getSession().getPacketBufferSize() * 2);
            this.handshake(client, server);
            int srcLen = plainClientOut.remaining();
            int count = 0;
            do {
                int plainClientOutPosition = plainClientOut.position();
                int encClientToServerPosition = encClientToServer.position();
                result = client.wrap(plainClientOut, encClientToServer);
                if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    Assert.assertEquals((long)plainClientOutPosition, (long)plainClientOut.position());
                    Assert.assertEquals((long)encClientToServerPosition, (long)encClientToServer.position());
                    break;
                }
                Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
                Assert.assertEquals((long)srcLen, (long)result.bytesConsumed());
                Assert.assertTrue((result.bytesProduced() > 0 ? 1 : 0) != 0);
                plainClientOut.clear();
                ++count;
            } while (encClientToServer.position() < server.getSession().getPacketBufferSize());
            Assert.assertTrue((count >= 2 ? 1 : 0) != 0);
            encClientToServer.flip();
            result = server.unwrap(encClientToServer, plainServerOut);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assert.assertTrue((result.bytesConsumed() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((result.bytesProduced() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)encClientToServer.hasRemaining());
        }
        finally {
            cert.delete();
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBufferUnderFlow() throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            ByteBuffer plainClient = this.allocateBuffer(1024);
            plainClient.limit(plainClient.capacity());
            ByteBuffer encClientToServer = this.allocateBuffer(client.getSession().getPacketBufferSize());
            ByteBuffer plainServer = this.allocateBuffer(server.getSession().getApplicationBufferSize());
            this.handshake(client, server);
            SSLEngineResult result = client.wrap(plainClient, encClientToServer);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)result.bytesConsumed(), (long)plainClient.capacity());
            encClientToServer.flip();
            int remaining = encClientToServer.remaining();
            encClientToServer.limit(4);
            result = server.unwrap(encClientToServer, plainServer);
            SSLEngineTest.assertResultIsBufferUnderflow(result);
            encClientToServer.limit(5);
            result = server.unwrap(encClientToServer, plainServer);
            SSLEngineTest.assertResultIsBufferUnderflow(result);
            encClientToServer.limit(5 + remaining - 1 - 5);
            result = server.unwrap(encClientToServer, plainServer);
            SSLEngineTest.assertResultIsBufferUnderflow(result);
            encClientToServer.limit(remaining);
            result = server.unwrap(encClientToServer, plainServer);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)result.bytesConsumed(), (long)remaining);
            Assert.assertTrue((result.bytesProduced() > 0 ? 1 : 0) != 0);
        }
        finally {
            cert.delete();
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    private static void assertResultIsBufferUnderflow(SSLEngineResult result) {
        Assert.assertEquals((Object)((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW), (Object)((Object)result.getStatus()));
        Assert.assertEquals((long)0L, (long)result.bytesConsumed());
        Assert.assertEquals((long)0L, (long)result.bytesProduced());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWrapDoesNotZeroOutSrc() throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            ByteBuffer plainServerOut = this.allocateBuffer(server.getSession().getApplicationBufferSize() / 2);
            this.handshake(client, server);
            for (int i = 0; i < plainServerOut.capacity(); ++i) {
                plainServerOut.put(i, (byte)i);
            }
            plainServerOut.position(plainServerOut.capacity());
            plainServerOut.flip();
            ByteBuffer encryptedServerToClient = this.allocateBuffer(server.getSession().getPacketBufferSize());
            SSLEngineResult result = server.wrap(plainServerOut, encryptedServerToClient);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assert.assertTrue((result.bytesConsumed() > 0 ? 1 : 0) != 0);
            for (int i = 0; i < plainServerOut.capacity(); ++i) {
                Assert.assertEquals((long)((byte)i), (long)plainServerOut.get(i));
            }
        }
        finally {
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
            cert.delete();
        }
    }

    @Test
    public void testDisableProtocols() throws Exception {
        this.testDisableProtocols("SSLv2", "SSLv2");
        this.testDisableProtocols("SSLv3", "SSLv2", "SSLv3");
        this.testDisableProtocols("TLSv1", "SSLv2", "SSLv3", "TLSv1");
        this.testDisableProtocols("TLSv1.1", "SSLv2", "SSLv3", "TLSv1", "TLSv1.1");
        this.testDisableProtocols("TLSv1.2", "SSLv2", "SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDisableProtocols(String protocol, String ... disabledProtocols) throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        SslContext ctx = this.wrapContext(SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine server = this.wrapEngine(ctx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            HashSet<String> supported = new HashSet<String>(Arrays.asList(server.getSupportedProtocols()));
            if (supported.contains(protocol)) {
                server.setEnabledProtocols(server.getSupportedProtocols());
                Assert.assertEquals(supported, new HashSet<String>(Arrays.asList(server.getSupportedProtocols())));
                for (String disabled : disabledProtocols) {
                    supported.remove(disabled);
                }
                if (supported.contains("SSLv2Hello") && supported.size() == 1) {
                    return;
                }
                server.setEnabledProtocols(supported.toArray(new String[0]));
                Assert.assertEquals(supported, new HashSet<String>(Arrays.asList(server.getEnabledProtocols())));
                server.setEnabledProtocols(server.getSupportedProtocols());
            }
        }
        finally {
            this.cleanupServerSslEngine(server);
            this.cleanupClientSslContext(ctx);
            cert.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUsingX509TrustManagerVerifiesHostname() throws Exception {
        if (this.clientSslContextProvider() != null) {
            return;
        }
        SelfSignedCertificate cert = new SelfSignedCertificate();
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(new TrustManagerFactory(new TrustManagerFactorySpi(){

            @Override
            protected void engineInit(KeyStore keyStore) {
            }

            @Override
            protected TrustManager[] engineGetTrustManagers() {
                return new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return EmptyArrays.EMPTY_X509_CERTIFICATES;
                    }
                }};
            }

            @Override
            protected void engineInit(ManagerFactoryParameters managerFactoryParameters) {
            }
        }, null, TrustManagerFactory.getDefaultAlgorithm()){}).sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, "netty.io", 1234));
        SSLParameters sslParameters = client.getSSLParameters();
        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        client.setSSLParameters(sslParameters);
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            this.handshake(client, server);
            Assert.fail();
        }
        catch (SSLException sSLException) {
        }
        finally {
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
            cert.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Test
    public void testInvalidCipher() throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        ArrayList<String> cipherList = new ArrayList<String>();
        Collections.addAll(cipherList, ((SSLSocketFactory)SSLSocketFactory.getDefault()).getDefaultCipherSuites());
        cipherList.add("InvalidCipher");
        SSLEngine server = null;
        try {
            this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).ciphers(cipherList).build());
            server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            cert.delete();
            this.cleanupServerSslEngine(server);
        }
        catch (SSLException sSLException) {
            cert.delete();
            this.cleanupServerSslEngine(server);
            {
                catch (Throwable throwable) {
                    cert.delete();
                    this.cleanupServerSslEngine(server);
                    throw throwable;
                }
            }
        }
        cert.delete();
        this.cleanupServerSslEngine(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetCiphersuite() throws Exception {
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(clientEngine, serverEngine);
            String clientCipher = clientEngine.getSession().getCipherSuite();
            String serverCipher = serverEngine.getSession().getCipherSuite();
            Assert.assertEquals((Object)clientCipher, (Object)serverCipher);
            Assert.assertEquals((Object)this.protocolCipherCombo.cipher, (Object)clientCipher);
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            ssc.delete();
            throw throwable;
        }
        ssc.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSessionBindingEvent() throws Exception {
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(clientEngine, serverEngine);
            SSLSession session = clientEngine.getSession();
            Assert.assertEquals((long)0L, (long)session.getValueNames().length);
            String name = "name";
            String name2 = "name2";
            class SSLSessionBindingEventValue
            implements SSLSessionBindingListener {
                SSLSessionBindingEvent boundEvent;
                SSLSessionBindingEvent unboundEvent;

                SSLSessionBindingEventValue() {
                }

                @Override
                public void valueBound(SSLSessionBindingEvent sslSessionBindingEvent) {
                    Assert.assertNull((Object)this.boundEvent);
                    this.boundEvent = sslSessionBindingEvent;
                }

                @Override
                public void valueUnbound(SSLSessionBindingEvent sslSessionBindingEvent) {
                    Assert.assertNull((Object)this.unboundEvent);
                    this.unboundEvent = sslSessionBindingEvent;
                }
            }
            SSLSessionBindingEventValue value1 = new SSLSessionBindingEventValue();
            session.putValue(name, value1);
            SSLEngineTest.assertSSLSessionBindingEventValue(name, session, value1.boundEvent);
            Assert.assertNull((Object)value1.unboundEvent);
            Assert.assertEquals((long)1L, (long)session.getValueNames().length);
            session.putValue(name2, "value");
            SSLSessionBindingEventValue value2 = new SSLSessionBindingEventValue();
            session.putValue(name, value2);
            Assert.assertEquals((long)2L, (long)session.getValueNames().length);
            SSLEngineTest.assertSSLSessionBindingEventValue(name, session, value1.unboundEvent);
            SSLEngineTest.assertSSLSessionBindingEventValue(name, session, value2.boundEvent);
            Assert.assertNull((Object)value2.unboundEvent);
            Assert.assertEquals((long)2L, (long)session.getValueNames().length);
            session.removeValue(name);
            SSLEngineTest.assertSSLSessionBindingEventValue(name, session, value2.unboundEvent);
            Assert.assertEquals((long)1L, (long)session.getValueNames().length);
            session.removeValue(name2);
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            ssc.delete();
            throw throwable;
        }
        ssc.delete();
    }

    private static void assertSSLSessionBindingEventValue(String name, SSLSession session, SSLSessionBindingEvent event) {
        Assert.assertEquals((Object)name, (Object)event.getName());
        Assert.assertEquals((Object)session, (Object)event.getSession());
        Assert.assertEquals((Object)session, (Object)event.getSource());
    }

    @Test
    public void testSessionAfterHandshake() throws Exception {
        this.testSessionAfterHandshake0(false, false);
    }

    @Test
    public void testSessionAfterHandshakeMutualAuth() throws Exception {
        this.testSessionAfterHandshake0(false, true);
    }

    @Test
    public void testSessionAfterHandshakeKeyManagerFactory() throws Exception {
        this.testSessionAfterHandshake0(true, false);
    }

    @Test
    public void testSessionAfterHandshakeKeyManagerFactoryMutualAuth() throws Exception {
        this.testSessionAfterHandshake0(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSessionAfterHandshake0(boolean useKeyManagerFactory, boolean mutualAuth) throws Exception {
        SslContextBuilder serverContextBuilder;
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        KeyManagerFactory kmf = useKeyManagerFactory ? SslContext.buildKeyManagerFactory((X509Certificate[])new X509Certificate[]{ssc.cert()}, (PrivateKey)ssc.key(), null, null, null) : null;
        SslContextBuilder clientContextBuilder = SslContextBuilder.forClient();
        if (mutualAuth) {
            if (kmf != null) {
                clientContextBuilder.keyManager(kmf);
            } else {
                clientContextBuilder.keyManager(ssc.key(), new X509Certificate[]{ssc.cert()});
            }
        }
        this.clientSslCtx = this.wrapContext(clientContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SslContextBuilder sslContextBuilder = serverContextBuilder = kmf != null ? SslContextBuilder.forServer((KeyManagerFactory)kmf) : SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey());
        if (mutualAuth) {
            serverContextBuilder.clientAuth(ClientAuth.REQUIRE);
        }
        this.serverSslCtx = this.wrapContext(serverContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(clientEngine, serverEngine);
            SSLSession clientSession = clientEngine.getSession();
            SSLSession serverSession = serverEngine.getSession();
            Assert.assertNull((Object)clientSession.getPeerHost());
            Assert.assertNull((Object)serverSession.getPeerHost());
            Assert.assertEquals((long)-1L, (long)clientSession.getPeerPort());
            Assert.assertEquals((long)-1L, (long)serverSession.getPeerPort());
            Assert.assertTrue((clientSession.getCreationTime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((serverSession.getCreationTime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((clientSession.getLastAccessedTime() > 0L ? 1 : 0) != 0);
            Assert.assertTrue((serverSession.getLastAccessedTime() > 0L ? 1 : 0) != 0);
            Assert.assertEquals((Object)this.protocolCipherCombo.protocol, (Object)clientSession.getProtocol());
            Assert.assertEquals((Object)this.protocolCipherCombo.protocol, (Object)serverSession.getProtocol());
            Assert.assertEquals((Object)this.protocolCipherCombo.cipher, (Object)clientSession.getCipherSuite());
            Assert.assertEquals((Object)this.protocolCipherCombo.cipher, (Object)serverSession.getCipherSuite());
            Assert.assertNotNull((Object)clientSession.getId());
            Assert.assertNotNull((Object)serverSession.getId());
            Assert.assertTrue((clientSession.getApplicationBufferSize() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((serverSession.getApplicationBufferSize() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((clientSession.getPacketBufferSize() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((serverSession.getPacketBufferSize() > 0 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)clientSession.getSessionContext());
            if (PlatformDependent.javaVersion() != 14) {
                Assert.assertNotNull((Object)serverSession.getSessionContext());
            }
            Object value = new Object();
            Assert.assertEquals((long)0L, (long)clientSession.getValueNames().length);
            clientSession.putValue("test", value);
            Assert.assertEquals((Object)"test", (Object)clientSession.getValueNames()[0]);
            Assert.assertSame((Object)value, (Object)clientSession.getValue("test"));
            clientSession.removeValue("test");
            Assert.assertEquals((long)0L, (long)clientSession.getValueNames().length);
            Assert.assertEquals((long)0L, (long)serverSession.getValueNames().length);
            serverSession.putValue("test", value);
            Assert.assertEquals((Object)"test", (Object)serverSession.getValueNames()[0]);
            Assert.assertSame((Object)value, (Object)serverSession.getValue("test"));
            serverSession.removeValue("test");
            Assert.assertEquals((long)0L, (long)serverSession.getValueNames().length);
            Certificate[] serverLocalCertificates = serverSession.getLocalCertificates();
            Assert.assertEquals((long)1L, (long)serverLocalCertificates.length);
            Assert.assertArrayEquals((byte[])ssc.cert().getEncoded(), (byte[])serverLocalCertificates[0].getEncoded());
            Principal serverLocalPrincipal = serverSession.getLocalPrincipal();
            Assert.assertNotNull((Object)serverLocalPrincipal);
            if (mutualAuth) {
                Certificate[] clientLocalCertificates = clientSession.getLocalCertificates();
                Assert.assertEquals((long)1L, (long)clientLocalCertificates.length);
                Certificate[] serverPeerCertificates = serverSession.getPeerCertificates();
                Assert.assertEquals((long)1L, (long)serverPeerCertificates.length);
                Assert.assertArrayEquals((byte[])clientLocalCertificates[0].getEncoded(), (byte[])serverPeerCertificates[0].getEncoded());
                try {
                    javax.security.cert.X509Certificate[] serverPeerX509Certificates = serverSession.getPeerCertificateChain();
                    Assert.assertEquals((long)1L, (long)serverPeerX509Certificates.length);
                    Assert.assertArrayEquals((byte[])clientLocalCertificates[0].getEncoded(), (byte[])serverPeerX509Certificates[0].getEncoded());
                }
                catch (UnsupportedOperationException e) {
                    Assert.assertTrue((PlatformDependent.javaVersion() >= 15 ? 1 : 0) != 0);
                }
                Principal clientLocalPrincipial = clientSession.getLocalPrincipal();
                Assert.assertNotNull((Object)clientLocalPrincipial);
                Principal serverPeerPrincipal = serverSession.getPeerPrincipal();
                Assert.assertEquals((Object)clientLocalPrincipial, (Object)serverPeerPrincipal);
            } else {
                Assert.assertNull((Object)clientSession.getLocalCertificates());
                Assert.assertNull((Object)clientSession.getLocalPrincipal());
                try {
                    serverSession.getPeerCertificates();
                    Assert.fail();
                }
                catch (SSLPeerUnverifiedException clientLocalCertificates) {
                    // empty catch block
                }
                try {
                    serverSession.getPeerCertificateChain();
                    Assert.fail();
                }
                catch (SSLPeerUnverifiedException clientLocalCertificates) {
                }
                catch (UnsupportedOperationException e) {
                    Assert.assertTrue((PlatformDependent.javaVersion() >= 15 ? 1 : 0) != 0);
                }
                try {
                    serverSession.getPeerPrincipal();
                    Assert.fail();
                }
                catch (SSLPeerUnverifiedException e) {
                    // empty catch block
                }
            }
            Certificate[] clientPeerCertificates = clientSession.getPeerCertificates();
            Assert.assertEquals((long)1L, (long)clientPeerCertificates.length);
            Assert.assertArrayEquals((byte[])serverLocalCertificates[0].getEncoded(), (byte[])clientPeerCertificates[0].getEncoded());
            try {
                javax.security.cert.X509Certificate[] clientPeerX509Certificates = clientSession.getPeerCertificateChain();
                Assert.assertEquals((long)1L, (long)clientPeerX509Certificates.length);
                Assert.assertArrayEquals((byte[])serverLocalCertificates[0].getEncoded(), (byte[])clientPeerX509Certificates[0].getEncoded());
            }
            catch (UnsupportedOperationException e) {
                Assert.assertTrue((PlatformDependent.javaVersion() >= 15 ? 1 : 0) != 0);
            }
            Principal clientPeerPrincipal = clientSession.getPeerPrincipal();
            Assert.assertEquals((Object)serverLocalPrincipal, (Object)clientPeerPrincipal);
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            ssc.delete();
            throw throwable;
        }
        ssc.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSupportedSignatureAlgorithms() throws Exception {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        final class TestKeyManagerFactory
        extends KeyManagerFactory {
            TestKeyManagerFactory(final KeyManagerFactory factory) {
                super(new KeyManagerFactorySpi(){
                    private final KeyManager[] managers;
                    {
                        this.managers = factory.getKeyManagers();
                    }

                    @Override
                    protected void engineInit(KeyStore keyStore, char[] chars) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    protected KeyManager[] engineGetKeyManagers() {
                        KeyManager[] array = new KeyManager[this.managers.length];
                        for (int i = 0; i < array.length; ++i) {
                            final X509ExtendedKeyManager x509ExtendedKeyManager = (X509ExtendedKeyManager)this.managers[i];
                            array[i] = new X509ExtendedKeyManager(){

                                @Override
                                public String[] getClientAliases(String s, Principal[] principals) {
                                    Assert.fail();
                                    return null;
                                }

                                @Override
                                public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
                                    Assert.fail();
                                    return null;
                                }

                                @Override
                                public String[] getServerAliases(String s, Principal[] principals) {
                                    Assert.fail();
                                    return null;
                                }

                                @Override
                                public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
                                    Assert.fail();
                                    return null;
                                }

                                @Override
                                public String chooseEngineClientAlias(String[] strings, Principal[] principals, SSLEngine sslEngine) {
                                    Assert.assertNotEquals((long)0L, (long)((ExtendedSSLSession)sslEngine.getHandshakeSession()).getPeerSupportedSignatureAlgorithms().length);
                                    Assert.assertNotEquals((long)0L, (long)((ExtendedSSLSession)sslEngine.getHandshakeSession()).getLocalSupportedSignatureAlgorithms().length);
                                    return x509ExtendedKeyManager.chooseEngineClientAlias(strings, principals, sslEngine);
                                }

                                @Override
                                public String chooseEngineServerAlias(String s, Principal[] principals, SSLEngine sslEngine) {
                                    Assert.assertNotEquals((long)0L, (long)((ExtendedSSLSession)sslEngine.getHandshakeSession()).getPeerSupportedSignatureAlgorithms().length);
                                    Assert.assertNotEquals((long)0L, (long)((ExtendedSSLSession)sslEngine.getHandshakeSession()).getLocalSupportedSignatureAlgorithms().length);
                                    return x509ExtendedKeyManager.chooseEngineServerAlias(s, principals, sslEngine);
                                }

                                @Override
                                public X509Certificate[] getCertificateChain(String s) {
                                    return x509ExtendedKeyManager.getCertificateChain(s);
                                }

                                @Override
                                public PrivateKey getPrivateKey(String s) {
                                    return x509ExtendedKeyManager.getPrivateKey(s);
                                }
                            };
                        }
                        return array;
                    }
                }, factory.getProvider(), factory.getAlgorithm());
            }
        }
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().keyManager((KeyManagerFactory)new TestKeyManagerFactory(this.newKeyManagerFactory(ssc))).trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((KeyManagerFactory)new TestKeyManagerFactory(this.newKeyManagerFactory(ssc))).trustManager(InsecureTrustManagerFactory.INSTANCE).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).protocols(this.protocols()).ciphers(this.ciphers()).clientAuth(ClientAuth.REQUIRE).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(clientEngine, serverEngine);
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            ssc.delete();
            throw throwable;
        }
        ssc.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHandshakeSession() throws Exception {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        final TestTrustManagerFactory clientTmf = new TestTrustManagerFactory(ssc.cert());
        final TestTrustManagerFactory serverTmf = new TestTrustManagerFactory(ssc.cert());
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager((TrustManagerFactory)new SimpleTrustManagerFactory(){

            protected void engineInit(KeyStore keyStore) {
            }

            protected void engineInit(ManagerFactoryParameters managerFactoryParameters) {
            }

            protected TrustManager[] engineGetTrustManagers() {
                return new TrustManager[]{clientTmf};
            }
        }).keyManager(this.newKeyManagerFactory(ssc)).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((KeyManagerFactory)this.newKeyManagerFactory(ssc)).trustManager((TrustManagerFactory)new SimpleTrustManagerFactory(){

            protected void engineInit(KeyStore keyStore) {
            }

            protected void engineInit(ManagerFactoryParameters managerFactoryParameters) {
            }

            protected TrustManager[] engineGetTrustManagers() {
                return new TrustManager[]{serverTmf};
            }
        }).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(this.protocols()).ciphers(this.ciphers()).clientAuth(ClientAuth.REQUIRE).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(clientEngine, serverEngine);
            Assert.assertTrue((boolean)clientTmf.isVerified());
            Assert.assertTrue((boolean)serverTmf.isVerified());
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            ssc.delete();
            throw throwable;
        }
        ssc.delete();
    }

    @Test
    public void testSessionLocalWhenNonMutualWithKeyManager() throws Exception {
        this.testSessionLocalWhenNonMutual(true);
    }

    @Test
    public void testSessionLocalWhenNonMutualWithoutKeyManager() throws Exception {
        this.testSessionLocalWhenNonMutual(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSessionLocalWhenNonMutual(boolean useKeyManager) throws Exception {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        SslContextBuilder clientSslCtxBuilder = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(this.protocols()).ciphers(this.ciphers());
        if (useKeyManager) {
            clientSslCtxBuilder.keyManager(this.newKeyManagerFactory(ssc));
        } else {
            clientSslCtxBuilder.keyManager(ssc.certificate(), ssc.privateKey());
        }
        this.clientSslCtx = this.wrapContext(clientSslCtxBuilder.build());
        SslContextBuilder serverSslCtxBuilder = useKeyManager ? SslContextBuilder.forServer((KeyManagerFactory)this.newKeyManagerFactory(ssc)) : SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey());
        serverSslCtxBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(this.protocols()).ciphers(this.ciphers()).clientAuth(ClientAuth.NONE);
        this.serverSslCtx = this.wrapContext(serverSslCtxBuilder.build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(clientEngine, serverEngine);
            SSLSession clientSession = clientEngine.getSession();
            Assert.assertNull((Object)clientSession.getLocalCertificates());
            Assert.assertNull((Object)clientSession.getLocalPrincipal());
            SSLSession serverSession = serverEngine.getSession();
            Assert.assertNotNull((Object)serverSession.getLocalCertificates());
            Assert.assertNotNull((Object)serverSession.getLocalPrincipal());
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            ssc.delete();
            throw throwable;
        }
        ssc.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnabledProtocolsAndCiphers() throws Exception {
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(clientEngine, serverEngine);
            SSLEngineTest.assertEnabledProtocolsAndCipherSuites(clientEngine);
            SSLEngineTest.assertEnabledProtocolsAndCipherSuites(serverEngine);
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            ssc.delete();
            throw throwable;
        }
        ssc.delete();
    }

    private static void assertEnabledProtocolsAndCipherSuites(SSLEngine engine) {
        String protocol = engine.getSession().getProtocol();
        String cipherSuite = engine.getSession().getCipherSuite();
        SSLEngineTest.assertArrayContains(protocol, engine.getEnabledProtocols());
        SSLEngineTest.assertArrayContains(cipherSuite, engine.getEnabledCipherSuites());
    }

    private static void assertArrayContains(String expected, String[] array) {
        for (String value : array) {
            if (!expected.equals(value)) continue;
            return;
        }
        Assert.fail((String)("Array did not contain '" + expected + "':" + Arrays.toString(array)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterKeyLogging() throws Exception {
        if (this.protocolCipherCombo != ProtocolCipherCombo.tlsv12()) {
            return;
        }
        Assume.assumeFalse((boolean)(this.serverSslContextProvider() instanceof OpenSSLProvider));
        Assume.assumeFalse((this.sslServerProvider() == SslProvider.JDK && PlatformDependent.javaVersion() > 8 ? 1 : 0) != 0);
        String originalSystemPropertyValue = SystemPropertyUtil.get((String)"io.netty.ssl.masterKeyHandler");
        System.setProperty("io.netty.ssl.masterKeyHandler", Boolean.TRUE.toString());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        Socket socket = null;
        try {
            this.sb = new ServerBootstrap();
            this.sb.group((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup());
            this.sb.channel(NioServerSocketChannel.class);
            final Promise promise = this.sb.config().group().next().newPromise();
            this.serverChannel = this.sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), SSLEngineTest.this.type));
                    SslHandler sslHandler = SSLEngineTest.this.delegatingExecutor == null ? SSLEngineTest.this.serverSslCtx.newHandler(ch.alloc()) : SSLEngineTest.this.serverSslCtx.newHandler(ch.alloc(), (Executor)SSLEngineTest.this.delegatingExecutor);
                    ch.pipeline().addLast(new ChannelHandler[]{sslHandler});
                    ch.pipeline().addLast(new ChannelHandler[]{new SslMasterKeyHandler(){

                        protected void accept(SecretKey masterKey, SSLSession session) {
                            promise.setSuccess((Object)masterKey);
                        }
                    }});
                    SSLEngineTest.this.serverConnectedChannel = ch;
                }
            }).bind((SocketAddress)new InetSocketAddress(0)).sync().channel();
            int port = ((InetSocketAddress)this.serverChannel.localAddress()).getPort();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, InsecureTrustManagerFactory.INSTANCE.getTrustManagers(), null);
            socket = sslContext.getSocketFactory().createSocket(NetUtil.LOCALHOST, port);
            OutputStream out = socket.getOutputStream();
            out.write(1);
            out.flush();
            Assert.assertTrue((boolean)promise.await(10L, TimeUnit.SECONDS));
            SecretKey key = (SecretKey)promise.get();
            Assert.assertEquals((String)"AES secret key must be 48 bytes", (long)48L, (long)key.getEncoded().length);
        }
        catch (Throwable throwable) {
            SSLEngineTest.closeQuietly(socket);
            if (originalSystemPropertyValue != null) {
                System.setProperty("io.netty.ssl.masterKeyHandler", originalSystemPropertyValue);
            } else {
                System.clearProperty("io.netty.ssl.masterKeyHandler");
            }
            ssc.delete();
            throw throwable;
        }
        SSLEngineTest.closeQuietly(socket);
        if (originalSystemPropertyValue != null) {
            System.setProperty("io.netty.ssl.masterKeyHandler", originalSystemPropertyValue);
        } else {
            System.clearProperty("io.netty.ssl.masterKeyHandler");
        }
        ssc.delete();
    }

    private static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private KeyManagerFactory newKeyManagerFactory(SelfSignedCertificate ssc) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return SslContext.buildKeyManagerFactory((X509Certificate[])new X509Certificate[]{ssc.cert()}, (PrivateKey)ssc.key(), null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultProtocolsIncludeTLSv13() throws Exception {
        String[] serverProtocols;
        String[] clientProtocols;
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).ciphers(this.ciphers()).build());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).ciphers(this.ciphers()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            clientProtocols = clientEngine.getEnabledProtocols();
            serverProtocols = serverEngine.getEnabledProtocols();
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            ssc.delete();
            throw throwable;
        }
        ssc.delete();
        Assert.assertEquals((Object)SslProvider.isTlsv13EnabledByDefault((SslProvider)this.sslClientProvider(), (Provider)this.clientSslContextProvider()), (Object)SslUtils.arrayContains((String[])clientProtocols, (String)"TLSv1.3"));
        Assert.assertEquals((Object)SslProvider.isTlsv13EnabledByDefault((SslProvider)this.sslServerProvider(), (Provider)this.serverSslContextProvider()), (Object)SslUtils.arrayContains((String[])serverProtocols, (String)"TLSv1.3"));
    }

    protected SSLEngine wrapEngine(SSLEngine engine) {
        return engine;
    }

    protected SslContext wrapContext(SslContext context) {
        return context;
    }

    protected List<String> ciphers() {
        return Collections.singletonList(this.protocolCipherCombo.cipher);
    }

    protected String[] protocols() {
        return new String[]{this.protocolCipherCombo.protocol};
    }

    private final class TestTrustManagerFactory
    extends X509ExtendedTrustManager {
        private final Certificate localCert;
        private volatile boolean verified;

        TestTrustManagerFactory(Certificate localCert) {
            this.localCert = localCert;
        }

        boolean isVerified() {
            return this.verified;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) {
            Assert.fail();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) {
            Assert.fail();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) {
            this.verified = true;
            Assert.assertFalse((boolean)sslEngine.getUseClientMode());
            SSLSession session = sslEngine.getHandshakeSession();
            Assert.assertNotNull((Object)session);
            Certificate[] localCertificates = session.getLocalCertificates();
            Assert.assertNotNull((Object)localCertificates);
            Assert.assertEquals((long)1L, (long)localCertificates.length);
            Assert.assertEquals((Object)this.localCert, (Object)localCertificates[0]);
            Assert.assertNotNull((Object)session.getLocalPrincipal());
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) {
            this.verified = true;
            Assert.assertTrue((boolean)sslEngine.getUseClientMode());
            SSLSession session = sslEngine.getHandshakeSession();
            Assert.assertNotNull((Object)session);
            Assert.assertNull((Object)session.getLocalCertificates());
            Assert.assertNull((Object)session.getLocalPrincipal());
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
            Assert.fail();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
            Assert.fail();
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return EmptyArrays.EMPTY_X509_CERTIFICATES;
        }
    }

    private static final class TestByteBufAllocator
    implements ByteBufAllocator {
        private final ByteBufAllocator allocator;
        private final BufferType type;

        TestByteBufAllocator(ByteBufAllocator allocator, BufferType type) {
            this.allocator = allocator;
            this.type = type;
        }

        public ByteBuf buffer() {
            switch (this.type) {
                case Direct: {
                    return this.allocator.directBuffer();
                }
                case Heap: {
                    return this.allocator.heapBuffer();
                }
                case Mixed: {
                    return PlatformDependent.threadLocalRandom().nextBoolean() ? this.allocator.directBuffer() : this.allocator.heapBuffer();
                }
            }
            throw new Error();
        }

        public ByteBuf buffer(int initialCapacity) {
            switch (this.type) {
                case Direct: {
                    return this.allocator.directBuffer(initialCapacity);
                }
                case Heap: {
                    return this.allocator.heapBuffer(initialCapacity);
                }
                case Mixed: {
                    return PlatformDependent.threadLocalRandom().nextBoolean() ? this.allocator.directBuffer(initialCapacity) : this.allocator.heapBuffer(initialCapacity);
                }
            }
            throw new Error();
        }

        public ByteBuf buffer(int initialCapacity, int maxCapacity) {
            switch (this.type) {
                case Direct: {
                    return this.allocator.directBuffer(initialCapacity, maxCapacity);
                }
                case Heap: {
                    return this.allocator.heapBuffer(initialCapacity, maxCapacity);
                }
                case Mixed: {
                    return PlatformDependent.threadLocalRandom().nextBoolean() ? this.allocator.directBuffer(initialCapacity, maxCapacity) : this.allocator.heapBuffer(initialCapacity, maxCapacity);
                }
            }
            throw new Error();
        }

        public ByteBuf ioBuffer() {
            return this.allocator.ioBuffer();
        }

        public ByteBuf ioBuffer(int initialCapacity) {
            return this.allocator.ioBuffer(initialCapacity);
        }

        public ByteBuf ioBuffer(int initialCapacity, int maxCapacity) {
            return this.allocator.ioBuffer(initialCapacity, maxCapacity);
        }

        public ByteBuf heapBuffer() {
            return this.allocator.heapBuffer();
        }

        public ByteBuf heapBuffer(int initialCapacity) {
            return this.allocator.heapBuffer(initialCapacity);
        }

        public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
            return this.allocator.heapBuffer(initialCapacity, maxCapacity);
        }

        public ByteBuf directBuffer() {
            return this.allocator.directBuffer();
        }

        public ByteBuf directBuffer(int initialCapacity) {
            return this.allocator.directBuffer(initialCapacity);
        }

        public ByteBuf directBuffer(int initialCapacity, int maxCapacity) {
            return this.allocator.directBuffer(initialCapacity, maxCapacity);
        }

        public CompositeByteBuf compositeBuffer() {
            switch (this.type) {
                case Direct: {
                    return this.allocator.compositeDirectBuffer();
                }
                case Heap: {
                    return this.allocator.compositeHeapBuffer();
                }
                case Mixed: {
                    return PlatformDependent.threadLocalRandom().nextBoolean() ? this.allocator.compositeDirectBuffer() : this.allocator.compositeHeapBuffer();
                }
            }
            throw new Error();
        }

        public CompositeByteBuf compositeBuffer(int maxNumComponents) {
            switch (this.type) {
                case Direct: {
                    return this.allocator.compositeDirectBuffer(maxNumComponents);
                }
                case Heap: {
                    return this.allocator.compositeHeapBuffer(maxNumComponents);
                }
                case Mixed: {
                    return PlatformDependent.threadLocalRandom().nextBoolean() ? this.allocator.compositeDirectBuffer(maxNumComponents) : this.allocator.compositeHeapBuffer(maxNumComponents);
                }
            }
            throw new Error();
        }

        public CompositeByteBuf compositeHeapBuffer() {
            return this.allocator.compositeHeapBuffer();
        }

        public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
            return this.allocator.compositeHeapBuffer(maxNumComponents);
        }

        public CompositeByteBuf compositeDirectBuffer() {
            return this.allocator.compositeDirectBuffer();
        }

        public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
            return this.allocator.compositeDirectBuffer(maxNumComponents);
        }

        public boolean isDirectBufferPooled() {
            return this.allocator.isDirectBufferPooled();
        }

        public int calculateNewCapacity(int minNewCapacity, int maxCapacity) {
            return this.allocator.calculateNewCapacity(minNewCapacity, maxCapacity);
        }
    }

    static final class ProtocolCipherCombo {
        private static final ProtocolCipherCombo TLSV12 = new ProtocolCipherCombo("TLSv1.2", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        private static final ProtocolCipherCombo TLSV13 = new ProtocolCipherCombo("TLSv1.3", "TLS_AES_128_GCM_SHA256");
        final String protocol;
        final String cipher;

        private ProtocolCipherCombo(String protocol, String cipher) {
            this.protocol = protocol;
            this.cipher = cipher;
        }

        static ProtocolCipherCombo tlsv12() {
            return TLSV12;
        }

        static ProtocolCipherCombo tlsv13() {
            return TLSV13;
        }

        public String toString() {
            return "ProtocolCipherCombo{protocol='" + this.protocol + '\'' + ", cipher='" + this.cipher + '\'' + '}';
        }
    }

    static enum BufferType {
        Direct,
        Heap,
        Mixed;

    }

    protected static final class MessageDelegatorChannelHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final MessageReceiver receiver;
        private final CountDownLatch latch;

        public MessageDelegatorChannelHandler(MessageReceiver receiver, CountDownLatch latch) {
            super(false);
            this.receiver = receiver;
            this.latch = latch;
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
            this.receiver.messageReceived(msg);
            this.latch.countDown();
        }
    }

    static interface MessageReceiver {
        public void messageReceived(ByteBuf var1);
    }
}

