/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.SelfTestStatus;
import io.netty.handler.ssl.SSLEngineTest;
import io.netty.handler.ssl.SslProvider;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collection;
import javax.crypto.Cipher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AmazonCorrettoSslEngineTest
extends SSLEngineTest {
    @Parameterized.Parameters(name="{index}: bufferType = {0}, combo = {1}, delegate = {2}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (SSLEngineTest.BufferType type : SSLEngineTest.BufferType.values()) {
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv12(), false});
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv12(), true});
            if (!SslProvider.isTlsv13Supported((SslProvider)SslProvider.JDK)) continue;
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv13(), true});
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv13(), false});
        }
        return params;
    }

    public AmazonCorrettoSslEngineTest(SSLEngineTest.BufferType type, SSLEngineTest.ProtocolCipherCombo combo, boolean delegate) {
        super(type, combo, delegate);
    }

    @BeforeClass
    public static void checkAccp() {
        Assume.assumeTrue((AmazonCorrettoCryptoProvider.INSTANCE.getLoadingError() == null && AmazonCorrettoCryptoProvider.INSTANCE.runSelfTests().equals((Object)SelfTestStatus.PASSED) ? 1 : 0) != 0);
    }

    @Override
    protected SslProvider sslClientProvider() {
        return SslProvider.JDK;
    }

    @Override
    protected SslProvider sslServerProvider() {
        return SslProvider.JDK;
    }

    @Override
    @Before
    public void setup() {
        Security.insertProviderAt((Provider)AmazonCorrettoCryptoProvider.INSTANCE, 1);
        try {
            AmazonCorrettoCryptoProvider.INSTANCE.assertHealthy();
            String providerName = Cipher.getInstance("AES/GCM/NoPadding").getProvider().getName();
            Assert.assertEquals((Object)"AmazonCorrettoCryptoProvider", (Object)providerName);
        }
        catch (Throwable e) {
            Security.removeProvider("AmazonCorrettoCryptoProvider");
            throw new AssertionError((Object)e);
        }
        super.setup();
    }

    @Override
    @After
    public void tearDown() throws InterruptedException {
        super.tearDown();
        Security.removeProvider("AmazonCorrettoCryptoProvider");
        Assert.assertNull((Object)Security.getProvider("AmazonCorrettoCryptoProvider"));
    }

    @Override
    @Ignore
    public void testMutualAuthValidClientCertChainTooLongFailOptionalClientAuth() {
    }

    @Override
    @Ignore
    public void testMutualAuthValidClientCertChainTooLongFailRequireClientAuth() {
    }

    @Override
    protected boolean mySetupMutualAuthServerIsValidException(Throwable cause) {
        return super.mySetupMutualAuthServerIsValidException(cause) || AmazonCorrettoSslEngineTest.causedBySSLException(cause);
    }
}

