/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.Java8SslTestUtils;
import io.netty.handler.ssl.JdkSslEngine;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslContext;
import io.netty.handler.ssl.OpenSslTestUtils;
import io.netty.handler.ssl.PseudoRandomFunction;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.SSLEngineTest;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SslUtils;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.internal.tcnative.SSL;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.nio.ByteBuffer;
import java.security.AlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class OpenSslEngineTest
extends SSLEngineTest {
    private static final String PREFERRED_APPLICATION_LEVEL_PROTOCOL = "my-protocol-http2";
    private static final String FALLBACK_APPLICATION_LEVEL_PROTOCOL = "my-protocol-http1_1";
    protected final boolean useTasks;

    @Parameterized.Parameters(name="{index}: bufferType = {0}, combo = {1}, delegate = {2}, useTasks = {3}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (SSLEngineTest.BufferType type : SSLEngineTest.BufferType.values()) {
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv12(), false, false});
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv12(), false, true});
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv12(), true, false});
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv12(), true, true});
            if (!SslProvider.isTlsv13Supported((SslProvider)SslProvider.OPENSSL)) continue;
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv13(), false, false});
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv13(), false, true});
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv13(), true, false});
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv13(), true, true});
        }
        return params;
    }

    public OpenSslEngineTest(SSLEngineTest.BufferType type, SSLEngineTest.ProtocolCipherCombo cipherCombo, boolean delegate, boolean useTasks) {
        super(type, cipherCombo, delegate);
        this.useTasks = useTasks;
    }

    @BeforeClass
    public static void checkOpenSsl() {
        Assume.assumeTrue((boolean)OpenSsl.isAvailable());
    }

    @Override
    public void tearDown() throws InterruptedException {
        super.tearDown();
        Assert.assertEquals((String)"SSL error stack not correctly consumed", (long)0L, (long)SSL.getLastErrorNumber());
    }

    @Override
    @Test
    public void testSessionAfterHandshakeKeyManagerFactory() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testSessionAfterHandshakeKeyManagerFactory();
    }

    @Override
    @Test
    public void testSessionAfterHandshakeKeyManagerFactoryMutualAuth() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testSessionAfterHandshakeKeyManagerFactoryMutualAuth();
    }

    @Override
    @Test
    public void testMutualAuthInvalidIntermediateCASucceedWithOptionalClientAuth() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthInvalidIntermediateCASucceedWithOptionalClientAuth();
    }

    @Override
    @Test
    public void testMutualAuthInvalidIntermediateCAFailWithOptionalClientAuth() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthInvalidIntermediateCAFailWithOptionalClientAuth();
    }

    @Override
    @Test
    public void testMutualAuthInvalidIntermediateCAFailWithRequiredClientAuth() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthInvalidIntermediateCAFailWithRequiredClientAuth();
    }

    @Override
    @Test
    public void testMutualAuthValidClientCertChainTooLongFailOptionalClientAuth() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthValidClientCertChainTooLongFailOptionalClientAuth();
    }

    @Override
    @Test
    public void testMutualAuthValidClientCertChainTooLongFailRequireClientAuth() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthValidClientCertChainTooLongFailRequireClientAuth();
    }

    @Override
    public void testHandshakeSession() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testHandshakeSession();
    }

    @Override
    @Test
    public void testSupportedSignatureAlgorithms() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testSupportedSignatureAlgorithms();
    }

    private static boolean isNpnSupported(String versionString) {
        String[] versionParts;
        String[] versionStringParts = versionString.split(" ", -1);
        if (versionStringParts.length == 2 && "LibreSSL".equals(versionStringParts[0]) && (versionParts = versionStringParts[1].split("\\.", -1)).length == 3) {
            int major = Integer.parseInt(versionParts[0]);
            if (major < 2) {
                return true;
            }
            if (major > 2) {
                return false;
            }
            int minor = Integer.parseInt(versionParts[1]);
            if (minor < 6) {
                return true;
            }
            if (minor > 6) {
                return false;
            }
            int bugfix = Integer.parseInt(versionParts[2]);
            if (bugfix > 0) {
                return false;
            }
        }
        return true;
    }

    @Test
    public void testNpn() throws Exception {
        String versionString = OpenSsl.versionString();
        Assume.assumeTrue((String)("LibreSSL 2.6.1 removed NPN support, detected " + versionString), (boolean)OpenSslEngineTest.isNpnSupported(versionString));
        ApplicationProtocolConfig apn = OpenSslEngineTest.acceptingNegotiator(ApplicationProtocolConfig.Protocol.NPN, PREFERRED_APPLICATION_LEVEL_PROTOCOL);
        this.setupHandlers(apn);
        this.runTest(PREFERRED_APPLICATION_LEVEL_PROTOCOL);
    }

    @Test
    public void testAlpn() throws Exception {
        Assume.assumeTrue((boolean)OpenSsl.isAlpnSupported());
        ApplicationProtocolConfig apn = OpenSslEngineTest.acceptingNegotiator(ApplicationProtocolConfig.Protocol.ALPN, PREFERRED_APPLICATION_LEVEL_PROTOCOL);
        this.setupHandlers(apn);
        this.runTest(PREFERRED_APPLICATION_LEVEL_PROTOCOL);
    }

    @Test
    public void testAlpnCompatibleProtocolsDifferentClientOrder() throws Exception {
        Assume.assumeTrue((boolean)OpenSsl.isAlpnSupported());
        ApplicationProtocolConfig clientApn = OpenSslEngineTest.acceptingNegotiator(ApplicationProtocolConfig.Protocol.ALPN, FALLBACK_APPLICATION_LEVEL_PROTOCOL, PREFERRED_APPLICATION_LEVEL_PROTOCOL);
        ApplicationProtocolConfig serverApn = OpenSslEngineTest.acceptingNegotiator(ApplicationProtocolConfig.Protocol.ALPN, PREFERRED_APPLICATION_LEVEL_PROTOCOL, FALLBACK_APPLICATION_LEVEL_PROTOCOL);
        this.setupHandlers(serverApn, clientApn);
        Assert.assertNull((Object)this.serverException);
        this.runTest(PREFERRED_APPLICATION_LEVEL_PROTOCOL);
    }

    @Test
    public void testEnablingAnAlreadyDisabledSslProtocol() throws Exception {
        this.testEnablingAnAlreadyDisabledSslProtocol(new String[]{"SSLv2Hello"}, new String[]{"SSLv2Hello", "TLSv1.2"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWrapBuffersNoWritePendingError() throws Exception {
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(clientEngine, serverEngine);
            ByteBuffer src = this.allocateBuffer(10240);
            byte[] data = new byte[src.capacity()];
            PlatformDependent.threadLocalRandom().nextBytes(data);
            src.put(data).flip();
            ByteBuffer dst = this.allocateBuffer(1);
            for (int i = 0; i < 100; ++i) {
                src.position(0);
                dst.position(0);
                Assert.assertSame((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW), (Object)((Object)clientEngine.wrap(src, dst).getStatus()));
            }
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
        this.cleanupClientSslEngine(clientEngine);
        this.cleanupServerSslEngine(serverEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOnlySmallBufferNeededForWrap() throws Exception {
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(clientEngine, serverEngine);
            int srcLen = 1024;
            ByteBuffer src = this.allocateBuffer(srcLen);
            ByteBuffer dstTooSmall = this.allocateBuffer(src.capacity() + this.unwrapEngine(clientEngine).maxWrapOverhead() - 1);
            ByteBuffer dst = this.allocateBuffer(src.capacity() + this.unwrapEngine(clientEngine).maxWrapOverhead());
            SSLEngineResult result = clientEngine.wrap(src, dstTooSmall);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)0L, (long)result.bytesConsumed());
            Assert.assertEquals((long)0L, (long)result.bytesProduced());
            Assert.assertEquals((long)src.remaining(), (long)src.capacity());
            Assert.assertEquals((long)dst.remaining(), (long)dst.capacity());
            result = clientEngine.wrap(src, dst);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)srcLen, (long)result.bytesConsumed());
            Assert.assertEquals((long)0L, (long)src.remaining());
            Assert.assertTrue((result.bytesProduced() > srcLen ? 1 : 0) != 0);
            Assert.assertEquals((long)(src.capacity() - result.bytesConsumed()), (long)src.remaining());
            Assert.assertEquals((long)(dst.capacity() - result.bytesProduced()), (long)dst.remaining());
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
        this.cleanupClientSslEngine(clientEngine);
        this.cleanupServerSslEngine(serverEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNeededDstCapacityIsCorrectlyCalculated() throws Exception {
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(clientEngine, serverEngine);
            ByteBuffer src = this.allocateBuffer(1024);
            ByteBuffer src2 = src.duplicate();
            ByteBuffer dst = this.allocateBuffer(src.capacity() + this.unwrapEngine(clientEngine).maxWrapOverhead());
            SSLEngineResult result = clientEngine.wrap(new ByteBuffer[]{src, src2}, dst);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)0L, (long)src.position());
            Assert.assertEquals((long)0L, (long)src2.position());
            Assert.assertEquals((long)0L, (long)dst.position());
            Assert.assertEquals((long)0L, (long)result.bytesConsumed());
            Assert.assertEquals((long)0L, (long)result.bytesProduced());
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
        this.cleanupClientSslEngine(clientEngine);
        this.cleanupServerSslEngine(serverEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSrcsLenOverFlowCorrectlyHandled() throws Exception {
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            ByteBuffer dup;
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(clientEngine, serverEngine);
            ByteBuffer src = this.allocateBuffer(1024);
            ArrayList<ByteBuffer> srcList = new ArrayList<ByteBuffer>();
            long maxLen = 0xFFFFFFFEL;
            for (long srcsLen = 0L; srcsLen < maxLen; srcsLen += (long)dup.capacity()) {
                dup = src.duplicate();
                srcList.add(dup);
            }
            ByteBuffer[] srcs = srcList.toArray(new ByteBuffer[0]);
            ByteBuffer dst = this.allocateBuffer(this.unwrapEngine(clientEngine).maxEncryptedPacketLength() - 1);
            SSLEngineResult result = clientEngine.wrap(srcs, dst);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW), (Object)((Object)result.getStatus()));
            for (ByteBuffer buffer : srcs) {
                Assert.assertEquals((long)0L, (long)buffer.position());
            }
            Assert.assertEquals((long)0L, (long)dst.position());
            Assert.assertEquals((long)0L, (long)result.bytesConsumed());
            Assert.assertEquals((long)0L, (long)result.bytesProduced());
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
        this.cleanupClientSslEngine(clientEngine);
        this.cleanupServerSslEngine(serverEngine);
    }

    @Test
    public void testCalculateOutNetBufSizeOverflow() throws SSLException {
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine clientEngine = null;
        try {
            clientEngine = this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
            int value = ((ReferenceCountedOpenSslEngine)clientEngine).calculateMaxLengthForWrap(Integer.MAX_VALUE, 1);
            Assert.assertTrue((String)("unexpected value: " + value), (value > 0 ? 1 : 0) != 0);
        }
        finally {
            this.cleanupClientSslEngine(clientEngine);
        }
    }

    @Test
    public void testCalculateOutNetBufSize0() throws SSLException {
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine clientEngine = null;
        try {
            clientEngine = this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
            Assert.assertTrue((((ReferenceCountedOpenSslEngine)clientEngine).calculateMaxLengthForWrap(0, 1) > 0 ? 1 : 0) != 0);
        }
        finally {
            this.cleanupClientSslEngine(clientEngine);
        }
    }

    @Test
    public void testCorrectlyCalculateSpaceForAlert() throws Exception {
        this.testCorrectlyCalculateSpaceForAlert(true);
    }

    @Test
    public void testCorrectlyCalculateSpaceForAlertJDKCompatabilityModeOff() throws Exception {
        this.testCorrectlyCalculateSpaceForAlert(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCorrectlyCalculateSpaceForAlert(boolean jdkCompatabilityMode) throws Exception {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            if (jdkCompatabilityMode) {
                clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
                serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            } else {
                clientEngine = this.wrapEngine(this.clientSslCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT).engine());
                serverEngine = this.wrapEngine(this.serverSslCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT).engine());
            }
            this.handshake(clientEngine, serverEngine);
            clientEngine.closeOutbound();
            ByteBuffer empty = this.allocateBuffer(0);
            ByteBuffer dst = this.allocateBuffer(clientEngine.getSession().getPacketBufferSize());
            dst.limit(1);
            SSLEngineResult result = clientEngine.wrap(empty, dst);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW), (Object)((Object)result.getStatus()));
            dst.limit(dst.capacity());
            result = clientEngine.wrap(empty, dst);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.CLOSED), (Object)((Object)result.getStatus()));
            dst.flip();
            int length = SslUtils.getEncryptedPacketLength((ByteBuffer[])new ByteBuffer[]{dst}, (int)0);
            Assert.assertEquals((long)length, (long)dst.remaining());
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            ssc.delete();
            throw throwable;
        }
        this.cleanupClientSslEngine(clientEngine);
        this.cleanupServerSslEngine(serverEngine);
        ssc.delete();
    }

    @Override
    protected void mySetupMutualAuthServerInitSslHandler(SslHandler handler) {
        ReferenceCountedOpenSslEngine engine = (ReferenceCountedOpenSslEngine)handler.engine();
        engine.setVerify(-1, 1);
    }

    @Test
    public void testWrapWithDifferentSizesTLSv1() throws Exception {
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).build());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).build());
        this.testWrapWithDifferentSizes("TLSv1", "AES128-SHA");
        this.testWrapWithDifferentSizes("TLSv1", "ECDHE-RSA-AES128-SHA");
        this.testWrapWithDifferentSizes("TLSv1", "DES-CBC3-SHA");
        this.testWrapWithDifferentSizes("TLSv1", "AECDH-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes("TLSv1", "CAMELLIA128-SHA");
        this.testWrapWithDifferentSizes("TLSv1", "SEED-SHA");
        this.testWrapWithDifferentSizes("TLSv1", "RC4-MD5");
        this.testWrapWithDifferentSizes("TLSv1", "AES256-SHA");
        this.testWrapWithDifferentSizes("TLSv1", "ADH-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes("TLSv1", "EDH-RSA-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes("TLSv1", "ADH-RC4-MD5");
        this.testWrapWithDifferentSizes("TLSv1", "IDEA-CBC-SHA");
        this.testWrapWithDifferentSizes("TLSv1", "RC4-SHA");
        this.testWrapWithDifferentSizes("TLSv1", "CAMELLIA256-SHA");
        this.testWrapWithDifferentSizes("TLSv1", "AECDH-RC4-SHA");
        this.testWrapWithDifferentSizes("TLSv1", "ECDHE-RSA-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes("TLSv1", "ECDHE-RSA-AES256-SHA");
        this.testWrapWithDifferentSizes("TLSv1", "ECDHE-RSA-RC4-SHA");
    }

    @Test
    public void testWrapWithDifferentSizesTLSv1_1() throws Exception {
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).build());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).build());
        this.testWrapWithDifferentSizes("TLSv1.1", "ECDHE-RSA-AES256-SHA");
        this.testWrapWithDifferentSizes("TLSv1.1", "AES256-SHA");
        this.testWrapWithDifferentSizes("TLSv1.1", "CAMELLIA256-SHA");
        this.testWrapWithDifferentSizes("TLSv1.1", "ECDHE-RSA-AES256-SHA");
        this.testWrapWithDifferentSizes("TLSv1.1", "SEED-SHA");
        this.testWrapWithDifferentSizes("TLSv1.1", "CAMELLIA128-SHA");
        this.testWrapWithDifferentSizes("TLSv1.1", "IDEA-CBC-SHA");
        this.testWrapWithDifferentSizes("TLSv1.1", "AECDH-RC4-SHA");
        this.testWrapWithDifferentSizes("TLSv1.1", "ADH-RC4-MD5");
        this.testWrapWithDifferentSizes("TLSv1.1", "RC4-SHA");
        this.testWrapWithDifferentSizes("TLSv1.1", "ECDHE-RSA-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes("TLSv1.1", "EDH-RSA-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes("TLSv1.1", "AECDH-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes("TLSv1.1", "ADH-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes("TLSv1.1", "DES-CBC3-SHA");
    }

    @Test
    public void testWrapWithDifferentSizesTLSv1_2() throws Exception {
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).build());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).build());
        this.testWrapWithDifferentSizes("TLSv1.2", "AES128-SHA");
        this.testWrapWithDifferentSizes("TLSv1.2", "ECDHE-RSA-AES128-SHA");
        this.testWrapWithDifferentSizes("TLSv1.2", "DES-CBC3-SHA");
        this.testWrapWithDifferentSizes("TLSv1.2", "AES128-GCM-SHA256");
        this.testWrapWithDifferentSizes("TLSv1.2", "ECDHE-RSA-AES256-SHA384");
        this.testWrapWithDifferentSizes("TLSv1.2", "AECDH-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes("TLSv1.2", "AES256-GCM-SHA384");
        this.testWrapWithDifferentSizes("TLSv1.2", "AES256-SHA256");
        this.testWrapWithDifferentSizes("TLSv1.2", "ECDHE-RSA-AES128-GCM-SHA256");
        this.testWrapWithDifferentSizes("TLSv1.2", "ECDHE-RSA-AES128-SHA256");
        this.testWrapWithDifferentSizes("TLSv1.2", "CAMELLIA128-SHA");
        this.testWrapWithDifferentSizes("TLSv1.2", "SEED-SHA");
        this.testWrapWithDifferentSizes("TLSv1.2", "RC4-MD5");
        this.testWrapWithDifferentSizes("TLSv1.2", "AES256-SHA");
        this.testWrapWithDifferentSizes("TLSv1.2", "ADH-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes("TLSv1.2", "EDH-RSA-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes("TLSv1.2", "ADH-RC4-MD5");
        this.testWrapWithDifferentSizes("TLSv1.2", "RC4-SHA");
        this.testWrapWithDifferentSizes("TLSv1.2", "CAMELLIA256-SHA");
        this.testWrapWithDifferentSizes("TLSv1.2", "AES128-SHA256");
        this.testWrapWithDifferentSizes("TLSv1.2", "AECDH-RC4-SHA");
        this.testWrapWithDifferentSizes("TLSv1.2", "ECDHE-RSA-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes("TLSv1.2", "ECDHE-RSA-AES256-GCM-SHA384");
        this.testWrapWithDifferentSizes("TLSv1.2", "ECDHE-RSA-AES256-SHA");
        this.testWrapWithDifferentSizes("TLSv1.2", "ECDHE-RSA-RC4-SHA");
    }

    @Test
    public void testWrapWithDifferentSizesSSLv3() throws Exception {
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).build());
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).build());
        this.testWrapWithDifferentSizes("SSLv3", "ADH-AES128-SHA");
        this.testWrapWithDifferentSizes("SSLv3", "ADH-CAMELLIA128-SHA");
        this.testWrapWithDifferentSizes("SSLv3", "AECDH-AES128-SHA");
        this.testWrapWithDifferentSizes("SSLv3", "AECDH-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes("SSLv3", "CAMELLIA128-SHA");
        this.testWrapWithDifferentSizes("SSLv3", "DHE-RSA-AES256-SHA");
        this.testWrapWithDifferentSizes("SSLv3", "SEED-SHA");
        this.testWrapWithDifferentSizes("SSLv3", "RC4-MD5");
        this.testWrapWithDifferentSizes("SSLv3", "ADH-AES256-SHA");
        this.testWrapWithDifferentSizes("SSLv3", "ADH-SEED-SHA");
        this.testWrapWithDifferentSizes("SSLv3", "ADH-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes("SSLv3", "EDH-RSA-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes("SSLv3", "ADH-RC4-MD5");
        this.testWrapWithDifferentSizes("SSLv3", "IDEA-CBC-SHA");
        this.testWrapWithDifferentSizes("SSLv3", "DHE-RSA-AES128-SHA");
        this.testWrapWithDifferentSizes("SSLv3", "RC4-SHA");
        this.testWrapWithDifferentSizes("SSLv3", "CAMELLIA256-SHA");
        this.testWrapWithDifferentSizes("SSLv3", "AECDH-RC4-SHA");
        this.testWrapWithDifferentSizes("SSLv3", "DHE-RSA-SEED-SHA");
        this.testWrapWithDifferentSizes("SSLv3", "AECDH-AES256-SHA");
        this.testWrapWithDifferentSizes("SSLv3", "ECDHE-RSA-DES-CBC3-SHA");
        this.testWrapWithDifferentSizes("SSLv3", "ADH-CAMELLIA256-SHA");
        this.testWrapWithDifferentSizes("SSLv3", "DHE-RSA-CAMELLIA256-SHA");
        this.testWrapWithDifferentSizes("SSLv3", "DHE-RSA-CAMELLIA128-SHA");
        this.testWrapWithDifferentSizes("SSLv3", "ECDHE-RSA-RC4-SHA");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleRecordsInOneBufferWithNonZeroPositionJDKCompatabilityModeOff() throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslProvider(this.sslClientProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT).engine());
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslProvider(this.sslServerProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT).engine());
        try {
            int plainClientOutLen = 1024;
            ByteBuffer plainClientOut = this.allocateBuffer(1024);
            ByteBuffer plainServerOut = this.allocateBuffer(server.getSession().getApplicationBufferSize());
            ByteBuffer encClientToServer = this.allocateBuffer(client.getSession().getPacketBufferSize());
            int positionOffset = 1;
            ByteBuffer combinedEncClientToServer = this.allocateBuffer(encClientToServer.capacity() * 2 + positionOffset);
            combinedEncClientToServer.position(positionOffset);
            this.handshake(client, server);
            plainClientOut.limit(plainClientOut.capacity());
            SSLEngineResult result = client.wrap(plainClientOut, encClientToServer);
            Assert.assertEquals((long)plainClientOut.capacity(), (long)result.bytesConsumed());
            Assert.assertTrue((result.bytesProduced() > 0 ? 1 : 0) != 0);
            encClientToServer.flip();
            combinedEncClientToServer.put(encClientToServer);
            plainClientOut.clear();
            encClientToServer.clear();
            result = client.wrap(plainClientOut, encClientToServer);
            Assert.assertEquals((long)plainClientOut.capacity(), (long)result.bytesConsumed());
            Assert.assertTrue((result.bytesProduced() > 0 ? 1 : 0) != 0);
            encClientToServer.flip();
            combinedEncClientToServer.put(encClientToServer);
            encClientToServer.clear();
            combinedEncClientToServer.flip();
            combinedEncClientToServer.position(positionOffset);
            combinedEncClientToServer.limit(combinedEncClientToServer.limit() - positionOffset);
            int combinedEncClientToServerLen = combinedEncClientToServer.remaining();
            result = server.unwrap(combinedEncClientToServer, plainServerOut);
            Assert.assertEquals((long)0L, (long)combinedEncClientToServer.remaining());
            Assert.assertEquals((long)combinedEncClientToServerLen, (long)result.bytesConsumed());
            Assert.assertEquals((long)1024L, (long)result.bytesProduced());
        }
        finally {
            cert.delete();
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInputTooBigAndFillsUpBuffersJDKCompatabilityModeOff() throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslProvider(this.sslClientProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT).engine());
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslProvider(this.sslServerProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT).engine());
        try {
            ByteBuffer plainClient = this.allocateBuffer(ReferenceCountedOpenSslEngine.MAX_PLAINTEXT_LENGTH + 100);
            ByteBuffer plainClient2 = this.allocateBuffer(512);
            ByteBuffer plainClientTotal = this.allocateBuffer(plainClient.capacity() + plainClient2.capacity());
            plainClientTotal.put(plainClient);
            plainClientTotal.put(plainClient2);
            plainClient.clear();
            plainClient2.clear();
            plainClientTotal.flip();
            ByteBuffer encClientToServerTooSmall = this.allocateBuffer(ReferenceCountedOpenSslEngine.MAX_PLAINTEXT_LENGTH + 28);
            ByteBuffer encClientToServer = this.allocateBuffer(client.getSession().getApplicationBufferSize());
            ByteBuffer encClientToServerTotal = this.allocateBuffer(client.getSession().getApplicationBufferSize() << 1);
            ByteBuffer plainServer = this.allocateBuffer(server.getSession().getApplicationBufferSize() << 1);
            this.handshake(client, server);
            int plainClientRemaining = plainClient.remaining();
            int encClientToServerTooSmallRemaining = encClientToServerTooSmall.remaining();
            SSLEngineResult result = client.wrap(plainClient, encClientToServerTooSmall);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)(plainClientRemaining - plainClient.remaining()), (long)result.bytesConsumed());
            Assert.assertEquals((long)(encClientToServerTooSmallRemaining - encClientToServerTooSmall.remaining()), (long)result.bytesProduced());
            result = client.wrap(plainClient, encClientToServerTooSmall);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)0L, (long)result.bytesConsumed());
            Assert.assertEquals((long)0L, (long)result.bytesProduced());
            plainClientRemaining = plainClient.remaining();
            int encClientToServerRemaining = encClientToServer.remaining();
            result = client.wrap(plainClient, encClientToServer);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)plainClientRemaining, (long)result.bytesConsumed());
            Assert.assertEquals((long)(encClientToServerRemaining - encClientToServer.remaining()), (long)result.bytesProduced());
            Assert.assertEquals((long)0L, (long)plainClient.remaining());
            int plainClient2Remaining = plainClient2.remaining();
            encClientToServerRemaining = encClientToServer.remaining();
            result = client.wrap(plainClient2, encClientToServer);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)plainClient2Remaining, (long)result.bytesConsumed());
            Assert.assertEquals((long)(encClientToServerRemaining - encClientToServer.remaining()), (long)result.bytesProduced());
            encClientToServerTooSmall.flip();
            encClientToServer.flip();
            encClientToServerTotal.put(encClientToServerTooSmall);
            encClientToServerTotal.put(encClientToServer);
            encClientToServerTotal.flip();
            int encClientToServerTotalRemaining = encClientToServerTotal.remaining();
            result = server.unwrap(encClientToServerTotal, plainServer);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)encClientToServerTotalRemaining, (long)result.bytesConsumed());
            plainServer.flip();
            Assert.assertEquals((Object)plainClientTotal, (Object)plainServer);
        }
        finally {
            cert.delete();
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPartialPacketUnwrapJDKCompatabilityModeOff() throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslProvider(this.sslClientProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT).engine());
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslProvider(this.sslServerProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT).engine());
        try {
            ByteBuffer plainClient = this.allocateBuffer(1024);
            ByteBuffer plainClient2 = this.allocateBuffer(512);
            ByteBuffer plainClientTotal = this.allocateBuffer(plainClient.capacity() + plainClient2.capacity());
            plainClientTotal.put(plainClient);
            plainClientTotal.put(plainClient2);
            plainClient.clear();
            plainClient2.clear();
            plainClientTotal.flip();
            ByteBuffer encClientToServer = this.allocateBuffer(client.getSession().getPacketBufferSize());
            ByteBuffer plainServer = this.allocateBuffer(server.getSession().getApplicationBufferSize());
            this.handshake(client, server);
            SSLEngineResult result = client.wrap(plainClient, encClientToServer);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)result.bytesConsumed(), (long)plainClient.capacity());
            int encClientLen = result.bytesProduced();
            result = client.wrap(plainClient2, encClientToServer);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)result.bytesConsumed(), (long)plainClient2.capacity());
            int encClientLen2 = result.bytesProduced();
            encClientToServer.flip();
            ByteBuffer encClientFirstHalf = encClientToServer.duplicate();
            encClientFirstHalf.limit(encClientLen / 2);
            result = server.unwrap(encClientFirstHalf, plainServer);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)result.bytesConsumed(), (long)(encClientLen / 2));
            encClientToServer.position(result.bytesConsumed());
            ByteBuffer encClientAllButLastByte = encClientToServer.duplicate();
            int encClientAllButLastByteLen = encClientAllButLastByte.remaining() - 1;
            encClientAllButLastByte.limit(encClientAllButLastByte.limit() - 1);
            result = server.unwrap(encClientAllButLastByte, plainServer);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)result.bytesConsumed(), (long)encClientAllButLastByteLen);
            encClientToServer.position(encClientToServer.position() + result.bytesConsumed());
            result = server.unwrap(encClientToServer, plainServer);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)result.bytesConsumed(), (long)1L);
            plainServer.flip();
            Assert.assertEquals((Object)plainClientTotal, (Object)plainServer);
        }
        finally {
            cert.delete();
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBufferUnderFlowAvoidedIfJDKCompatabilityModeOff() throws Exception {
        SelfSignedCertificate cert = new SelfSignedCertificate();
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslProvider(this.sslClientProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT).engine());
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslProvider(this.sslServerProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT).engine());
        try {
            ByteBuffer plainClient = this.allocateBuffer(1024);
            plainClient.limit(plainClient.capacity());
            ByteBuffer encClientToServer = this.allocateBuffer(client.getSession().getPacketBufferSize());
            ByteBuffer plainServer = this.allocateBuffer(server.getSession().getApplicationBufferSize());
            this.handshake(client, server);
            SSLEngineResult result = client.wrap(plainClient, encClientToServer);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)result.bytesConsumed(), (long)plainClient.capacity());
            encClientToServer.flip();
            int remaining = encClientToServer.remaining();
            encClientToServer.limit(4);
            result = server.unwrap(encClientToServer, plainServer);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)4L, (long)result.bytesConsumed());
            Assert.assertEquals((long)0L, (long)result.bytesProduced());
            remaining -= result.bytesConsumed();
            encClientToServer.limit(5);
            result = server.unwrap(encClientToServer, plainServer);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)1L, (long)result.bytesConsumed());
            Assert.assertEquals((long)0L, (long)result.bytesProduced());
            encClientToServer.limit(5 + (remaining -= result.bytesConsumed()) - 1 - 5);
            result = server.unwrap(encClientToServer, plainServer);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)(encClientToServer.limit() - 5), (long)result.bytesConsumed());
            Assert.assertEquals((long)0L, (long)result.bytesProduced());
            encClientToServer.limit(remaining -= result.bytesConsumed());
            Assert.assertEquals((long)0L, (long)encClientToServer.remaining());
            result = server.unwrap(encClientToServer, plainServer);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)0L, (long)result.bytesConsumed());
            Assert.assertEquals((long)0L, (long)result.bytesProduced());
            encClientToServer.position(0);
            result = server.unwrap(encClientToServer, plainServer);
            Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assert.assertEquals((long)remaining, (long)result.bytesConsumed());
            Assert.assertEquals((long)0L, (long)result.bytesProduced());
        }
        finally {
            cert.delete();
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testWrapWithDifferentSizes(String protocol, String cipher) throws Exception {
        Assume.assumeTrue((boolean)OpenSsl.SUPPORTED_PROTOCOLS_SET.contains(protocol));
        if (!OpenSsl.isCipherSuiteAvailable((String)cipher)) {
            return;
        }
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            clientEngine.setEnabledCipherSuites(new String[]{cipher});
            clientEngine.setEnabledProtocols(new String[]{protocol});
            serverEngine.setEnabledCipherSuites(new String[]{cipher});
            serverEngine.setEnabledProtocols(new String[]{protocol});
            try {
                this.handshake(clientEngine, serverEngine);
            }
            catch (SSLException e) {
                if (e.getMessage().contains("unsupported protocol") || e.getMessage().contains("no protocols available")) {
                    Assume.assumeNoException((String)(protocol + " not supported with cipher " + cipher), (Throwable)e);
                }
                throw e;
            }
            int srcLen = 64;
            do {
                this.testWrapDstBigEnough(clientEngine, srcLen);
            } while ((srcLen += 64) < ReferenceCountedOpenSslEngine.MAX_PLAINTEXT_LENGTH);
            this.testWrapDstBigEnough(clientEngine, ReferenceCountedOpenSslEngine.MAX_PLAINTEXT_LENGTH);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
        this.cleanupClientSslEngine(clientEngine);
        this.cleanupServerSslEngine(serverEngine);
    }

    private void testWrapDstBigEnough(SSLEngine engine, int srcLen) throws SSLException {
        ByteBuffer src = this.allocateBuffer(srcLen);
        ByteBuffer dst = this.allocateBuffer(srcLen + this.unwrapEngine(engine).maxWrapOverhead());
        SSLEngineResult result = engine.wrap(src, dst);
        Assert.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
        int consumed = result.bytesConsumed();
        int produced = result.bytesProduced();
        Assert.assertEquals((long)srcLen, (long)consumed);
        Assert.assertTrue((produced > consumed ? 1 : 0) != 0);
        dst.flip();
        Assert.assertEquals((long)produced, (long)dst.remaining());
        Assert.assertFalse((boolean)src.hasRemaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSNIMatchersDoesNotThrow() throws Exception {
        Assume.assumeTrue((PlatformDependent.javaVersion() >= 8 ? 1 : 0) != 0);
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine engine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            SSLParameters parameters = new SSLParameters();
            Java8SslTestUtils.setSNIMatcher(parameters, EmptyArrays.EMPTY_BYTES);
            engine.setSSLParameters(parameters);
        }
        finally {
            this.cleanupServerSslEngine(engine);
            ssc.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSNIMatchersWithSNINameWithUnderscore() throws Exception {
        Assume.assumeTrue((PlatformDependent.javaVersion() >= 8 ? 1 : 0) != 0);
        byte[] name = "rb8hx3pww30y3tvw0mwy.v1_1".getBytes(CharsetUtil.UTF_8);
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine engine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            SSLParameters parameters = new SSLParameters();
            Java8SslTestUtils.setSNIMatcher(parameters, name);
            engine.setSSLParameters(parameters);
            Assert.assertTrue((boolean)this.unwrapEngine(engine).checkSniHostnameMatch(name));
            Assert.assertFalse((boolean)this.unwrapEngine(engine).checkSniHostnameMatch("other".getBytes(CharsetUtil.UTF_8)));
        }
        finally {
            this.cleanupServerSslEngine(engine);
            ssc.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testAlgorithmConstraintsThrows() throws Exception {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        SSLEngine engine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            SSLParameters parameters = new SSLParameters();
            parameters.setAlgorithmConstraints(new AlgorithmConstraints(){

                @Override
                public boolean permits(Set<CryptoPrimitive> primitives, String algorithm, AlgorithmParameters parameters) {
                    return false;
                }

                @Override
                public boolean permits(Set<CryptoPrimitive> primitives, Key key) {
                    return false;
                }

                @Override
                public boolean permits(Set<CryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
                    return false;
                }
            });
            engine.setSSLParameters(parameters);
        }
        finally {
            this.cleanupServerSslEngine(engine);
            ssc.delete();
        }
    }

    private static void runTasksIfNeeded(SSLEngine engine) {
        if (engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            while (true) {
                Runnable task;
                if ((task = engine.getDelegatedTask()) == null) {
                    Assert.assertNotEquals((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_TASK), (Object)((Object)engine.getHandshakeStatus()));
                    break;
                }
                task.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExtractMasterkeyWorksCorrectly() throws Exception {
        if (this.protocolCipherCombo != SSLEngineTest.ProtocolCipherCombo.tlsv12()) {
            return;
        }
        SelfSignedCertificate cert = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).protocols(this.protocols()).ciphers(this.ciphers()).sslProvider(SslProvider.OPENSSL).build());
        SSLEngine serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(cert.certificate()).protocols(this.protocols()).ciphers(this.ciphers()).sslProvider(SslProvider.OPENSSL).build());
        SSLEngine clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        String enabledCipher = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256";
        try {
            Assume.assumeTrue((String)"The diffie hellman cipher is not supported on your runtime.", (boolean)Arrays.asList(clientEngine.getSupportedCipherSuites()).contains("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"));
            clientEngine.setEnabledCipherSuites(new String[]{"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"});
            serverEngine.setEnabledCipherSuites(new String[]{"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"});
            int appBufferMax = clientEngine.getSession().getApplicationBufferSize();
            int netBufferMax = clientEngine.getSession().getPacketBufferSize();
            ByteBuffer clientIn = ByteBuffer.allocate(appBufferMax + 50);
            ByteBuffer serverIn = ByteBuffer.allocate(appBufferMax + 50);
            ByteBuffer cTOs = ByteBuffer.allocate(netBufferMax);
            ByteBuffer sTOc = ByteBuffer.allocate(netBufferMax);
            ByteBuffer clientOut = ByteBuffer.wrap("Hi Server, I'm Client".getBytes(CharsetUtil.US_ASCII));
            ByteBuffer serverOut = ByteBuffer.wrap("Hello Client, I'm Server".getBytes(CharsetUtil.US_ASCII));
            boolean asserted = false;
            for (int i = 0; i < 1000; ++i) {
                clientEngine.wrap(clientOut, cTOs);
                serverEngine.wrap(serverOut, sTOc);
                cTOs.flip();
                sTOc.flip();
                OpenSslEngineTest.runTasksIfNeeded(clientEngine);
                OpenSslEngineTest.runTasksIfNeeded(serverEngine);
                clientEngine.unwrap(sTOc, clientIn);
                serverEngine.unwrap(cTOs, serverIn);
                OpenSslEngineTest.runTasksIfNeeded(clientEngine);
                OpenSslEngineTest.runTasksIfNeeded(serverEngine);
                if (clientOut.limit() == serverIn.position() && serverOut.limit() == clientIn.position()) {
                    byte[] serverRandom = SSL.getServerRandom((long)this.unwrapEngine(serverEngine).sslPointer());
                    byte[] clientRandom = SSL.getClientRandom((long)this.unwrapEngine(clientEngine).sslPointer());
                    byte[] serverMasterKey = SSL.getMasterKey((long)this.unwrapEngine(serverEngine).sslPointer());
                    byte[] clientMasterKey = SSL.getMasterKey((long)this.unwrapEngine(clientEngine).sslPointer());
                    asserted = true;
                    Assert.assertArrayEquals((byte[])serverMasterKey, (byte[])clientMasterKey);
                    cTOs.flip();
                    sTOc.flip();
                    int keySize = 16;
                    int macSize = 32;
                    int keyBlockSize = 2 * keySize + 2 * macSize;
                    byte[] seed = new byte[serverRandom.length + clientRandom.length];
                    System.arraycopy(serverRandom, 0, seed, 0, serverRandom.length);
                    System.arraycopy(clientRandom, 0, seed, serverRandom.length, clientRandom.length);
                    byte[] keyBlock = PseudoRandomFunction.hash((byte[])serverMasterKey, (byte[])"key expansion".getBytes(CharsetUtil.US_ASCII), (byte[])seed, (int)keyBlockSize, (String)"HmacSha256");
                    int offset = 0;
                    byte[] clientWriteMac = Arrays.copyOfRange(keyBlock, offset, offset + macSize);
                    byte[] serverWriteMac = Arrays.copyOfRange(keyBlock, offset += macSize, offset + macSize);
                    byte[] clientWriteKey = Arrays.copyOfRange(keyBlock, offset += macSize, offset + keySize);
                    byte[] serverWriteKey = Arrays.copyOfRange(keyBlock, offset += keySize, offset + keySize);
                    offset += keySize;
                    cTOs.position(cTOs.position() + 5);
                    byte[] ciphertext = new byte[cTOs.remaining()];
                    cTOs.get(ciphertext);
                    byte[] clientWriteIV = Arrays.copyOfRange(ciphertext, 0, 16);
                    ciphertext = Arrays.copyOfRange(ciphertext, 16, ciphertext.length);
                    SecretKeySpec secretKey = new SecretKeySpec(clientWriteKey, "AES");
                    IvParameterSpec ivForCBC = new IvParameterSpec(clientWriteIV);
                    Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
                    cipher.init(2, (Key)secretKey, ivForCBC);
                    byte[] plaintext = cipher.doFinal(ciphertext);
                    Assert.assertTrue((boolean)new String(plaintext).startsWith("Hi Server, I'm Client"));
                    break;
                }
                cTOs.compact();
                sTOc.compact();
            }
            Assert.assertTrue((String)"The assertions were never executed.", (boolean)asserted);
        }
        finally {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            cert.delete();
        }
    }

    @Override
    @Test
    public void testSessionLocalWhenNonMutualWithKeyManager() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testSessionLocalWhenNonMutualWithKeyManager();
    }

    @Override
    protected SslProvider sslClientProvider() {
        return SslProvider.OPENSSL;
    }

    @Override
    protected SslProvider sslServerProvider() {
        return SslProvider.OPENSSL;
    }

    private static ApplicationProtocolConfig acceptingNegotiator(ApplicationProtocolConfig.Protocol protocol, String ... supportedProtocols) {
        return new ApplicationProtocolConfig(protocol, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, supportedProtocols);
    }

    @Override
    protected SSLEngine wrapEngine(SSLEngine engine) {
        if (PlatformDependent.javaVersion() >= 8) {
            return Java8SslTestUtils.wrapSSLEngineForTesting(engine);
        }
        return engine;
    }

    ReferenceCountedOpenSslEngine unwrapEngine(SSLEngine engine) {
        if (engine instanceof JdkSslEngine) {
            return (ReferenceCountedOpenSslEngine)((JdkSslEngine)engine).getWrappedEngine();
        }
        return (ReferenceCountedOpenSslEngine)engine;
    }

    @Override
    protected SslContext wrapContext(SslContext context) {
        if (context instanceof OpenSslContext) {
            ((OpenSslContext)context).setUseTasks(this.useTasks);
        }
        return context;
    }
}

