/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;
import org.junit.Assert;
import org.junit.Test;

public class ApplicationProtocolNegotiationHandlerTest {
    @Test
    public void testHandshakeFailure() {
        ApplicationProtocolNegotiationHandler alpnHandler = new ApplicationProtocolNegotiationHandler("http/1.1"){

            protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                Assert.fail();
            }
        };
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{alpnHandler});
        SSLHandshakeException exception = new SSLHandshakeException("error");
        SslHandshakeCompletionEvent completionEvent = new SslHandshakeCompletionEvent((Throwable)exception);
        channel.pipeline().fireUserEventTriggered((Object)completionEvent);
        channel.pipeline().fireExceptionCaught((Throwable)new DecoderException((Throwable)exception));
        Assert.assertNull((Object)channel.pipeline().context((ChannelHandler)alpnHandler));
        Assert.assertFalse((boolean)channel.finishAndReleaseAll());
    }

    @Test
    public void testHandshakeSuccess() throws NoSuchAlgorithmException {
        final AtomicBoolean configureCalled = new AtomicBoolean(false);
        ApplicationProtocolNegotiationHandler alpnHandler = new ApplicationProtocolNegotiationHandler("http/1.1"){

            protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                configureCalled.set(true);
                Assert.assertEquals((Object)"http/1.1", (Object)protocol);
            }
        };
        SSLEngine engine = SSLContext.getDefault().createSSLEngine();
        engine.setUseClientMode(false);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new SslHandler(engine), alpnHandler});
        channel.pipeline().fireUserEventTriggered((Object)SslHandshakeCompletionEvent.SUCCESS);
        Assert.assertNull((Object)channel.pipeline().context((ChannelHandler)alpnHandler));
        Assert.assertTrue((boolean)channel.finishAndReleaseAll());
        Assert.assertTrue((boolean)configureCalled.get());
    }

    @Test(expected=IllegalStateException.class)
    public void testHandshakeSuccessButNoSslHandler() {
        ApplicationProtocolNegotiationHandler alpnHandler = new ApplicationProtocolNegotiationHandler("http/1.1"){

            protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                Assert.fail();
            }
        };
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{alpnHandler});
        try {
            channel.pipeline().fireUserEventTriggered((Object)SslHandshakeCompletionEvent.SUCCESS);
        }
        finally {
            Assert.assertNull((Object)channel.pipeline().context((ChannelHandler)alpnHandler));
            Assert.assertFalse((boolean)channel.finishAndReleaseAll());
        }
    }
}

