/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.Java8SslTestUtils;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslContext;
import io.netty.handler.ssl.OpenSslTestUtils;
import io.netty.handler.ssl.SSLEngineTest;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslProvider;
import io.netty.util.internal.PlatformDependent;
import java.util.ArrayList;
import java.util.Collection;
import javax.net.ssl.SSLEngine;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class OpenSslJdkSslEngineInteroptTest
extends SSLEngineTest {
    private final boolean useTasks;

    @Parameterized.Parameters(name="{index}: bufferType = {0}, combo = {1}, delegate = {2}, useTasks = {3}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (SSLEngineTest.BufferType type : SSLEngineTest.BufferType.values()) {
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv12(), false, false});
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv12(), false, true});
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv12(), true, false});
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv12(), true, true});
            if (PlatformDependent.javaVersion() < 11 || !OpenSsl.isTlsv13Supported()) continue;
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv13(), false, false});
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv13(), false, true});
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv13(), true, false});
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv13(), true, true});
        }
        return params;
    }

    public OpenSslJdkSslEngineInteroptTest(SSLEngineTest.BufferType type, SSLEngineTest.ProtocolCipherCombo combo, boolean delegate, boolean useTasks) {
        super(type, combo, delegate);
        this.useTasks = useTasks;
    }

    @BeforeClass
    public static void checkOpenSsl() {
        Assume.assumeTrue((boolean)OpenSsl.isAvailable());
    }

    @Override
    protected SslProvider sslClientProvider() {
        return SslProvider.OPENSSL;
    }

    @Override
    protected SslProvider sslServerProvider() {
        return SslProvider.JDK;
    }

    @Override
    @Ignore
    public void testMutualAuthValidClientCertChainTooLongFailOptionalClientAuth() throws Exception {
    }

    @Override
    @Ignore
    public void testMutualAuthValidClientCertChainTooLongFailRequireClientAuth() throws Exception {
    }

    @Override
    @Test
    public void testMutualAuthInvalidIntermediateCASucceedWithOptionalClientAuth() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthInvalidIntermediateCASucceedWithOptionalClientAuth();
    }

    @Override
    @Test
    public void testMutualAuthInvalidIntermediateCAFailWithOptionalClientAuth() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthInvalidIntermediateCAFailWithOptionalClientAuth();
    }

    @Override
    @Test
    public void testMutualAuthInvalidIntermediateCAFailWithRequiredClientAuth() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthInvalidIntermediateCAFailWithRequiredClientAuth();
    }

    @Override
    @Test
    public void testSessionAfterHandshakeKeyManagerFactoryMutualAuth() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testSessionAfterHandshakeKeyManagerFactoryMutualAuth();
    }

    @Override
    protected boolean mySetupMutualAuthServerIsValidServerException(Throwable cause) {
        return super.mySetupMutualAuthServerIsValidServerException(cause) || OpenSslJdkSslEngineInteroptTest.causedBySSLException(cause);
    }

    @Override
    public void testHandshakeSession() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testHandshakeSession();
    }

    @Override
    @Test
    public void testSupportedSignatureAlgorithms() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testSupportedSignatureAlgorithms();
    }

    @Override
    protected SSLEngine wrapEngine(SSLEngine engine) {
        return Java8SslTestUtils.wrapSSLEngineForTesting(engine);
    }

    @Override
    protected SslContext wrapContext(SslContext context) {
        if (context instanceof OpenSslContext) {
            ((OpenSslContext)context).setUseTasks(this.useTasks);
        }
        return context;
    }
}

