/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.JettyAlpnSslEngine;
import io.netty.handler.ssl.NotSslRecordException;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.SniCompletionEvent;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.DomainNameMapping;
import io.netty.util.DomainNameMappingBuilder;
import io.netty.util.Mapping;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.ResourcesUtil;
import io.netty.util.internal.StringUtil;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class SniHandlerTest {
    private final SslProvider provider;

    private static ApplicationProtocolConfig newApnConfig() {
        return new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"myprotocol"});
    }

    private static void assumeApnSupported(SslProvider provider) {
        switch (provider) {
            case OPENSSL: 
            case OPENSSL_REFCNT: {
                Assume.assumeTrue((boolean)OpenSsl.isAlpnSupported());
                break;
            }
            case JDK: {
                Assume.assumeTrue((boolean)JettyAlpnSslEngine.isAvailable());
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    private static SslContext makeSslContext(SslProvider provider, boolean apn) throws Exception {
        if (apn) {
            SniHandlerTest.assumeApnSupported(provider);
        }
        File keyFile = ResourcesUtil.getFile(SniHandlerTest.class, (String)"test_encrypted.pem");
        File crtFile = ResourcesUtil.getFile(SniHandlerTest.class, (String)"test.crt");
        SslContextBuilder sslCtxBuilder = SslContextBuilder.forServer((File)crtFile, (File)keyFile, (String)"12345").sslProvider(provider);
        if (apn) {
            sslCtxBuilder.applicationProtocolConfig(SniHandlerTest.newApnConfig());
        }
        return sslCtxBuilder.build();
    }

    private static SslContext makeSslClientContext(SslProvider provider, boolean apn) throws Exception {
        if (apn) {
            SniHandlerTest.assumeApnSupported(provider);
        }
        File crtFile = ResourcesUtil.getFile(SniHandlerTest.class, (String)"test.crt");
        SslContextBuilder sslCtxBuilder = SslContextBuilder.forClient().trustManager(crtFile).sslProvider(provider);
        if (apn) {
            sslCtxBuilder.applicationProtocolConfig(SniHandlerTest.newApnConfig());
        }
        return sslCtxBuilder.build();
    }

    @Parameterized.Parameters(name="{index}: sslProvider={0}")
    public static Iterable<?> data() {
        ArrayList<SslProvider> params = new ArrayList<SslProvider>(3);
        if (OpenSsl.isAvailable()) {
            params.add(SslProvider.OPENSSL);
            params.add(SslProvider.OPENSSL_REFCNT);
        }
        params.add(SslProvider.JDK);
        return params;
    }

    public SniHandlerTest(SslProvider provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonSslRecord() throws Exception {
        SslContext nettyContext = SniHandlerTest.makeSslContext(this.provider, false);
        try {
            final AtomicReference evtRef = new AtomicReference();
            SniHandler handler = new SniHandler(new DomainNameMappingBuilder((Object)nettyContext).build());
            EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{handler, new ChannelInboundHandlerAdapter(){

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    if (evt instanceof SslHandshakeCompletionEvent) {
                        Assert.assertTrue((boolean)evtRef.compareAndSet(null, (SslHandshakeCompletionEvent)evt));
                    }
                }
            }});
            try {
                byte[] bytes = new byte[1024];
                bytes[0] = 21;
                try {
                    ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])bytes)});
                    Assert.fail();
                }
                catch (DecoderException e) {
                    Assert.assertTrue((boolean)(e.getCause() instanceof NotSslRecordException));
                }
                Assert.assertFalse((boolean)ch.finish());
            }
            finally {
                ch.finishAndReleaseAll();
            }
            Assert.assertTrue((boolean)(((SslHandshakeCompletionEvent)evtRef.get()).cause() instanceof NotSslRecordException));
        }
        catch (Throwable throwable) {
            SniHandlerTest.releaseAll(nettyContext);
            throw throwable;
        }
        SniHandlerTest.releaseAll(nettyContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerNameParsing() throws Exception {
        SslContext nettyContext = SniHandlerTest.makeSslContext(this.provider, false);
        SslContext leanContext = SniHandlerTest.makeSslContext(this.provider, false);
        SslContext leanContext2 = SniHandlerTest.makeSslContext(this.provider, false);
        try {
            DomainNameMapping mapping = new DomainNameMappingBuilder((Object)nettyContext).add("*.netty.io", (Object)nettyContext).add("*.LEANCLOUD.CN", (Object)leanContext).add("chat4.leancloud.cn", (Object)leanContext2).build();
            final AtomicReference evtRef = new AtomicReference();
            SniHandler handler = new SniHandler(mapping);
            EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{handler, new ChannelInboundHandlerAdapter(){

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    if (evt instanceof SniCompletionEvent) {
                        Assert.assertTrue((boolean)evtRef.compareAndSet(null, (SniCompletionEvent)evt));
                    } else {
                        ctx.fireUserEventTriggered(evt);
                    }
                }
            }});
            try {
                String tlsHandshakeMessageHex1 = "16030100";
                String tlsHandshakeMessageHex = "c6010000c20303bb0855d66532c05a0ef784f7c384feeafa68b3b655ac7288650d5eed4aa3fb52000038c02cc030009fcca9cca8ccaac02bc02f009ec024c028006bc023c0270067c00ac0140039c009c0130033009d009c003d003c0035002f00ff0100006100000017001500001243484154342e4c45414e434c4f55442e434e000b000403000102000a000a0008001d00170019001800230000000d0020001e0601060206030501050205030401040204030301030203030201020202030016000000170000";
                ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])StringUtil.decodeHexDump((CharSequence)tlsHandshakeMessageHex1))});
                ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])StringUtil.decodeHexDump((CharSequence)tlsHandshakeMessageHex))});
                Assert.assertTrue((boolean)ch.finish());
                Assert.assertThat((Object)handler.hostname(), (Matcher)CoreMatchers.is((Object)"chat4.leancloud.cn"));
                Assert.assertThat((Object)handler.sslContext(), (Matcher)CoreMatchers.is((Object)leanContext));
                SniCompletionEvent evt = (SniCompletionEvent)evtRef.get();
                Assert.assertNotNull((Object)evt);
                Assert.assertEquals((Object)"chat4.leancloud.cn", (Object)evt.hostname());
                Assert.assertTrue((boolean)evt.isSuccess());
                Assert.assertNull((Object)evt.cause());
            }
            finally {
                ch.finishAndReleaseAll();
            }
        }
        catch (Throwable throwable) {
            SniHandlerTest.releaseAll(leanContext, leanContext2, nettyContext);
            throw throwable;
        }
        SniHandlerTest.releaseAll(leanContext, leanContext2, nettyContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=DecoderException.class)
    public void testNonAsciiServerNameParsing() throws Exception {
        SslContext nettyContext = SniHandlerTest.makeSslContext(this.provider, false);
        SslContext leanContext = SniHandlerTest.makeSslContext(this.provider, false);
        SslContext leanContext2 = SniHandlerTest.makeSslContext(this.provider, false);
        try {
            DomainNameMapping mapping = new DomainNameMappingBuilder((Object)nettyContext).add("*.netty.io", (Object)nettyContext).add("*.LEANCLOUD.CN", (Object)leanContext).add("chat4.leancloud.cn", (Object)leanContext2).build();
            SniHandler handler = new SniHandler(mapping);
            EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{handler});
            try {
                String tlsHandshakeMessageHex1 = "16030100";
                String tlsHandshakeMessageHex = "bd010000b90303a74225676d1814ba57faff3b3663656ed05ee9dbb2a4dbb1bb1c32d2ea5fc39e0000000100008c0000001700150000164348415434E380824C45414E434C4F5544E38082434E000b000403000102000a00340032000e000d0019000b000c00180009000a00160017000800060007001400150004000500120013000100020003000f0010001100230000000d0020001e060106020603050105020503040104020403030103020303020102020203000f00010133740000";
                ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])StringUtil.decodeHexDump((CharSequence)tlsHandshakeMessageHex1))});
                ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])StringUtil.decodeHexDump((CharSequence)tlsHandshakeMessageHex))});
            }
            finally {
                ch.finishAndReleaseAll();
            }
        }
        catch (Throwable throwable) {
            SniHandlerTest.releaseAll(leanContext, leanContext2, nettyContext);
            throw throwable;
        }
        SniHandlerTest.releaseAll(leanContext, leanContext2, nettyContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFallbackToDefaultContext() throws Exception {
        SslContext nettyContext = SniHandlerTest.makeSslContext(this.provider, false);
        SslContext leanContext = SniHandlerTest.makeSslContext(this.provider, false);
        SslContext leanContext2 = SniHandlerTest.makeSslContext(this.provider, false);
        try {
            DomainNameMapping mapping = new DomainNameMappingBuilder((Object)nettyContext).add("*.netty.io", (Object)nettyContext).add("*.LEANCLOUD.CN", (Object)leanContext).add("chat4.leancloud.cn", (Object)leanContext2).build();
            SniHandler handler = new SniHandler(mapping);
            EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{handler});
            byte[] message = new byte[]{22, 3, 1, 0, 0};
            try {
                ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])message)});
            }
            catch (Exception exception) {
                // empty catch block
            }
            ch.close();
            ByteBuf buf = (ByteBuf)ch.readOutbound();
            if (buf != null) {
                Assert.assertFalse((boolean)buf.isReadable());
                buf.release();
            }
            Assert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)false));
            Assert.assertThat((Object)handler.hostname(), (Matcher)CoreMatchers.nullValue());
            Assert.assertThat((Object)handler.sslContext(), (Matcher)CoreMatchers.is((Object)nettyContext));
        }
        catch (Throwable throwable) {
            SniHandlerTest.releaseAll(leanContext, leanContext2, nettyContext);
            throw throwable;
        }
        SniHandlerTest.releaseAll(leanContext, leanContext2, nettyContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSniWithApnHandler() throws Exception {
        SslContext nettyContext = SniHandlerTest.makeSslContext(this.provider, true);
        SslContext sniContext = SniHandlerTest.makeSslContext(this.provider, true);
        final SslContext clientContext = SniHandlerTest.makeSslClientContext(this.provider, true);
        try {
            final AtomicBoolean serverApnCtx = new AtomicBoolean(false);
            final AtomicBoolean clientApnCtx = new AtomicBoolean(false);
            final CountDownLatch serverApnDoneLatch = new CountDownLatch(1);
            final CountDownLatch clientApnDoneLatch = new CountDownLatch(1);
            DomainNameMapping mapping = new DomainNameMappingBuilder((Object)nettyContext).add("*.netty.io", (Object)nettyContext).add("sni.fake.site", (Object)sniContext).build();
            final SniHandler handler = new SniHandler(mapping);
            NioEventLoopGroup group = new NioEventLoopGroup(2);
            Channel serverChannel = null;
            Channel clientChannel = null;
            try {
                ServerBootstrap sb = new ServerBootstrap();
                sb.group((EventLoopGroup)group);
                sb.channel(NioServerSocketChannel.class);
                sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) throws Exception {
                        ChannelPipeline p = ch.pipeline();
                        p.addLast(new ChannelHandler[]{handler});
                        p.addLast(new ChannelHandler[]{new ApplicationProtocolNegotiationHandler("foo"){

                            protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                                serverApnCtx.set(ctx.pipeline().context((ChannelHandler)this) != null);
                                serverApnDoneLatch.countDown();
                            }
                        }});
                    }
                });
                Bootstrap cb = new Bootstrap();
                cb.group((EventLoopGroup)group);
                cb.channel(NioSocketChannel.class);
                cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) throws Exception {
                        ch.pipeline().addLast(new ChannelHandler[]{new SslHandler(clientContext.newEngine(ch.alloc(), "sni.fake.site", -1))});
                        ch.pipeline().addLast(new ChannelHandler[]{new ApplicationProtocolNegotiationHandler("foo"){

                            protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                                clientApnCtx.set(ctx.pipeline().context((ChannelHandler)this) != null);
                                clientApnDoneLatch.countDown();
                            }
                        }});
                    }
                });
                serverChannel = sb.bind((SocketAddress)new InetSocketAddress(0)).sync().channel();
                ChannelFuture ccf = cb.connect(serverChannel.localAddress());
                Assert.assertTrue((boolean)ccf.awaitUninterruptibly().isSuccess());
                clientChannel = ccf.channel();
                Assert.assertTrue((boolean)serverApnDoneLatch.await(5L, TimeUnit.SECONDS));
                Assert.assertTrue((boolean)clientApnDoneLatch.await(5L, TimeUnit.SECONDS));
                Assert.assertTrue((boolean)serverApnCtx.get());
                Assert.assertTrue((boolean)clientApnCtx.get());
                Assert.assertThat((Object)handler.hostname(), (Matcher)CoreMatchers.is((Object)"sni.fake.site"));
                Assert.assertThat((Object)handler.sslContext(), (Matcher)CoreMatchers.is((Object)sniContext));
            }
            finally {
                if (serverChannel != null) {
                    serverChannel.close().sync();
                }
                if (clientChannel != null) {
                    clientChannel.close().sync();
                }
                group.shutdownGracefully(0L, 0L, TimeUnit.MICROSECONDS);
            }
        }
        catch (Throwable throwable) {
            SniHandlerTest.releaseAll(clientContext, nettyContext, sniContext);
            throw throwable;
        }
        SniHandlerTest.releaseAll(clientContext, nettyContext, sniContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Test(timeout=30000L)
    public void testReplaceHandler() throws Exception {
        switch (9.$SwitchMap$io$netty$handler$ssl$SslProvider[this.provider.ordinal()]) {
            case 1: 
            case 2: {
                sniHost = "sni.netty.io";
                address = new LocalAddress("testReplaceHandler-" + Math.random());
                group = new DefaultEventLoopGroup(1);
                sc = null;
                cc = null;
                sslContext = null;
                cert = new SelfSignedCertificate();
                try {
                    sslServerContext = SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).sslProvider(this.provider).build();
                    mapping = new Mapping<String, SslContext>(){

                        public SslContext map(String input) {
                            return sslServerContext;
                        }
                    };
                    releasePromise = group.next().newPromise();
                    handler = new SniHandler((Mapping)mapping){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        protected void replaceHandler(ChannelHandlerContext ctx, String hostname, SslContext sslContext) throws Exception {
                            boolean success = false;
                            try {
                                Assert.assertEquals((long)1L, (long)((ReferenceCountedOpenSslContext)sslContext).refCnt());
                                SSLEngine sslEngine = sslContext.newEngine(ctx.alloc());
                                try {
                                    Assert.assertEquals((long)2L, (long)((ReferenceCountedOpenSslContext)sslContext).refCnt());
                                    CustomSslHandler customSslHandler = new CustomSslHandler(sslContext, sslEngine){

                                        @Override
                                        public void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
                                            try {
                                                super.handlerRemoved0(ctx);
                                            }
                                            finally {
                                                releasePromise.trySuccess(null);
                                            }
                                        }
                                    };
                                    ctx.pipeline().replace((ChannelHandler)this, CustomSslHandler.class.getName(), (ChannelHandler)customSslHandler);
                                    success = true;
                                }
                                finally {
                                    if (!success) {
                                        ReferenceCountUtil.safeRelease((Object)sslEngine);
                                    }
                                }
                            }
                            finally {
                                if (!success) {
                                    ReferenceCountUtil.safeRelease((Object)sslContext);
                                    releasePromise.cancel(true);
                                }
                            }
                        }
                    };
                    sb = new ServerBootstrap();
                    sc = ((ServerBootstrap)sb.group((EventLoopGroup)group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                        protected void initChannel(Channel ch) throws Exception {
                            ch.pipeline().addFirst(new ChannelHandler[]{handler});
                        }
                    }).bind((SocketAddress)address).syncUninterruptibly().channel();
                    sslContext = SslContextBuilder.forClient().sslProvider(this.provider).trustManager(InsecureTrustManagerFactory.INSTANCE).build();
                    cb = new Bootstrap();
                    cc = ((Bootstrap)((Bootstrap)((Bootstrap)cb.group((EventLoopGroup)group)).channel(LocalChannel.class)).handler((ChannelHandler)new SslHandler(sslContext.newEngine(ByteBufAllocator.DEFAULT, "sni.netty.io", -1)))).connect((SocketAddress)address).syncUninterruptibly().channel();
                    cc.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])"Hello, World!".getBytes())).syncUninterruptibly();
                    Assert.assertEquals((long)2L, (long)((ReferenceCounted)sslServerContext).refCnt());
                    cc.close().syncUninterruptibly();
                    if (!releasePromise.awaitUninterruptibly(10L, TimeUnit.SECONDS)) {
                        throw new IllegalStateException("It doesn't seem #replaceHandler() got called.");
                    }
                    Assert.assertEquals((long)0L, (long)((ReferenceCounted)sslServerContext).refCnt());
                    if (cc == null) ** GOTO lbl45
                }
                catch (Throwable var14_14) {
                    if (cc != null) {
                        cc.close().syncUninterruptibly();
                    }
                    if (sc != null) {
                        sc.close().syncUninterruptibly();
                    }
                    if (sslContext != null) {
                        ReferenceCountUtil.release(sslContext);
                    }
                    group.shutdownGracefully();
                    cert.delete();
                    throw var14_14;
                }
                cc.close().syncUninterruptibly();
lbl45:
                // 2 sources

                if (sc != null) {
                    sc.close().syncUninterruptibly();
                }
                if (sslContext != null) {
                    ReferenceCountUtil.release((Object)sslContext);
                }
                group.shutdownGracefully();
                cert.delete();
            }
            case 3: {
                return;
            }
        }
        throw new Error();
    }

    private static void releaseAll(SslContext ... contexts) {
        for (SslContext ctx : contexts) {
            ReferenceCountUtil.release((Object)ctx);
        }
    }

    @Test
    public void testNonFragmented() throws Exception {
        this.testWithFragmentSize(Integer.MAX_VALUE);
    }

    @Test
    public void testFragmented() throws Exception {
        this.testWithFragmentSize(50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testWithFragmentSize(int maxFragmentSize) throws Exception {
        String sni = "netty.io";
        SelfSignedCertificate cert = new SelfSignedCertificate();
        final SslContext context = SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).sslProvider(this.provider).build();
        try {
            EmbeddedChannel server = new EmbeddedChannel(new ChannelHandler[]{new SniHandler((DomainNameMapping)Mockito.mock(DomainNameMapping.class)){

                protected Future<SslContext> lookup(ChannelHandlerContext ctx, String hostname) {
                    Assert.assertEquals((Object)"netty.io", (Object)hostname);
                    return ctx.executor().newSucceededFuture((Object)context);
                }
            }});
            List<ByteBuf> buffers = SniHandlerTest.clientHelloInMultipleFragments(this.provider, "netty.io", maxFragmentSize);
            for (ByteBuf buffer : buffers) {
                server.writeInbound(new Object[]{buffer});
            }
            Assert.assertTrue((boolean)server.finishAndReleaseAll());
        }
        catch (Throwable throwable) {
            SniHandlerTest.releaseAll(context);
            cert.delete();
            throw throwable;
        }
        SniHandlerTest.releaseAll(context);
        cert.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ByteBuf> clientHelloInMultipleFragments(SslProvider provider, String hostname, int maxTlsPlaintextSize) throws SSLException {
        List<ByteBuf> list;
        EmbeddedChannel client = new EmbeddedChannel();
        SslContext ctx = SslContextBuilder.forClient().sslProvider(provider).trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        try {
            SslHandler sslHandler = ctx.newHandler(client.alloc(), hostname, -1);
            client.pipeline().addLast(new ChannelHandler[]{sslHandler});
            ByteBuf clientHello = (ByteBuf)client.readOutbound();
            List<ByteBuf> buffers = SniHandlerTest.split(clientHello, maxTlsPlaintextSize);
            Assert.assertTrue((boolean)client.finishAndReleaseAll());
            list = buffers;
        }
        catch (Throwable throwable) {
            SniHandlerTest.releaseAll(ctx);
            throw throwable;
        }
        SniHandlerTest.releaseAll(ctx);
        return list;
    }

    private static List<ByteBuf> split(ByteBuf clientHello, int maxSize) {
        short type = clientHello.readUnsignedByte();
        int version = clientHello.readUnsignedShort();
        int length = clientHello.readUnsignedShort();
        Assert.assertEquals((long)length, (long)clientHello.readableBytes());
        ArrayList<ByteBuf> result = new ArrayList<ByteBuf>();
        while (clientHello.readableBytes() > 0) {
            int toRead = Math.min(maxSize, clientHello.readableBytes());
            ByteBuf bb = clientHello.alloc().buffer(5 + toRead);
            bb.writeByte((int)type);
            bb.writeShort(version);
            bb.writeShort(toRead);
            bb.writeBytes(clientHello, toRead);
            result.add(bb);
        }
        clientHello.release();
        return result;
    }

    private static class CustomSslHandler
    extends SslHandler {
        private final SslContext sslContext;

        CustomSslHandler(SslContext sslContext, SSLEngine sslEngine) {
            super(sslEngine);
            this.sslContext = (SslContext)ObjectUtil.checkNotNull((Object)sslContext, (String)"sslContext");
        }

        public void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
            super.handlerRemoved0(ctx);
            ReferenceCountUtil.release((Object)this.sslContext);
        }
    }
}

