/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.proxy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.proxy.ProxyServer;
import io.netty.handler.proxy.TestMode;
import io.netty.handler.proxy.UnresponsiveHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.SocketUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

final class HttpProxyServer
extends ProxyServer {
    HttpProxyServer(boolean useSsl, TestMode testMode, InetSocketAddress destination) {
        super(useSsl, testMode, destination);
    }

    HttpProxyServer(boolean useSsl, TestMode testMode, InetSocketAddress destination, String username, String password) {
        super(useSsl, testMode, destination, username, password);
    }

    @Override
    protected void configure(SocketChannel ch) throws Exception {
        ChannelPipeline p = ch.pipeline();
        switch (this.testMode) {
            case INTERMEDIARY: {
                p.addLast(new ChannelHandler[]{new HttpServerCodec()});
                p.addLast(new ChannelHandler[]{new HttpObjectAggregator(1)});
                p.addLast(new ChannelHandler[]{new HttpIntermediaryHandler()});
                break;
            }
            case TERMINAL: {
                p.addLast(new ChannelHandler[]{new HttpServerCodec()});
                p.addLast(new ChannelHandler[]{new HttpObjectAggregator(1)});
                p.addLast(new ChannelHandler[]{new HttpTerminalHandler()});
                break;
            }
            case UNRESPONSIVE: {
                p.addLast(new ChannelHandler[]{UnresponsiveHandler.INSTANCE});
            }
        }
    }

    private boolean authenticate(ChannelHandlerContext ctx, FullHttpRequest req) {
        Assert.assertThat((Object)req.method(), (Matcher)CoreMatchers.is((Object)HttpMethod.CONNECT));
        if (this.testMode != TestMode.INTERMEDIARY) {
            ctx.pipeline().addBefore(ctx.name(), "lineDecoder", (ChannelHandler)new LineBasedFrameDecoder(64, false, true));
        }
        ctx.pipeline().remove(HttpObjectAggregator.class);
        ((HttpServerCodec)ctx.pipeline().get(HttpServerCodec.class)).removeInboundHandler();
        boolean authzSuccess = false;
        if (this.username != null) {
            String authz = req.headers().get((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION);
            if (authz != null) {
                String[] authzParts = authz.toString().split(" ", 2);
                ByteBuf authzBuf64 = Unpooled.copiedBuffer((CharSequence)authzParts[1], (Charset)CharsetUtil.US_ASCII);
                ByteBuf authzBuf = Base64.decode((ByteBuf)authzBuf64);
                String expectedAuthz = this.username + ':' + this.password;
                authzSuccess = "Basic".equals(authzParts[0]) && expectedAuthz.equals(authzBuf.toString(CharsetUtil.US_ASCII));
                authzBuf64.release();
                authzBuf.release();
            }
        } else {
            authzSuccess = true;
        }
        return authzSuccess;
    }

    private final class HttpTerminalHandler
    extends ProxyServer.TerminalHandler {
        private HttpTerminalHandler() {
            super(HttpProxyServer.this);
        }

        @Override
        protected boolean handleProxyProtocol(ChannelHandlerContext ctx, Object msg) throws Exception {
            DefaultFullHttpResponse res;
            FullHttpRequest req = (FullHttpRequest)msg;
            boolean sendGreeting = false;
            if (!HttpProxyServer.this.authenticate(ctx, req)) {
                res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED);
                res.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
            } else if (!req.uri().equals(HttpProxyServer.this.destination.getHostString() + ':' + HttpProxyServer.this.destination.getPort())) {
                res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN);
                res.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
            } else {
                res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
                sendGreeting = true;
            }
            ctx.write((Object)res);
            ((HttpServerCodec)ctx.pipeline().get(HttpServerCodec.class)).removeOutboundHandler();
            if (sendGreeting) {
                ctx.write((Object)Unpooled.copiedBuffer((CharSequence)"0\n", (Charset)CharsetUtil.US_ASCII));
            }
            return true;
        }
    }

    private final class HttpIntermediaryHandler
    extends ProxyServer.IntermediaryHandler {
        private SocketAddress intermediaryDestination;

        private HttpIntermediaryHandler() {
            super(HttpProxyServer.this);
        }

        @Override
        protected boolean handleProxyProtocol(ChannelHandlerContext ctx, Object msg) throws Exception {
            DefaultFullHttpResponse res;
            FullHttpRequest req = (FullHttpRequest)msg;
            if (!HttpProxyServer.this.authenticate(ctx, req)) {
                res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED);
                res.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
            } else {
                res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
                String uri = req.uri();
                int lastColonPos = uri.lastIndexOf(58);
                Assert.assertThat((Object)lastColonPos, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
                this.intermediaryDestination = SocketUtils.socketAddress((String)uri.substring(0, lastColonPos), (int)Integer.parseInt(uri.substring(lastColonPos + 1)));
            }
            ctx.write((Object)res);
            ((HttpServerCodec)ctx.pipeline().get(HttpServerCodec.class)).removeOutboundHandler();
            return true;
        }

        @Override
        protected SocketAddress intermediaryDestination() {
            return this.intermediaryDestination;
        }
    }
}

