/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.proxy;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.util.NetUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class HttpProxyHandlerTest {
    @Test
    public void testHostname() throws Exception {
        InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getByName("localhost"), 8080);
        HttpProxyHandlerTest.testInitialMessage(socketAddress, "localhost:8080", "localhost:8080", null, true);
    }

    @Test
    public void testHostnameUnresolved() throws Exception {
        InetSocketAddress socketAddress = InetSocketAddress.createUnresolved("localhost", 8080);
        HttpProxyHandlerTest.testInitialMessage(socketAddress, "localhost:8080", "localhost:8080", null, true);
    }

    @Test
    public void testHostHeaderWithHttpDefaultPort() throws Exception {
        InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getByName("localhost"), 80);
        HttpProxyHandlerTest.testInitialMessage(socketAddress, "localhost:80", "localhost:80", null, false);
    }

    @Test
    public void testHostHeaderWithHttpDefaultPortIgnored() throws Exception {
        InetSocketAddress socketAddress = InetSocketAddress.createUnresolved("localhost", 80);
        HttpProxyHandlerTest.testInitialMessage(socketAddress, "localhost:80", "localhost", null, true);
    }

    @Test
    public void testHostHeaderWithHttpsDefaultPort() throws Exception {
        InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getByName("localhost"), 443);
        HttpProxyHandlerTest.testInitialMessage(socketAddress, "localhost:443", "localhost:443", null, false);
    }

    @Test
    public void testHostHeaderWithHttpsDefaultPortIgnored() throws Exception {
        InetSocketAddress socketAddress = InetSocketAddress.createUnresolved("localhost", 443);
        HttpProxyHandlerTest.testInitialMessage(socketAddress, "localhost:443", "localhost", null, true);
    }

    @Test
    public void testIpv6() throws Exception {
        InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getByName("::1"), 8080);
        HttpProxyHandlerTest.testInitialMessage(socketAddress, "[::1]:8080", "[::1]:8080", null, true);
    }

    @Test
    public void testIpv6Unresolved() throws Exception {
        InetSocketAddress socketAddress = InetSocketAddress.createUnresolved("::1", 8080);
        HttpProxyHandlerTest.testInitialMessage(socketAddress, "[::1]:8080", "[::1]:8080", null, true);
    }

    @Test
    public void testIpv4() throws Exception {
        InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getByName("10.0.0.1"), 8080);
        HttpProxyHandlerTest.testInitialMessage(socketAddress, "10.0.0.1:8080", "10.0.0.1:8080", null, true);
    }

    @Test
    public void testIpv4Unresolved() throws Exception {
        InetSocketAddress socketAddress = InetSocketAddress.createUnresolved("10.0.0.1", 8080);
        HttpProxyHandlerTest.testInitialMessage(socketAddress, "10.0.0.1:8080", "10.0.0.1:8080", null, true);
    }

    @Test
    public void testCustomHeaders() throws Exception {
        InetSocketAddress socketAddress = InetSocketAddress.createUnresolved("10.0.0.1", 8080);
        HttpProxyHandlerTest.testInitialMessage(socketAddress, "10.0.0.1:8080", "10.0.0.1:8080", new DefaultHttpHeaders().add("CUSTOM_HEADER", (Object)"CUSTOM_VALUE1").add("CUSTOM_HEADER", (Object)"CUSTOM_VALUE2"), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExceptionDuringConnect() throws Exception {
        DefaultEventLoopGroup group = null;
        Channel serverChannel = null;
        Channel clientChannel = null;
        try {
            group = new DefaultEventLoopGroup(1);
            final LocalAddress addr = new LocalAddress("a");
            final AtomicReference exception = new AtomicReference();
            ChannelFuture sf = ((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannel.class)).group((EventLoopGroup)group).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addFirst(new ChannelHandler[]{new HttpResponseEncoder()});
                    DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_GATEWAY);
                    response.headers().add("name", (Object)"value");
                    response.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)"0");
                    ch.writeAndFlush((Object)response);
                }
            }).bind((SocketAddress)addr);
            serverChannel = sf.sync().channel();
            ChannelFuture cf = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(LocalChannel.class)).group((EventLoopGroup)group)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addFirst(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)addr)});
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            exception.set(cause);
                        }
                    }});
                }
            })).connect((SocketAddress)new InetSocketAddress("localhost", 1234));
            clientChannel = cf.sync().channel();
            clientChannel.close().sync();
            Assert.assertTrue((boolean)(exception.get() instanceof HttpProxyHandler.HttpProxyConnectException));
            HttpProxyHandler.HttpProxyConnectException actual = (HttpProxyHandler.HttpProxyConnectException)exception.get();
            Assert.assertNotNull((Object)actual.headers());
            Assert.assertEquals((Object)"value", (Object)actual.headers().get("name"));
        }
        finally {
            if (clientChannel != null) {
                clientChannel.close();
            }
            if (serverChannel != null) {
                serverChannel.close();
            }
            if (group != null) {
                group.shutdownGracefully();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testInitialMessage(InetSocketAddress socketAddress, String expectedUrl, String expectedHostHeader, HttpHeaders headers, boolean ignoreDefaultPortsInConnectHostHeader) throws Exception {
        InetSocketAddress proxyAddress = new InetSocketAddress(NetUtil.LOCALHOST, 8080);
        ChannelPromise promise = (ChannelPromise)Mockito.mock(ChannelPromise.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{promise});
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Mockito.when((Object)ctx.connect((SocketAddress)Mockito.same((Object)proxyAddress), (SocketAddress)Mockito.isNull(InetSocketAddress.class), (ChannelPromise)Mockito.same((Object)promise))).thenReturn((Object)promise);
        HttpProxyHandler handler = new HttpProxyHandler((SocketAddress)new InetSocketAddress(NetUtil.LOCALHOST, 8080), headers, ignoreDefaultPortsInConnectHostHeader);
        handler.connect(ctx, (SocketAddress)socketAddress, null, promise);
        FullHttpRequest request = (FullHttpRequest)handler.newInitialMessage(ctx);
        try {
            Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)request.protocolVersion());
            Assert.assertEquals((Object)expectedUrl, (Object)request.uri());
            HttpHeaders actualHeaders = request.headers();
            Assert.assertEquals((Object)expectedHostHeader, (Object)actualHeaders.get((CharSequence)HttpHeaderNames.HOST));
            if (headers != null) {
                for (String name : headers.names()) {
                    Assert.assertEquals((Object)headers.getAll(name), (Object)actualHeaders.getAll(name));
                }
            }
        }
        finally {
            request.release();
        }
        ((ChannelHandlerContext)Mockito.verify((Object)ctx)).connect((SocketAddress)proxyAddress, null, promise);
    }
}

