/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http2.helloworld.multiplex.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.example.http2.helloworld.multiplex.server.HelloWorldHttp2Handler;
import io.netty.example.http2.helloworld.multiplex.server.Http2OrHttpHandler;
import io.netty.example.http2.helloworld.server.HelloWorldHttp1Handler;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2MultiplexCodecBuilder;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.ssl.SslContext;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;

public class Http2ServerInitializer
extends ChannelInitializer<SocketChannel> {
    private static final HttpServerUpgradeHandler.UpgradeCodecFactory upgradeCodecFactory = new HttpServerUpgradeHandler.UpgradeCodecFactory(){

        public HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
            if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                return new Http2ServerUpgradeCodec(Http2MultiplexCodecBuilder.forServer((ChannelHandler)new HelloWorldHttp2Handler()).build());
            }
            return null;
        }
    };
    private final SslContext sslCtx;
    private final int maxHttpContentLength;

    public Http2ServerInitializer(SslContext sslCtx) {
        this(sslCtx, 16384);
    }

    public Http2ServerInitializer(SslContext sslCtx, int maxHttpContentLength) {
        if (maxHttpContentLength < 0) {
            throw new IllegalArgumentException("maxHttpContentLength (expected >= 0): " + maxHttpContentLength);
        }
        this.sslCtx = sslCtx;
        this.maxHttpContentLength = maxHttpContentLength;
    }

    public void initChannel(SocketChannel ch) {
        if (this.sslCtx != null) {
            this.configureSsl(ch);
        } else {
            this.configureClearText(ch);
        }
    }

    private void configureSsl(SocketChannel ch) {
        ch.pipeline().addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc()), new Http2OrHttpHandler()});
    }

    private void configureClearText(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        HttpServerCodec sourceCodec = new HttpServerCodec();
        p.addLast(new ChannelHandler[]{sourceCodec});
        p.addLast(new ChannelHandler[]{new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, upgradeCodecFactory)});
        p.addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<HttpMessage>(){

            protected void channelRead0(ChannelHandlerContext ctx, HttpMessage msg) throws Exception {
                System.err.println("Directly talking: " + msg.protocolVersion() + " (no upgrade was attempted)");
                ChannelPipeline pipeline = ctx.pipeline();
                ChannelHandlerContext thisCtx = pipeline.context((ChannelHandler)this);
                pipeline.addAfter(thisCtx.name(), null, (ChannelHandler)new HelloWorldHttp1Handler("Direct. No Upgrade Attempted."));
                pipeline.replace((ChannelHandler)this, null, (ChannelHandler)new HttpObjectAggregator(Http2ServerInitializer.this.maxHttpContentLength));
                ctx.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
            }
        }});
        p.addLast(new ChannelHandler[]{new UserEventLogger()});
    }

    private static class UserEventLogger
    extends ChannelInboundHandlerAdapter {
        private UserEventLogger() {
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            System.out.println("User Event Triggered: " + evt);
            ctx.fireUserEventTriggered(evt);
        }
    }
}

