/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.udt.echo.bytes;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.example.udt.echo.bytes.ByteEchoClient;

public class ByteEchoClientHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final ByteBuf message = Unpooled.buffer((int)ByteEchoClient.SIZE);

    public ByteEchoClientHandler() {
        super(false);
        for (int i = 0; i < this.message.capacity(); ++i) {
            this.message.writeByte((int)((byte)i));
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        System.err.println("ECHO active " + NioUdtProvider.socketUDT((Channel)ctx.channel()).toStringOptions());
        ctx.writeAndFlush((Object)this.message);
    }

    public void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
        ctx.write((Object)msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

