/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http2.helloworld.multiplex.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.example.http2.helloworld.multiplex.server.HelloWorldHttp2Handler;
import io.netty.example.http2.helloworld.server.HelloWorldHttp1Handler;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http2.Http2CodecBuilder;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;

public class Http2OrHttpHandler
extends ApplicationProtocolNegotiationHandler {
    private static final int MAX_CONTENT_LENGTH = 102400;

    protected Http2OrHttpHandler() {
        super("http/1.1");
    }

    protected void configurePipeline(ChannelHandlerContext ctx, String protocol) throws Exception {
        if ("h2".equals(protocol)) {
            ctx.pipeline().addLast(new ChannelHandler[]{new Http2CodecBuilder(true, (ChannelHandler)new HelloWorldHttp2Handler()).build()});
            return;
        }
        if ("http/1.1".equals(protocol)) {
            ctx.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec(), new HttpObjectAggregator(102400), new HelloWorldHttp1Handler("ALPN Negotiation")});
            return;
        }
        throw new IllegalStateException("unknown protocol: " + protocol);
    }
}

