/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.snoop;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.example.http.snoop.HttpSnoopServerHandler;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SslContext;

public class HttpSnoopServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final SslContext sslCtx;

    public HttpSnoopServerInitializer(SslContext sslCtx) {
        this.sslCtx = sslCtx;
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        if (this.sslCtx != null) {
            p.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
        }
        p.addLast(new ChannelHandler[]{new HttpRequestDecoder()});
        p.addLast(new ChannelHandler[]{new HttpResponseEncoder()});
        p.addLast(new ChannelHandler[]{new HttpSnoopServerHandler()});
    }
}

