/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http2.tiles;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.example.http2.Http2ExampleUtil;
import io.netty.example.http2.tiles.Html;
import io.netty.example.http2.tiles.ImageCache;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.util.concurrent.TimeUnit;

public class Http2RequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final String LATENCY_FIELD_NAME = "latency";
    private static final int MIN_LATENCY = 0;
    private static final int MAX_LATENCY = 1000;
    private static final String IMAGE_COORDINATE_Y = "y";
    private static final String IMAGE_COORDINATE_X = "x";

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        QueryStringDecoder queryString = new QueryStringDecoder(request.uri());
        String streamId = this.streamId(request);
        int latency = Http2ExampleUtil.toInt(Http2ExampleUtil.firstValue(queryString, LATENCY_FIELD_NAME), 0);
        if (latency < 0 || latency > 1000) {
            this.sendBadRequest(ctx, streamId);
            return;
        }
        String x = Http2ExampleUtil.firstValue(queryString, IMAGE_COORDINATE_X);
        String y = Http2ExampleUtil.firstValue(queryString, IMAGE_COORDINATE_Y);
        if (x == null || y == null) {
            this.handlePage(ctx, streamId, latency, request);
        } else {
            this.handleImage(x, y, ctx, streamId, latency, request);
        }
    }

    private void sendBadRequest(ChannelHandlerContext ctx, String streamId) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, Unpooled.EMPTY_BUFFER);
        this.streamId((FullHttpResponse)response, streamId);
        ctx.writeAndFlush((Object)response);
    }

    private void handleImage(String x, String y, ChannelHandlerContext ctx, String streamId, int latency, FullHttpRequest request) {
        ByteBuf image = ImageCache.INSTANCE.image(Integer.valueOf(x), Integer.valueOf(y));
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, image.duplicate());
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"image/jpeg");
        this.sendResponse(ctx, streamId, latency, (FullHttpResponse)response, request);
    }

    private void handlePage(ChannelHandlerContext ctx, String streamId, int latency, FullHttpRequest request) {
        byte[] body = Html.body(latency);
        ByteBuf content = ctx.alloc().buffer(Html.HEADER.length + body.length + Html.FOOTER.length);
        content.writeBytes(Html.HEADER);
        content.writeBytes(body);
        content.writeBytes(Html.FOOTER);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=UTF-8");
        this.sendResponse(ctx, streamId, latency, (FullHttpResponse)response, request);
    }

    protected void sendResponse(final ChannelHandlerContext ctx, String streamId, int latency, final FullHttpResponse response, FullHttpRequest request) {
        HttpUtil.setContentLength((HttpMessage)response, (long)response.content().readableBytes());
        this.streamId(response, streamId);
        ctx.executor().schedule(new Runnable(){

            @Override
            public void run() {
                ctx.writeAndFlush((Object)response);
            }
        }, (long)latency, TimeUnit.MILLISECONDS);
    }

    private String streamId(FullHttpRequest request) {
        return request.headers().get((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
    }

    private void streamId(FullHttpResponse response, String streamId) {
        response.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)streamId);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }
}

