/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http2.tiles;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.example.http2.tiles.FallbackRequestHandler;
import io.netty.example.http2.tiles.Http2RequestHandler;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapter;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;

public class Http2OrHttpHandler
extends ApplicationProtocolNegotiationHandler {
    private static final int MAX_CONTENT_LENGTH = 102400;

    protected Http2OrHttpHandler() {
        super("http/1.1");
    }

    protected void configurePipeline(ChannelHandlerContext ctx, String protocol) throws Exception {
        if ("h2".equals(protocol)) {
            Http2OrHttpHandler.configureHttp2(ctx);
            return;
        }
        if ("http/1.1".equals(protocol)) {
            Http2OrHttpHandler.configureHttp1(ctx);
            return;
        }
        throw new IllegalStateException("unknown protocol: " + protocol);
    }

    private static void configureHttp2(ChannelHandlerContext ctx) {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(true);
        DefaultHttp2FrameWriter writer = new DefaultHttp2FrameWriter();
        DefaultHttp2FrameReader reader = new DefaultHttp2FrameReader();
        InboundHttp2ToHttpAdapter listener = new InboundHttp2ToHttpAdapter.Builder((Http2Connection)connection).propagateSettings(true).validateHttpHeaders(false).maxContentLength(102400).build();
        ctx.pipeline().addLast(new ChannelHandler[]{new HttpToHttp2ConnectionHandler((Http2Connection)connection, (Http2FrameReader)reader, (Http2FrameWriter)writer, (Http2FrameListener)listener)});
        ctx.pipeline().addLast(new ChannelHandler[]{new Http2RequestHandler()});
    }

    private static void configureHttp1(ChannelHandlerContext ctx) throws Exception {
        ctx.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec(), new HttpObjectAggregator(102400), new FallbackRequestHandler()});
    }
}

