/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http2.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.example.http2.server.HelloWorldHttp2Handler;
import io.netty.example.http2.server.Http2OrHttpHandler;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.ssl.SslContext;
import java.util.Collections;

public class Http2ServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final SslContext sslCtx;

    public Http2ServerInitializer(SslContext sslCtx) {
        this.sslCtx = sslCtx;
    }

    public void initChannel(SocketChannel ch) {
        if (this.sslCtx != null) {
            this.configureSsl(ch);
        } else {
            Http2ServerInitializer.configureClearText(ch);
        }
    }

    private void configureSsl(SocketChannel ch) {
        ch.pipeline().addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc()), new Http2OrHttpHandler()});
    }

    private static void configureClearText(SocketChannel ch) {
        HttpServerCodec sourceCodec = new HttpServerCodec();
        Http2ServerUpgradeCodec upgradeCodec = new Http2ServerUpgradeCodec((Http2ConnectionHandler)new HelloWorldHttp2Handler());
        HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, Collections.singletonList(upgradeCodec), 65536);
        ch.pipeline().addLast(new ChannelHandler[]{sourceCodec});
        ch.pipeline().addLast(new ChannelHandler[]{upgradeHandler});
        ch.pipeline().addLast(new ChannelHandler[]{new UserEventLogger()});
    }

    private static class UserEventLogger
    extends ChannelInboundHandlerAdapter {
        private UserEventLogger() {
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            System.out.println("User Event Triggered: " + evt);
            ctx.fireUserEventTriggered(evt);
        }
    }
}

