/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http2.client;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.example.http2.client.Http2SettingsHandler;
import io.netty.example.http2.client.HttpResponseHandler;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2InboundFrameLogger;
import io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapter;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.SslContext;

public class Http2ClientInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Http2FrameLogger logger = new Http2FrameLogger(LogLevel.INFO, Http2ClientInitializer.class);
    private final SslContext sslCtx;
    private final int maxContentLength;
    private HttpToHttp2ConnectionHandler connectionHandler;
    private HttpResponseHandler responseHandler;
    private Http2SettingsHandler settingsHandler;

    public Http2ClientInitializer(SslContext sslCtx, int maxContentLength) {
        this.sslCtx = sslCtx;
        this.maxContentLength = maxContentLength;
    }

    public void initChannel(SocketChannel ch) throws Exception {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
        Http2FrameWriter frameWriter = Http2ClientInitializer.frameWriter();
        this.connectionHandler = new HttpToHttp2ConnectionHandler((Http2Connection)connection, Http2ClientInitializer.frameReader(), frameWriter, (Http2FrameListener)new DelegatingDecompressorFrameListener((Http2Connection)connection, (Http2FrameListener)new InboundHttp2ToHttpAdapter.Builder((Http2Connection)connection).maxContentLength(this.maxContentLength).propagateSettings(true).build()));
        this.responseHandler = new HttpResponseHandler();
        this.settingsHandler = new Http2SettingsHandler(ch.newPromise());
        if (this.sslCtx != null) {
            this.configureSsl(ch);
        } else {
            this.configureClearText(ch);
        }
    }

    public HttpResponseHandler responseHandler() {
        return this.responseHandler;
    }

    public Http2SettingsHandler settingsHandler() {
        return this.settingsHandler;
    }

    protected void configureEndOfPipeline(ChannelPipeline pipeline) {
        pipeline.addLast("Http2SettingsHandler", (ChannelHandler)this.settingsHandler);
        pipeline.addLast("HttpResponseHandler", (ChannelHandler)this.responseHandler);
    }

    private void configureSsl(SocketChannel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("SslHandler", (ChannelHandler)this.sslCtx.newHandler(ch.alloc()));
        pipeline.addLast("Http2Handler", (ChannelHandler)this.connectionHandler);
        this.configureEndOfPipeline(pipeline);
    }

    private void configureClearText(SocketChannel ch) {
        HttpClientCodec sourceCodec = new HttpClientCodec();
        Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec((Http2ConnectionHandler)this.connectionHandler);
        HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 65536);
        ch.pipeline().addLast("Http2SourceCodec", (ChannelHandler)sourceCodec);
        ch.pipeline().addLast("Http2UpgradeHandler", (ChannelHandler)upgradeHandler);
        ch.pipeline().addLast("Http2UpgradeRequestHandler", (ChannelHandler)new UpgradeRequestHandler());
        ch.pipeline().addLast("Logger", (ChannelHandler)new UserEventLogger());
    }

    private static Http2FrameReader frameReader() {
        return new Http2InboundFrameLogger((Http2FrameReader)new DefaultHttp2FrameReader(), logger);
    }

    private static Http2FrameWriter frameWriter() {
        return new Http2OutboundFrameLogger((Http2FrameWriter)new DefaultHttp2FrameWriter(), logger);
    }

    private static class UserEventLogger
    extends ChannelInboundHandlerAdapter {
        private UserEventLogger() {
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            System.out.println("User Event Triggered: " + evt);
            ctx.fireUserEventTriggered(evt);
        }
    }

    private final class UpgradeRequestHandler
    extends ChannelInboundHandlerAdapter {
        private UpgradeRequestHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            DefaultFullHttpRequest upgradeRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
            ctx.writeAndFlush((Object)upgradeRequest);
            ctx.fireChannelActive();
            ctx.pipeline().remove((ChannelHandler)this);
            Http2ClientInitializer.this.configureEndOfPipeline(ctx.pipeline());
        }
    }
}

