/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.socksproxy;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.example.socksproxy.SocksServerConnectHandler;
import io.netty.example.socksproxy.SocksServerUtils;
import io.netty.handler.codec.socksx.SocksRequest;
import io.netty.handler.codec.socksx.v4.Socks4CmdRequest;
import io.netty.handler.codec.socksx.v4.Socks4CmdType;
import io.netty.handler.codec.socksx.v5.Socks5AuthResponse;
import io.netty.handler.codec.socksx.v5.Socks5AuthScheme;
import io.netty.handler.codec.socksx.v5.Socks5AuthStatus;
import io.netty.handler.codec.socksx.v5.Socks5CmdRequest;
import io.netty.handler.codec.socksx.v5.Socks5CmdRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5CmdType;
import io.netty.handler.codec.socksx.v5.Socks5InitResponse;
import io.netty.handler.codec.socksx.v5.Socks5Request;

@ChannelHandler.Sharable
public final class SocksServerHandler
extends SimpleChannelInboundHandler<SocksRequest> {
    public static final SocksServerHandler INSTANCE = new SocksServerHandler();

    private SocksServerHandler() {
    }

    public void channelRead0(ChannelHandlerContext ctx, SocksRequest socksRequest) throws Exception {
        switch (socksRequest.protocolVersion()) {
            case SOCKS4a: {
                Socks4CmdRequest socksV4CmdRequest = (Socks4CmdRequest)socksRequest;
                if (socksV4CmdRequest.cmdType() == Socks4CmdType.CONNECT) {
                    ctx.pipeline().addLast(new ChannelHandler[]{new SocksServerConnectHandler()});
                    ctx.pipeline().remove((ChannelHandler)this);
                    ctx.fireChannelRead((Object)socksRequest);
                    break;
                }
                ctx.close();
                break;
            }
            case SOCKS5: {
                switch (((Socks5Request)socksRequest).requestType()) {
                    case INIT: {
                        ctx.pipeline().addFirst(new ChannelHandler[]{new Socks5CmdRequestDecoder()});
                        ctx.write((Object)new Socks5InitResponse(Socks5AuthScheme.NO_AUTH));
                        break;
                    }
                    case AUTH: {
                        ctx.pipeline().addFirst(new ChannelHandler[]{new Socks5CmdRequestDecoder()});
                        ctx.write((Object)new Socks5AuthResponse(Socks5AuthStatus.SUCCESS));
                        break;
                    }
                    case CMD: {
                        Socks5CmdRequest socks5CmdRequest = (Socks5CmdRequest)socksRequest;
                        if (socks5CmdRequest.cmdType() == Socks5CmdType.CONNECT) {
                            ctx.pipeline().addLast(new ChannelHandler[]{new SocksServerConnectHandler()});
                            ctx.pipeline().remove((ChannelHandler)this);
                            ctx.fireChannelRead((Object)socksRequest);
                            break;
                        }
                        ctx.close();
                        break;
                    }
                    case UNKNOWN: {
                        ctx.close();
                    }
                }
                break;
            }
            case UNKNOWN: {
                ctx.close();
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable throwable) {
        throwable.printStackTrace();
        SocksServerUtils.closeOnFlush(ctx.channel());
    }
}

