/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.socksproxy;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.example.socksproxy.SocksServerHandler;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.socksx.SocksProtocolVersion;
import io.netty.handler.codec.socksx.v4.Socks4CmdRequestDecoder;
import io.netty.handler.codec.socksx.v4.Socks4MessageEncoder;
import io.netty.handler.codec.socksx.v5.Socks5InitRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5MessageEncoder;
import java.util.List;

public class SocksPortUnificationServerHandler
extends ByteToMessageDecoder {
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        ChannelPipeline p = ctx.pipeline();
        SocksProtocolVersion version = SocksProtocolVersion.valueOf((byte)in.readByte());
        System.out.println(version);
        in.resetReaderIndex();
        switch (version) {
            case SOCKS4a: {
                p.addLast(new ChannelHandler[]{new Socks4CmdRequestDecoder()});
                p.addLast(new ChannelHandler[]{Socks4MessageEncoder.INSTANCE});
                break;
            }
            case SOCKS5: {
                p.addLast(new ChannelHandler[]{new Socks5InitRequestDecoder()});
                p.addLast(new ChannelHandler[]{Socks5MessageEncoder.INSTANCE});
                break;
            }
            case UNKNOWN: {
                in.clear();
                ctx.close();
                return;
            }
        }
        p.addLast(new ChannelHandler[]{SocksServerHandler.INSTANCE});
        p.remove((ChannelHandler)this);
    }
}

