/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.spdy.client;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.spdy.SpdyHttpHeaders;

public class SpdyClientStreamIdHandler
extends ChannelOutboundHandlerAdapter {
    private int currentStreamId = 1;

    public boolean acceptOutboundMessage(Object msg) {
        return msg instanceof HttpMessage;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        HttpMessage httpMsg;
        if (this.acceptOutboundMessage(msg) && !(httpMsg = (HttpMessage)msg).headers().contains("x-spdy-stream-id")) {
            SpdyHttpHeaders.setStreamId((HttpMessage)httpMsg, (int)this.currentStreamId);
            this.currentStreamId += 2;
        }
        ctx.write(msg, promise);
    }
}

