/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.udt.echo.message;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.udt.UdtChannel;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.example.udt.echo.message.MsgEchoClientHandler;
import io.netty.example.udt.util.UtilConsoleReporter;
import io.netty.example.udt.util.UtilThreadFactory;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class MsgEchoClient {
    private static final Logger log = Logger.getLogger(MsgEchoClient.class.getName());
    private final String host;
    private final int port;
    private final int messageSize;

    public MsgEchoClient(String host, int port, int messageSize) {
        this.host = host;
        this.port = port;
        this.messageSize = messageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        UtilThreadFactory connectFactory = new UtilThreadFactory("connect");
        NioEventLoopGroup connectGroup = new NioEventLoopGroup(1, (ThreadFactory)connectFactory, NioUdtProvider.MESSAGE_PROVIDER);
        try {
            Bootstrap boot = new Bootstrap();
            ((Bootstrap)((Bootstrap)boot.group((EventLoopGroup)connectGroup)).channelFactory(NioUdtProvider.MESSAGE_CONNECTOR)).handler((ChannelHandler)new ChannelInitializer<UdtChannel>(){

                public void initChannel(UdtChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO), new MsgEchoClientHandler(MsgEchoClient.this.messageSize)});
                }
            });
            ChannelFuture f = boot.connect(this.host, this.port).sync();
            f.channel().closeFuture().sync();
        }
        finally {
            connectGroup.shutdownGracefully();
        }
    }

    public static void main(String[] args) throws Exception {
        log.info("init");
        UtilConsoleReporter.enable(3L, TimeUnit.SECONDS);
        String host = "localhost";
        int port = 1234;
        int messageSize = 65536;
        new MsgEchoClient("localhost", 1234, 65536).run();
        log.info("done");
    }
}

