/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.websocketx.sslserver;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.Security;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

public final class WebSocketSslServerSslContext {
    private static final Logger logger = Logger.getLogger(WebSocketSslServerSslContext.class.getName());
    private static final String PROTOCOL = "TLS";
    private final SSLContext _serverContext;

    public static WebSocketSslServerSslContext getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebSocketSslServerSslContext() {
        SSLContext serverContext = null;
        try {
            String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
            if (algorithm == null) {
                algorithm = "SunX509";
            }
            try {
                String keyStoreFilePath = System.getProperty("keystore.file.path");
                String keyStoreFilePassword = System.getProperty("keystore.file.password");
                KeyStore ks = KeyStore.getInstance("JKS");
                FileInputStream fin = new FileInputStream(keyStoreFilePath);
                ks.load(fin, keyStoreFilePassword.toCharArray());
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
                kmf.init(ks, keyStoreFilePassword.toCharArray());
                serverContext = SSLContext.getInstance(PROTOCOL);
                serverContext.init(kmf.getKeyManagers(), null, null);
            }
            catch (Exception e) {
                throw new Error("Failed to initialize the server-side SSLContext", e);
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error initializing SslContextManager.", ex);
            System.exit(1);
        }
        finally {
            this._serverContext = serverContext;
        }
    }

    public SSLContext serverContext() {
        return this._serverContext;
    }

    private static interface SingletonHolder {
        public static final WebSocketSslServerSslContext INSTANCE = new WebSocketSslServerSslContext();
    }
}

