/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.spdy.server;

import io.netty.channel.ChannelInboundHandler;
import io.netty.example.spdy.server.SpdyServerHandler;
import io.netty.example.spdy.server.SpdyServerProvider;
import io.netty.handler.codec.spdy.SpdyOrHttpChooser;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.npn.NextProtoNego;

public class SpdyOrHttpHandler
extends SpdyOrHttpChooser {
    private static final Logger logger = Logger.getLogger(SpdyOrHttpHandler.class.getName());
    private static final int MAX_CONTENT_LENGTH = 102400;

    public SpdyOrHttpHandler() {
        this(102400, 102400);
    }

    public SpdyOrHttpHandler(int maxSpdyContentLength, int maxHttpContentLength) {
        super(maxSpdyContentLength, maxHttpContentLength);
    }

    protected SpdyOrHttpChooser.SelectedProtocol getProtocol(SSLEngine engine) {
        SpdyServerProvider provider = (SpdyServerProvider)NextProtoNego.get((SSLEngine)engine);
        SpdyOrHttpChooser.SelectedProtocol selectedProtocol = provider.getSelectedProtocol();
        logger.info("Selected Protocol is " + selectedProtocol);
        return selectedProtocol;
    }

    protected ChannelInboundHandler createHttpRequestHandlerForHttp() {
        return new SpdyServerHandler();
    }
}

