/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.websocketx.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.http.websocketx.client.WebSocketClientHandler;
import io.netty.example.http.websocketx.client.WebSocketSslClientContextFactory;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslHandler;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import javax.net.ssl.SSLEngine;

public final class WebSocketClientRunner {
    private final URI uri;

    public WebSocketClientRunner(URI uri) {
        this.uri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            String msg;
            int defaultPort;
            ChannelInitializer initializer;
            final WebSocketClientHandler handler = new WebSocketClientHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)this.uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, (HttpHeaders)new DefaultHttpHeaders()));
            String protocol = this.uri.getScheme();
            if ("ws".equals(protocol)) {
                initializer = new ChannelInitializer<SocketChannel>(){

                    public void initChannel(SocketChannel ch) throws Exception {
                        ch.pipeline().addLast("http-codec", (ChannelHandler)new HttpClientCodec()).addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(8192)).addLast("ws-handler", (ChannelHandler)handler);
                    }
                };
                defaultPort = 80;
            } else if ("wss".equals(protocol)) {
                initializer = new ChannelInitializer<SocketChannel>(){

                    public void initChannel(SocketChannel ch) throws Exception {
                        SSLEngine engine = WebSocketSslClientContextFactory.getContext().createSSLEngine();
                        engine.setUseClientMode(true);
                        ch.pipeline().addFirst("ssl", (ChannelHandler)new SslHandler(engine)).addLast("http-codec", (ChannelHandler)new HttpClientCodec()).addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(8192)).addLast("ws-handler", (ChannelHandler)handler);
                    }
                };
                defaultPort = 443;
            } else {
                throw new IllegalArgumentException("Unsupported protocol: " + protocol);
            }
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)initializer);
            int port = this.uri.getPort();
            if (this.uri.getPort() == -1) {
                port = defaultPort;
            }
            Channel ch = b.connect(this.uri.getHost(), port).sync().channel();
            handler.handshakeFuture().sync();
            BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
            while ((msg = console.readLine()) != null) {
                TextWebSocketFrame frame;
                if ("bye".equals(msg.toLowerCase())) {
                    ch.writeAndFlush((Object)new CloseWebSocketFrame());
                    ch.closeFuture().sync();
                    break;
                }
                if ("ping".equals(msg.toLowerCase())) {
                    frame = new PingWebSocketFrame(Unpooled.copiedBuffer((byte[])new byte[]{8, 1, 8, 1}));
                    ch.writeAndFlush((Object)frame);
                    continue;
                }
                frame = new TextWebSocketFrame(msg);
                ch.writeAndFlush((Object)frame);
            }
        }
        finally {
            group.shutdownGracefully();
        }
    }
}

